/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.category;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.internal.core.isite.ISite;
import org.eclipse.pde.internal.core.isite.ISiteBundle;
import org.eclipse.pde.internal.core.isite.ISiteCategory;
import org.eclipse.pde.internal.core.isite.ISiteCategoryDefinition;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.ui.editor.FormOutlinePage;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.category.CategoryLabelProvider;
import org.eclipse.pde.internal.ui.editor.category.SiteBundleAdapter;
import org.eclipse.pde.internal.ui.editor.category.SiteFeatureAdapter;

public class CategoryOutlinePage
extends FormOutlinePage {
    private LabelProvider fLabelProvider;

    public CategoryOutlinePage(PDEFormEditor editor) {
        super(editor);
    }

    @Override
    protected Object[] getChildren(Object parent) {
        ISiteCategoryDefinition catDef;
        ISiteModel model;
        PDEFormPage page;
        ISiteModel model2;
        if (parent instanceof PDEFormPage && (model2 = (ISiteModel)(page = (PDEFormPage)((Object)parent)).getModel()).isValid()) {
            ISite site = model2.getSite();
            if (page.getId().equals("ius")) {
                ISiteBundle[] bundles;
                ISiteFeature[] features;
                ArrayList<Serializable> result = new ArrayList<Serializable>();
                ISiteCategoryDefinition[] catDefs = site.getCategoryDefinitions();
                Collections.addAll(result, catDefs);
                ISiteFeature[] iSiteFeatureArray = features = site.getFeatures();
                int n = features.length;
                int n2 = 0;
                while (n2 < n) {
                    ISiteFeature feature = iSiteFeatureArray[n2];
                    if (feature.getCategories().length == 0) {
                        result.add(new SiteFeatureAdapter(null, feature));
                    }
                    ++n2;
                }
                ISiteBundle[] iSiteBundleArray = bundles = site.getBundles();
                int n3 = bundles.length;
                n = 0;
                while (n < n3) {
                    ISiteBundle bundle = iSiteBundleArray[n];
                    if (bundle.getCategories().length == 0) {
                        result.add(new SiteBundleAdapter(null, bundle));
                    }
                    ++n;
                }
                return result.toArray();
            }
        }
        if (parent instanceof ISiteCategoryDefinition && (model = (catDef = (ISiteCategoryDefinition)parent).getModel()).isValid()) {
            ISiteBundle[] bundles;
            int n;
            ISite site = model.getSite();
            ISiteFeature[] features = site.getFeatures();
            HashSet<Serializable> result = new HashSet<Serializable>();
            ISiteFeature[] iSiteFeatureArray = features;
            int n4 = features.length;
            int bundle = 0;
            while (bundle < n4) {
                ISiteCategory[] cats;
                ISiteFeature feature = iSiteFeatureArray[bundle];
                ISiteCategory[] iSiteCategoryArray = cats = feature.getCategories();
                n = cats.length;
                int n5 = 0;
                while (n5 < n) {
                    ISiteCategory cat = iSiteCategoryArray[n5];
                    if (cat.getDefinition() != null && cat.getDefinition().equals(catDef)) {
                        result.add(new SiteFeatureAdapter(cat.getName(), feature));
                    }
                    ++n5;
                }
                ++bundle;
            }
            ISiteBundle[] iSiteBundleArray = bundles = site.getBundles();
            int n6 = bundles.length;
            n4 = 0;
            while (n4 < n6) {
                ISiteCategory[] cats;
                ISiteBundle bundle2 = iSiteBundleArray[n4];
                ISiteCategory[] iSiteCategoryArray = cats = bundle2.getCategories();
                int n7 = cats.length;
                n = 0;
                while (n < n7) {
                    ISiteCategory cat = iSiteCategoryArray[n];
                    if (cat.getDefinition() != null && cat.getDefinition().equals(catDef)) {
                        result.add(new SiteBundleAdapter(cat.getName(), bundle2));
                    }
                    ++n;
                }
                ++n4;
            }
            return result.toArray();
        }
        return new Object[0];
    }

    @Override
    protected String getParentPageId(Object item) {
        String pageId = null;
        if (item instanceof ISiteCategoryDefinition || item instanceof SiteFeatureAdapter || item instanceof SiteBundleAdapter) {
            pageId = "ius";
        }
        if (pageId != null) {
            return pageId;
        }
        return super.getParentPageId(item);
    }

    @Override
    public ILabelProvider createLabelProvider() {
        this.fLabelProvider = new CategoryLabelProvider();
        return this.fLabelProvider;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.fLabelProvider != null) {
            this.fLabelProvider.dispose();
        }
    }
}

