/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.decorators;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.core.internal.info.GitItemStateFactory;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.internal.decorators.DecoratableResourceGroup;
import org.eclipse.egit.ui.internal.decorators.DecoratableResourceMapping;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.IWorkingSet;

public class DecoratableWorkingSet
extends DecoratableResourceGroup {
    public static final int WORKING_SET = 39321;
    private ResourceMapping mapping;

    public DecoratableWorkingSet(ResourceMapping mapping) throws IOException {
        super(mapping);
        this.mapping = mapping;
        IProject[] projects = mapping.getProjects();
        if (projects == null || projects.length == 0) {
            return;
        }
        HashSet<Repository> repositories = new HashSet<Repository>(projects.length);
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IndexDiffData diffData;
            IProject prj = iProjectArray[n2];
            RepositoryMapping repoMapping = RepositoryMapping.getMapping((IProject)prj);
            if (repoMapping != null && (diffData = GitItemStateFactory.getInstance().getIndexDiffDataOrNull((IResource)prj)) != null) {
                this.setTracked(true);
                Repository repository = repoMapping.getRepository();
                Object repoRelative = this.makeRepoRelative(repository, (IResource)prj);
                if (repoRelative != null) {
                    repoRelative = (String)repoRelative + "/";
                    Set modified = diffData.getModified();
                    Set conflicting = diffData.getConflicting();
                    if (this.containsPrefix(modified, (String)repoRelative)) {
                        this.setDirty(true);
                    }
                    if (this.containsPrefix(conflicting, (String)repoRelative)) {
                        this.setConflicts(true);
                    }
                    repositories.add(repository);
                }
            }
            ++n2;
        }
        if (repositories.isEmpty()) {
            return;
        }
        this.someShared = true;
        DecoratableResourceMapping.decorateRepositoryInformation(this, repositories);
    }

    @Override
    public int getType() {
        return 39321;
    }

    @Override
    public String getName() {
        IWorkingSet ws = (IWorkingSet)this.mapping.getModelObject();
        return ws.getLabel();
    }

    @Nullable
    private String makeRepoRelative(Repository repository, IResource res) {
        if (repository.isBare()) {
            return null;
        }
        IPath location = res.getLocation();
        if (location == null) {
            return null;
        }
        return Repository.stripWorkDir((File)repository.getWorkTree(), (File)location.toFile());
    }

    private boolean containsPrefix(Set<String> collection, String prefix) {
        if (prefix.length() == 1 && !collection.isEmpty()) {
            return true;
        }
        for (String path : collection) {
            if (!path.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

