/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.ui;

import java.util.ArrayList;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.rcptt.core.model.IQ7Folder;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.launching.LaunchUtils;

public class NamedElementTester
extends PropertyTester {
    private static final String CONTAINS_NAMED_ELEMENTS_PROP = "containsNamedElements";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        try {
            IResource[] resources;
            if (!CONTAINS_NAMED_ELEMENTS_PROP.equals(property)) {
                return false;
            }
            StructuredSelection selection = new StructuredSelection(receiver);
            IResource[] iResourceArray = resources = LaunchUtils.getContext((ISelection)selection);
            int n = resources.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IResource res = iResourceArray[n2];
                if (RcpttCore.hasRcpttNature((IProject)res.getProject())) {
                    switch (res.getType()) {
                        case 4: {
                            IQ7Project project = RcpttCore.create((IProject)((IProject)res));
                            try {
                                IQ7Folder[] folders;
                                IQ7Folder[] iQ7FolderArray = folders = project.getFolders();
                                int n3 = folders.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IQ7Folder iq7Folder = iQ7FolderArray[n4];
                                    if (iq7Folder.containsQ7Resources()) {
                                        return true;
                                    }
                                    ++n4;
                                }
                            }
                            catch (ModelException e) {
                                Q7UIPlugin.log(e);
                            }
                            break;
                        }
                        case 2: {
                            IQ7Folder folder = (IQ7Folder)RcpttCore.create((IResource)res);
                            try {
                                if (folder.containsQ7Resources()) {
                                    return true;
                                }
                            }
                            catch (ModelException e) {
                                Q7UIPlugin.log(e);
                            }
                            try {
                                final ArrayList folders = new ArrayList();
                                res.accept(new IResourceVisitor(){

                                    public boolean visit(IResource resource) throws CoreException {
                                        if (resource.getType() == 2) {
                                            folders.add((IFolder)resource);
                                            return true;
                                        }
                                        return false;
                                    }
                                });
                                for (IFolder iFolder : folders) {
                                    IQ7Folder folder2 = (IQ7Folder)RcpttCore.create((IResource)iFolder);
                                    try {
                                        if (!folder2.containsQ7Resources()) continue;
                                        return true;
                                    }
                                    catch (ModelException e) {
                                        Q7UIPlugin.log(e);
                                    }
                                }
                            }
                            catch (CoreException e) {
                                Q7UIPlugin.log(e);
                            }
                            break;
                        }
                        case 1: {
                            if (!RcpttCore.isQ7File((IPath)res.getFullPath())) break;
                            return true;
                        }
                    }
                }
                ++n2;
            }
        }
        catch (InterruptedException e) {
            OperationCanceledException result = new OperationCanceledException();
            result.initCause((Throwable)e);
            throw result;
        }
    }
}

