/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.UnnecessaryArrayCreationFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

public class UnnecessaryArrayCreationCleanUpCore
extends AbstractMultiFix {
    public UnnecessaryArrayCreationCleanUpCore() {
        this(Collections.emptyMap());
    }

    public UnnecessaryArrayCreationCleanUpCore(Map<String, String> options) {
        super(options);
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.isEnabled("cleanup.remove_unnecessary_array_creation");
        Map<String, String> requiredOptions = null;
        return new CleanUpRequirements(requireAST, false, false, requiredOptions);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.remove_unnecessary_array_creation")) {
            return new String[]{MultiFixMessages.UnnecessaryArrayCreationCleanup_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        if (this.isEnabled("cleanup.remove_unnecessary_array_creation")) {
            return "List k= Arrays.asList(\"a\", \"b\", \"c\");\n";
        }
        return "List k= Arrays.asList(new String[] {\"a\", \"b\", \"c\"});\n";
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit) throws CoreException {
        if (!this.isEnabled("cleanup.remove_unnecessary_array_creation")) {
            return null;
        }
        ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> rewriteOperations = new ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation>();
        UnnecessaryArrayCreationFixCore.UnnecessaryArrayCreationFinder finder = new UnnecessaryArrayCreationFixCore.UnnecessaryArrayCreationFinder(true, rewriteOperations);
        unit.accept((ASTVisitor)finder);
        if (rewriteOperations.isEmpty()) {
            return null;
        }
        return new CompilationUnitRewriteOperationsFixCore(MultiFixMessages.UnnecessaryArrayCreationCleanup_description, unit, rewriteOperations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[0]));
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        return false;
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit, IProblemLocation[] problems) throws CoreException {
        return null;
    }
}

