/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.manipulation.ChangeCorrectionProposalCore;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTesterCore;
import org.eclipse.jdt.internal.corext.refactoring.sef.SelfEncapsulateFieldRefactoring;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;

public abstract class GetterSetterCorrectionBaseSubProcessor<T> {
    public static final String SELF_ENCAPSULATE_FIELD_COMMAND_ID = "org.eclipse.jdt.ui.correction.encapsulateField.assist";

    protected GetterSetterCorrectionBaseSubProcessor() {
    }

    public boolean addGetterSetterProposals(IInvocationContext context, ASTNode coveringNode, IProblemLocation[] locations, ArrayList<T> resultingCollections) {
        if (locations != null) {
            IProblemLocation[] iProblemLocationArray = locations;
            int n = locations.length;
            int n2 = 0;
            while (n2 < n) {
                IProblemLocation location = iProblemLocationArray[n2];
                int problemId = location.getProblemId();
                if (problemId == 570425421) {
                    return false;
                }
                if (problemId == 570425423) {
                    return false;
                }
                ++n2;
            }
        }
        return this.addGetterSetterProposals(context, coveringNode, resultingCollections, 7);
    }

    public void addGetterSetterProposals(IInvocationContext context, IProblemLocation location, Collection<T> proposals, int relevance) {
        this.addGetterSetterProposals(context, location.getCoveringNode(context.getASTRoot()), proposals, relevance);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean addGetterSetterProposals(IInvocationContext context, ASTNode coveringNode, Collection<T> proposals, int relevance) {
        void variableBinding;
        void sn;
        if (!(coveringNode instanceof SimpleName)) {
            return false;
        }
        SimpleName simpleName = (SimpleName)coveringNode;
        IBinding binding = sn.resolveBinding();
        if (!(binding instanceof IVariableBinding)) {
            return false;
        }
        IVariableBinding iVariableBinding = (IVariableBinding)binding;
        if (!variableBinding.isField()) {
            return false;
        }
        if (proposals == null) {
            return true;
        }
        T proposal = this.getProposal(context.getCompilationUnit(), (SimpleName)sn, (IVariableBinding)variableBinding, relevance);
        if (proposal != null) {
            proposals.add(proposal);
        }
        return true;
    }

    private T getProposal(ICompilationUnit cu, SimpleName sn, IVariableBinding variableBinding, int relevance) {
        SimpleName accessNode = sn;
        Name qualifier = null;
        boolean useSuper = false;
        ASTNode parent = sn.getParent();
        switch (parent.getNodeType()) {
            case 40: {
                accessNode = (Expression)parent;
                qualifier = ((QualifiedName)parent).getQualifier();
                break;
            }
            case 47: {
                accessNode = (Expression)parent;
                qualifier = ((SuperFieldAccess)parent).getQualifier();
                useSuper = true;
            }
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)sn.getAST());
        ProposalParameter gspc = new ProposalParameter(useSuper, cu, rewrite, (Expression)accessNode, (Expression)qualifier, variableBinding);
        if (ASTResolving.isWriteAccess((Name)sn)) {
            return this.createSetterProposal(gspc, relevance);
        }
        return this.createGetterProposal(gspc, relevance);
    }

    protected abstract T createNonNullMethodGetterProposal(String var1, ICompilationUnit var2, ASTRewrite var3, int var4);

    protected abstract T createFieldGetterProposal(int var1, IField var2);

    private T createGetterProposal(ProposalParameter context, int relevance) {
        IMethodBinding method = GetterSetterCorrectionBaseSubProcessor.findGetter(context);
        if (method != null) {
            Expression mi = GetterSetterCorrectionBaseSubProcessor.createMethodInvocation(context, method, null);
            context.astRewrite.replace((ASTNode)context.accessNode, (ASTNode)mi, null);
            String label = Messages.format(CorrectionMessages.GetterSetterCorrectionSubProcessor_replacewithgetter_description, BasicElementLabels.getJavaCodeString(ASTNodes.asString((ASTNode)context.accessNode)));
            return this.createNonNullMethodGetterProposal(label, context.compilationUnit, context.astRewrite, relevance);
        }
        IJavaElement element = context.variableBinding.getJavaElement();
        if (element instanceof IField) {
            IField field = (IField)element;
            try {
                if (RefactoringAvailabilityTesterCore.isSelfEncapsulateAvailable(field)) {
                    return this.createFieldGetterProposal(relevance, field);
                }
            }
            catch (JavaModelException e) {
                JavaManipulationPlugin.log(e);
            }
        }
        return null;
    }

    private static IMethodBinding findGetter(ProposalParameter context) {
        ITypeBinding returnType = context.variableBinding.getType();
        String getterName = GetterSetterUtil.getGetterName(context.variableBinding, context.compilationUnit.getJavaProject(), null, GetterSetterCorrectionBaseSubProcessor.isBoolean(context));
        ITypeBinding declaringType = context.variableBinding.getDeclaringClass();
        if (declaringType == null) {
            return null;
        }
        IMethodBinding getter = Bindings.findMethodInHierarchy(declaringType, getterName, new ITypeBinding[0]);
        if (getter != null && getter.getReturnType().isAssignmentCompatible(returnType) && Modifier.isStatic((int)getter.getModifiers()) == Modifier.isStatic((int)context.variableBinding.getModifiers())) {
            return getter;
        }
        return null;
    }

    private static Expression createMethodInvocation(ProposalParameter context, IMethodBinding method, Expression argument) {
        AST ast = context.astRewrite.getAST();
        Expression qualifier = context.qualifier;
        if (context.useSuper) {
            SuperMethodInvocation invocation = ast.newSuperMethodInvocation();
            invocation.setName(ast.newSimpleName(method.getName()));
            if (qualifier != null) {
                invocation.setQualifier((Name)context.astRewrite.createCopyTarget((ASTNode)qualifier));
            }
            if (argument != null) {
                invocation.arguments().add(argument);
            }
            return invocation;
        }
        MethodInvocation invocation = ast.newMethodInvocation();
        invocation.setName(ast.newSimpleName(method.getName()));
        if (qualifier != null) {
            invocation.setExpression((Expression)context.astRewrite.createCopyTarget((ASTNode)qualifier));
        }
        if (argument != null) {
            invocation.arguments().add(argument);
        }
        return invocation;
    }

    protected abstract T createMethodSetterProposal(String var1, ICompilationUnit var2, ASTRewrite var3, int var4);

    protected abstract T createFieldSetterProposal(int var1, IField var2);

    private T createSetterProposal(ProposalParameter context, int relevance) {
        boolean isBoolean = GetterSetterCorrectionBaseSubProcessor.isBoolean(context);
        String setterName = GetterSetterUtil.getSetterName(context.variableBinding, context.compilationUnit.getJavaProject(), null, isBoolean);
        ITypeBinding declaringType = context.variableBinding.getDeclaringClass();
        if (declaringType == null) {
            return null;
        }
        IMethodBinding method = Bindings.findMethodInHierarchy(declaringType, setterName, new ITypeBinding[]{context.variableBinding.getType()});
        if (method != null && Bindings.isVoidType(method.getReturnType()) && Modifier.isStatic((int)method.getModifiers()) == Modifier.isStatic((int)context.variableBinding.getModifiers())) {
            Expression assignedValue = GetterSetterCorrectionBaseSubProcessor.getAssignedValue(context);
            if (assignedValue == null) {
                return null;
            }
            Expression mi = GetterSetterCorrectionBaseSubProcessor.createMethodInvocation(context, method, assignedValue);
            context.astRewrite.replace(context.accessNode.getParent(), (ASTNode)mi, null);
            String label = Messages.format(CorrectionMessages.GetterSetterCorrectionSubProcessor_replacewithsetter_description, BasicElementLabels.getJavaCodeString(ASTNodes.asString((ASTNode)context.accessNode)));
            T proposal = this.createMethodSetterProposal(label, context.compilationUnit, context.astRewrite, relevance);
            return proposal;
        }
        IJavaElement element = context.variableBinding.getJavaElement();
        if (element instanceof IField) {
            IField field = (IField)element;
            try {
                if (RefactoringAvailabilityTesterCore.isSelfEncapsulateAvailable(field)) {
                    return this.createFieldSetterProposal(relevance, field);
                }
            }
            catch (JavaModelException e) {
                JavaManipulationPlugin.log(e);
            }
        }
        return null;
    }

    private static boolean isBoolean(ProposalParameter context) {
        boolean isBoolean;
        AST ast = context.astRewrite.getAST();
        boolean bl = isBoolean = ast.resolveWellKnownType("boolean") == context.variableBinding.getType();
        if (!isBoolean) {
            isBoolean = ast.resolveWellKnownType("java.lang.Boolean") == context.variableBinding.getType();
        }
        return isBoolean;
    }

    private static Expression getAssignedValue(ProposalParameter context) {
        ITypeBinding type;
        Expression result;
        ASTNode parent = context.accessNode.getParent();
        ASTRewrite astRewrite = context.astRewrite;
        IMethodBinding getter = GetterSetterCorrectionBaseSubProcessor.findGetter(context);
        SimpleName getterExpression = null;
        if (getter != null) {
            getterExpression = astRewrite.getAST().newSimpleName("placeholder");
        }
        if ((result = GetterSetterUtil.getAssignedValue(parent, astRewrite, (Expression)getterExpression, type = context.variableBinding.getType())) != null && getterExpression != null && getterExpression.getParent() != null) {
            getterExpression.getParent().setStructuralProperty(getterExpression.getLocationInParent(), (Object)GetterSetterCorrectionBaseSubProcessor.createMethodInvocation(context, getter, null));
        }
        return result;
    }

    private static class ProposalParameter {
        public final boolean useSuper;
        public final ICompilationUnit compilationUnit;
        public final ASTRewrite astRewrite;
        public final Expression accessNode;
        public final Expression qualifier;
        public final IVariableBinding variableBinding;

        public ProposalParameter(boolean useSuper, ICompilationUnit compilationUnit, ASTRewrite rewrite, Expression accessNode, Expression qualifier, IVariableBinding variableBinding) {
            this.useSuper = useSuper;
            this.compilationUnit = compilationUnit;
            this.astRewrite = rewrite;
            this.accessNode = accessNode;
            this.qualifier = qualifier;
            this.variableBinding = variableBinding;
        }
    }

    public static class SelfEncapsulateFieldProposalCore
    extends ChangeCorrectionProposalCore {
        private IField fField;

        public SelfEncapsulateFieldProposalCore(int relevance, IField field) {
            this(relevance, null, field);
        }

        public SelfEncapsulateFieldProposalCore(int relevance, Change change, IField field) {
            super(SelfEncapsulateFieldProposalCore.getDescription(field), change, relevance);
            this.fField = field;
            this.setCommandId(GetterSetterCorrectionBaseSubProcessor.SELF_ENCAPSULATE_FIELD_COMMAND_ID);
        }

        public IField getField() {
            return this.fField;
        }

        public static SelfEncapsulateFieldRefactoring getChangeRefactoring(IField field) throws CoreException {
            SelfEncapsulateFieldRefactoring refactoring = new SelfEncapsulateFieldRefactoring(field);
            refactoring.setVisibility(1);
            refactoring.setConsiderVisibility(false);
            refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
            refactoring.checkFinalConditions((IProgressMonitor)new NullProgressMonitor());
            return refactoring;
        }

        public static Change getChange(IField field) throws CoreException {
            SelfEncapsulateFieldRefactoring refactoring = SelfEncapsulateFieldProposalCore.getChangeRefactoring(field);
            Change createdChange = refactoring.createChange((IProgressMonitor)new NullProgressMonitor());
            return createdChange;
        }

        public static TextFileChange getChange(IField field, IFile file) throws CoreException {
            Change createdChange = SelfEncapsulateFieldProposalCore.getChange(field);
            if (createdChange instanceof CompositeChange) {
                CompositeChange c = (CompositeChange)createdChange;
                Change[] changeArray = c.getChildren();
                int n = changeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Change curr = changeArray[n2];
                    if (curr instanceof TextFileChange) {
                        TextFileChange tfc = (TextFileChange)curr;
                        if (file == null || tfc.getFile().equals((Object)file)) {
                            return tfc;
                        }
                    }
                    ++n2;
                }
            }
            return null;
        }

        public static String getDescription(IField field) {
            return Messages.format(CorrectionMessages.GetterSetterCorrectionSubProcessor_creategetterunsingencapsulatefield_description, BasicElementLabels.getJavaElementName(field.getElementName()));
        }

        @Override
        public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
            return CorrectionMessages.GetterSetterCorrectionSubProcessor_additional_info;
        }
    }
}

