/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.core.ecl.parser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.Pipeline;
import org.eclipse.rcptt.tesla.core.protocol.MultiSelectionItem;
import org.eclipse.rcptt.tesla.core.protocol.SetSelection;
import org.eclipse.rcptt.tesla.ecl.TeslaScriptletFactory;
import org.eclipse.rcptt.tesla.ecl.model.GetCell;
import org.eclipse.rcptt.tesla.recording.core.ecl.parser.TeslaParser;
import org.eclipse.rcptt.tesla.recording.core.ecl.parser.TeslaParserUtil;

public class SetSelectionParser {
    public Command parse(SetSelection c, TeslaParser p) {
        if (c.getPath() != null && c.getPath().size() > 0) {
            Command result;
            ArrayList<Command> paths = new ArrayList<Command>();
            Command first = this.makeItemFrom(c);
            if (first != null) {
                paths.add(first);
            }
            EList additionalItems = c.getAdditionalItems();
            for (MultiSelectionItem multiSelectionItem : additionalItems) {
                paths.add(this.makeItemFrom(multiSelectionItem));
            }
            Command tree = p.selectorOf(c.getElement());
            Command select = TeslaParserUtil.makeSelect(paths);
            if (additionalItems.isEmpty() && this.shouldJoinNextCommand() && (result = this.tryJoinNextCommand(p, tree, select, first)) != null) {
                return result;
            }
            return TeslaScriptletFactory.makePipe((Command[])new Command[]{tree, select});
        }
        Command combo = p.selectorOf(c.getElement());
        return TeslaScriptletFactory.makePipe((Command[])new Command[]{combo, TeslaParserUtil.makeSelect(c.getPattern())});
    }

    private Command tryJoinNextCommand(TeslaParser p, Command tree, Command select, Command first) {
        int mark = p.pos;
        Command cut = null;
        while (p.pos < p.teslaCommands.size()) {
            Command nextCmd = p.teslaCommand();
            if (nextCmd == null) continue;
            cut = TeslaParserUtil.cut(nextCmd, tree);
            if (TeslaParserUtil.cut(cut, first) == null) break;
            cut = null;
            break;
        }
        if (cut != null) {
            if (this.shouldMakeSeq(cut)) {
                return TeslaScriptletFactory.makeWith((Command)tree, (Command)TeslaScriptletFactory.seq((Command[])new Command[]{select, cut}));
            }
            return TeslaScriptletFactory.makePipe((Command[])new Command[]{tree, select, cut});
        }
        p.pos = mark;
        return null;
    }

    protected Command makeItemFrom(SetSelection c) {
        return TeslaParserUtil.makeItem((List<String>)c.getPath());
    }

    protected Command makeItemFrom(MultiSelectionItem msi) {
        return TeslaParserUtil.makeItem((List<String>)msi.getPath());
    }

    protected boolean shouldJoinNextCommand() {
        return true;
    }

    protected boolean shouldMakeSeq(Command cut) {
        if (cut instanceof Pipeline) {
            EList cmds = ((Pipeline)cut).getCommands();
            return cmds.size() > 0 && cmds.get(0) instanceof GetCell;
        }
        return false;
    }
}

