/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class SynchronizePropertiesWizardPage
extends WizardPage {
    public static final int ALL_FEATURES = 2;
    public static final int SELECTED_FEATURES = 1;
    private static final String PREFIX = PDEPlugin.getPluginId() + ".synchronizeFeatueEnvironment.";
    private static final String PROP_SYNCHRO_MODE = PREFIX + "mode";
    private Button fAllFeaturesButton;
    private final ISiteModel fModel;
    private Button fSelectedFeaturesButton;
    private final ISiteFeature[] fSiteFeatures;

    public SynchronizePropertiesWizardPage(ISiteFeature[] siteFeatures, ISiteModel model) {
        super("featureSelection");
        this.setTitle(PDEUIMessages.SynchronizePropertiesWizardPage_title);
        this.setDescription(PDEUIMessages.SynchronizePropertiesWizardPage_desc);
        this.fSiteFeatures = siteFeatures != null ? siteFeatures : new ISiteFeature[]{};
        this.fModel = model;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        Group group = new Group(container, 16);
        GridData gd = new GridData(768);
        layout = new GridLayout();
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gd);
        group.setText(PDEUIMessages.SynchronizePropertiesWizardPage_group);
        this.fSelectedFeaturesButton = new Button((Composite)group, 16);
        this.fSelectedFeaturesButton.setText(PDEUIMessages.SynchronizePropertiesWizardPage_selectedFeatures);
        gd = new GridData(768);
        this.fSelectedFeaturesButton.setLayoutData((Object)gd);
        this.fAllFeaturesButton = new Button((Composite)group, 16);
        this.fAllFeaturesButton.setText(PDEUIMessages.SynchronizePropertiesWizardPage_allFeatures);
        gd = new GridData(768);
        this.fAllFeaturesButton.setLayoutData((Object)gd);
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        this.loadSettings();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.pde.doc.user.feature_synchronize_versions");
    }

    public boolean finish() {
        final int mode = this.saveSettings();
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                try {
                    SynchronizePropertiesWizardPage.this.runOperation(mode, monitor);
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    private IFeature getFeature(ISiteFeature siteFeature) {
        IFeatureModel model = PDECore.getDefault().getFeatureModelManager().findFeatureModel(siteFeature.getId(), siteFeature.getVersion());
        if (model != null) {
            return model.getFeature();
        }
        return null;
    }

    private void importEnvironment(ISiteFeature siteFeature) {
        IFeatureImport[] imports;
        IFeature feature = this.getFeature(siteFeature);
        if (feature == null) {
            return;
        }
        boolean patch = false;
        IFeatureImport[] iFeatureImportArray = imports = feature.getImports();
        int n = imports.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureImport featureImport = iFeatureImportArray[n2];
            if (featureImport.isPatch()) {
                patch = true;
                break;
            }
            ++n2;
        }
        boolean isPatch = patch;
        this.getShell().getDisplay().syncExec(() -> {
            try {
                siteFeature.setNL(feature.getNL());
                siteFeature.setOS(feature.getOS());
                siteFeature.setWS(feature.getWS());
                siteFeature.setArch(feature.getArch());
                siteFeature.setIsPatch(isPatch);
            }
            catch (CoreException ce) {
                PDEPlugin.log(ce);
            }
        });
    }

    private void importEnvironment(ISiteFeature[] siteFeatures, IProgressMonitor monitor) {
        ISiteFeature[] iSiteFeatureArray = siteFeatures;
        int n = siteFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteFeature siteFeature = iSiteFeatureArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            monitor.subTask(siteFeature.getId() + "_" + siteFeature.getVersion());
            this.importEnvironment(siteFeature);
            monitor.worked(1);
            ++n2;
        }
    }

    private void loadSettings() {
        if (this.fSiteFeatures != null) {
            IDialogSettings settings = this.getDialogSettings();
            if (settings.get(PROP_SYNCHRO_MODE) != null) {
                int mode = settings.getInt(PROP_SYNCHRO_MODE);
                switch (mode) {
                    case 1: {
                        this.fSelectedFeaturesButton.setSelection(true);
                        break;
                    }
                    case 2: {
                        this.fAllFeaturesButton.setSelection(true);
                        break;
                    }
                    default: {
                        this.fSelectedFeaturesButton.setSelection(true);
                        break;
                    }
                }
            } else {
                this.fSelectedFeaturesButton.setSelection(true);
            }
        } else {
            this.fSelectedFeaturesButton.setEnabled(false);
            this.fAllFeaturesButton.setSelection(true);
        }
    }

    private void runOperation(int mode, IProgressMonitor monitor) {
        ISiteFeature[] siteFeatures = mode == 1 ? this.fSiteFeatures : this.fModel.getSite().getFeatures();
        int size = siteFeatures.length;
        monitor.beginTask(PDEUIMessages.SynchronizePropertiesWizardPage_synchronizing, size);
        this.importEnvironment(siteFeatures, monitor);
    }

    private int saveSettings() {
        IDialogSettings settings = this.getDialogSettings();
        int mode = 1;
        if (this.fAllFeaturesButton.getSelection()) {
            mode = 2;
        }
        settings.put(PROP_SYNCHRO_MODE, mode);
        return mode;
    }
}

