/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.filediff;

import java.io.File;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.ui.internal.commit.DiffViewer;
import org.eclipse.egit.ui.internal.filediff.AbstractFileDiffHandler;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.jface.viewers.IStructuredSelection;

public class FileDiffOpenWorkingTreeHandler
extends AbstractFileDiffHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = this.getSelection(event);
        List<FileDiff> diffs = this.getDiffs(selection, Predicate.not(FileDiff::isSubmodule));
        if (!diffs.isEmpty()) {
            for (FileDiff diff : diffs) {
                String relativePath = diff.getPath();
                File file = new Path(diff.getRepository().getWorkTree().getAbsolutePath()).append(relativePath).toFile();
                DiffViewer.openFileInEditor(file, -1);
            }
        }
        return null;
    }
}

