/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.utils;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public abstract class TreeViewerWildcardFilter
extends ViewerFilter {
    private static final Pattern PATTERN_BACK_SLASH = Pattern.compile("\\\\");
    private static final Pattern PATTERN_QUESTION = Pattern.compile("\\?");
    private static final Pattern PATTERN_STAR = Pattern.compile("\\*");
    private static final Pattern PATTERN_LBRACKET = Pattern.compile("\\(");
    private static final Pattern PATTERN_RBRACKET = Pattern.compile("\\)");
    private final TreeViewer treeViewer;

    public TreeViewerWildcardFilter(TreeViewer viewer) {
        this.treeViewer = viewer;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.isIgnoredElement(parentElement, element)) {
            ITreeContentProvider contentProvider = (ITreeContentProvider)this.treeViewer.getContentProvider();
            Object[] objectArray = contentProvider.getChildren(element);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (this.select(viewer, element, child)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        String filterText = this.getFilterText();
        if (filterText.length() == 0) {
            return true;
        }
        String wMatch = "*" + filterText + "*";
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(this.asRegEx(wMatch, false), 66);
        }
        catch (PatternSyntaxException e) {
            return false;
        }
        String text = this.getElementText(parentElement, element);
        return pattern.matcher(text).matches();
    }

    protected boolean isIgnoredElement(Object parentElement, Object element) {
        return false;
    }

    protected abstract String getFilterText();

    protected abstract String getElementText(Object var1, Object var2);

    private String asRegEx(String pattern, boolean group) {
        String result1 = PATTERN_BACK_SLASH.matcher(pattern).replaceAll("\\\\E\\\\\\\\\\\\Q");
        String result2 = PATTERN_STAR.matcher(result1).replaceAll("\\\\E.*\\\\Q");
        String result3 = PATTERN_QUESTION.matcher(result2).replaceAll("\\\\E.\\\\Q");
        if (group) {
            result3 = PATTERN_LBRACKET.matcher(result3).replaceAll("\\\\E(\\\\Q");
            result3 = PATTERN_RBRACKET.matcher(result3).replaceAll("\\\\E)\\\\Q");
        }
        return "\\Q" + result3 + "\\E";
    }
}

