/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.emf;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.diagnostic.Trouble;
import org.eclipse.passage.lic.internal.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.internal.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.internal.emf.i18n.EmfMessages;
import org.eclipse.passage.loc.internal.api.diagnostic.code.ResourceLoadFailed;
import org.eclipse.passage.loc.internal.emf.DomainContentAdapter;
import org.eclipse.passage.loc.internal.emf.EditingDomainRegistry;

public abstract class BaseDomainRegistry<I>
implements EditingDomainRegistry<I>,
IEditingDomainProvider {
    protected String domainName;
    private AdapterFactoryEditingDomain editingDomain;
    private final List<String> sources = new ArrayList<String>();
    private EContentAdapter contentAdapter;

    public BaseDomainRegistry() {
        BasicCommandStack commandStack = new BasicCommandStack();
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE), (CommandStack)commandStack, new HashMap());
    }

    protected void activate(Map<String, Object> properties) {
        this.domainName = String.valueOf(properties.get("org.eclipse.passage.lic.emf.edit.domain.name"));
        this.contentAdapter = this.createContentAdapter();
        ResourceSet resourceSet = this.editingDomain.getResourceSet();
        resourceSet.eAdapters().add((Object)this.contentAdapter);
        this.loadResourceSet();
    }

    protected void loadResourceSet() {
        try {
            Path domainPath = this.getResourceSetPath();
            if (!Files.exists(domainPath, new LinkOption[0])) {
                return;
            }
            Files.readAllLines(domainPath).forEach(this::registerSource);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected abstract Path getResourceSetPath() throws Exception;

    protected abstract DomainContentAdapter<I, ? extends EditingDomainRegistry<I>> createContentAdapter();

    protected void deactivate(Map<String, Object> properties) {
        this.saveResourceSet();
        this.editingDomain.getResourceSet().eAdapters().remove((Object)this.contentAdapter);
    }

    protected void saveResourceSet() {
        try {
            Path domainPath = this.getResourceSetPath();
            if (!Files.exists(domainPath, new LinkOption[0])) {
                Files.createFile(domainPath, new FileAttribute[0]);
            }
            Files.write(domainPath, this.sources, new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    protected Map<?, ?> getLoadOptions() {
        return new HashMap();
    }

    protected Map<?, ?> getSaveOptions() {
        return new HashMap();
    }

    public ServiceInvocationResult<Boolean> loadSource(String source) {
        URI uri = this.createURI(source);
        ResourceSet resourceSet = this.editingDomain.getResourceSet();
        Resource resource = resourceSet.createResource(uri);
        try {
            resource.load(this.getLoadOptions());
            return new BaseServiceInvocationResult((Object)true);
        }
        catch (IOException e) {
            return new BaseServiceInvocationResult(new Trouble((TroubleCode)new ResourceLoadFailed(), NLS.bind((String)EmfMessages.BaseDomainRegistry_e_load_failed, (Object)source), (Exception)e));
        }
    }

    public void unloadSource(String source) {
        URI uri = this.createURI(source);
        ResourceSet resourceSet = this.editingDomain.getResourceSet();
        Resource resource = resourceSet.getResource(uri, false);
        resource.unload();
        resourceSet.getResources().remove((Object)resource);
    }

    protected URI createURI(String source) {
        return URI.createFileURI((String)source);
    }

    @Override
    public ServiceInvocationResult<Boolean> registerSource(String source) {
        this.sources.add(source);
        return this.loadSource(source);
    }

    @Override
    public void unregisterSource(String source) {
        this.sources.remove(source);
        this.unloadSource(source);
    }

    @Override
    public Iterable<String> getSources() {
        return Collections.unmodifiableList(this.sources);
    }
}

