/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.core.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.provider.filetransfer.util.ProxySetupHelper;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.SegmentSequence;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.preferences.util.PreferencesUtil;
import org.eclipse.oomph.setup.VariableTask;
import org.eclipse.oomph.setup.VariableType;
import org.eclipse.oomph.setup.internal.core.util.ECFURIHandlerImpl;
import org.eclipse.oomph.setup.util.StringExpander;
import org.eclipse.oomph.util.IOUtil;

public abstract class Authenticator {
    private String ok;
    private String info;
    private String warning;
    private String error;

    public static Set<? extends Authenticator> create(VariableTask variable, final StringExpander stringExpander, URIConverter uriConverter) {
        LinkedHashSet<Authenticator> result = null;
        if (variable.getType() == VariableType.PASSWORD) {
            for (Annotation annotation : variable.getAnnotations()) {
                if (!"http://www.eclipse.org/oomph/setup/PasswordVerification".equals(annotation.getSource())) continue;
                EMap details = annotation.getDetails();
                String type = (String)details.get((Object)"type");
                if ("form".equals(type)) {
                    String error;
                    String warning;
                    String info;
                    String formFields;
                    String cookie = (String)details.get((Object)"form.cookie");
                    String url = (String)details.get((Object)"form.url");
                    if (url == null || (formFields = (String)details.get((Object)"form.parameters")) == null) continue;
                    if (result == null) {
                        result = new LinkedHashSet<Authenticator>();
                    }
                    HashSet keys = new HashSet();
                    final HashMap<Object, String> map = new HashMap<Object, String>();
                    String variableValue = variable.getValue();
                    map.put("value", variableValue);
                    map.put("form.url", url);
                    StringExpander localExpander = new StringExpander(){

                        protected String resolve(String key) {
                            return map.containsKey(key) ? (String)map.get(key) : 1.resolve((StringExpander)stringExpander, (String)key);
                        }

                        protected boolean isUnexpanded(String key) {
                            return !map.containsKey(key) && 1.isUnexpanded((StringExpander)stringExpander, (String)key);
                        }

                        protected String filter(String value, String filterName) {
                            return 1.filter((StringExpander)stringExpander, (String)value, (String)filterName);
                        }
                    };
                    String formSecurity = (String)details.get((Object)"form.secure.parameters");
                    List secureKeys = formSecurity == null ? null : SegmentSequence.create((String)" ", (String)formSecurity).segmentsList();
                    LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
                    String[] stringArray = SegmentSequence.create((String)" ", (String)formFields).segments();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String key = stringArray[n2];
                        String detailKey = "form.parameter." + key;
                        String unexpandedValue = (String)details.get((Object)detailKey);
                        String value = localExpander.expandString(unexpandedValue, keys);
                        if (value == null) {
                            value = secureKeys.contains(key) ? PreferencesUtil.encrypt((String)" ") : unexpandedValue;
                        }
                        map.put(detailKey, value);
                        parameters.put(key, value);
                        ++n2;
                    }
                    String formString = Form.getForm(parameters, secureKeys, true);
                    String formFilter = (String)details.get((Object)"form.filter");
                    boolean isFiltered = formFilter != null && formString.matches(formFilter);
                    String ok = localExpander.expandString((String)details.get((Object)"form.ok"), keys);
                    if (ok == null || (info = localExpander.expandString((String)details.get((Object)"form.info"), keys)) == null || (warning = localExpander.expandString((String)details.get((Object)"form.warning"), keys)) == null || (error = localExpander.expandString((String)details.get((Object)"form.error"), keys)) == null) continue;
                    String verificationURL = localExpander.expandString((String)details.get((Object)"form.verification.url"));
                    Pattern verificationPattern = null;
                    String verificationMatches = localExpander.expandString((String)details.get((Object)"form.verification.matches"));
                    if (verificationMatches != null) {
                        try {
                            verificationPattern = Pattern.compile(verificationMatches, 32);
                        }
                        catch (Exception ex) {
                            continue;
                        }
                    }
                    result.add(new Form(isFiltered, url, parameters, secureKeys, cookie, ok, info, warning, error, verificationURL, verificationPattern));
                    continue;
                }
                if (!"form-post".equals(type)) continue;
                String url = (String)details.get((Object)"form.url");
                String user = (String)details.get((Object)"form.user");
                String password = (String)details.get((Object)"form.password");
                String info = (String)details.get((Object)"form.info");
                String ok = (String)details.get((Object)"form.ok");
                String warning = (String)details.get((Object)"form.warning");
                String error = (String)details.get((Object)"form.error");
                String responseLocation = (String)details.get((Object)"form.response.location.matches");
                if (url == null || user == null || password == null || responseLocation == null || info == null || ok == null || warning == null || error == null) continue;
                if (result == null) {
                    result = new LinkedHashSet();
                }
                HashSet keys = new HashSet();
                final HashMap<String, String> map = new HashMap<String, String>();
                String variableValue = variable.getValue();
                map.put("value", variableValue);
                map.put("form.url", url);
                StringExpander localExpander = new StringExpander(){

                    protected String resolve(String key) {
                        return map.containsKey(key) ? (String)map.get(key) : 2.resolve((StringExpander)stringExpander, (String)key);
                    }

                    protected boolean isUnexpanded(String key) {
                        return !map.containsKey(key) && 2.isUnexpanded((StringExpander)stringExpander, (String)key);
                    }

                    protected String filter(String value, String filterName) {
                        return 2.filter((StringExpander)stringExpander, (String)value, (String)filterName);
                    }
                };
                String expandedUser = localExpander.expandString(user, keys);
                if (expandedUser == null) continue;
                map.put("form.user", expandedUser);
                String expandedPassword = localExpander.expandString(password, keys);
                if (expandedPassword == null) {
                    expandedPassword = PreferencesUtil.encrypt((String)" ");
                }
                map.put("form.password", expandedUser);
                String formFilter = (String)details.get((Object)"form.filter");
                boolean isFiltered = formFilter != null && expandedUser.matches(formFilter);
                String expandedResponseLocation = localExpander.expandString(responseLocation, keys);
                if (expandedResponseLocation == null) continue;
                Pattern responseLocationPattern = null;
                try {
                    responseLocationPattern = Pattern.compile(expandedResponseLocation);
                }
                catch (PatternSyntaxException ex) {
                    continue;
                }
                result.add(new FormPost(uriConverter, isFiltered, url, expandedUser, expandedPassword, localExpander.expandString(ok, keys), localExpander.expandString(info, keys), localExpander.expandString(warning, keys), localExpander.expandString(error, keys), responseLocationPattern));
            }
        }
        if (result != null) {
            for (Authenticator authenticator : result) {
                if (!(authenticator instanceof FormPost)) continue;
                Iterator it = result.iterator();
                while (it.hasNext()) {
                    Authenticator otherAuthenticator = (Authenticator)it.next();
                    if (!(otherAuthenticator instanceof Form)) continue;
                    it.remove();
                }
                break block6;
            }
        }
        return result;
    }

    protected Authenticator(String ok, String info, String warning, String error) {
        this.ok = ok;
        this.info = info;
        this.warning = warning;
        this.error = error;
    }

    public abstract boolean isFiltered();

    public abstract int validate();

    public String getMessage(int severity) {
        switch (severity) {
            case 0: {
                return this.ok;
            }
            case 1: {
                return this.info;
            }
            case 2: {
                return this.warning;
            }
            case 4: {
                return this.error;
            }
        }
        return null;
    }

    public static class Form
    extends Authenticator {
        private static final Pattern CHARSET_PATTERN = Pattern.compile("charset=([A-Za-z0-9-_]+)");
        private boolean isFiltered;
        private String uri;
        private String cookie;
        private Map<String, String> parameters;
        private Collection<String> secureKeys;
        private String verificationURI;
        private Pattern verificationPattern;

        public Form(boolean isFiltered, String uri, Map<String, String> parameters, Collection<String> secureKeys, String cookie, String ok, String info, String warning, String error) {
            super(ok, info, warning, error);
            this.isFiltered = isFiltered;
            this.uri = uri;
            this.parameters = parameters;
            this.secureKeys = secureKeys;
            this.cookie = cookie;
        }

        public Form(boolean isFiltered, String uri, Map<String, String> parameters, Collection<String> secureKeys, String cookie, String ok, String info, String warning, String error, String verificationURI, Pattern verificationPattern) {
            this(isFiltered, uri, parameters, secureKeys, cookie, ok, info, warning, error);
            this.verificationURI = verificationURI;
            this.verificationPattern = verificationPattern;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.cookie == null ? 0 : this.cookie.hashCode());
            result = 31 * result + (this.isFiltered ? 1231 : 1237);
            result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
            result = 31 * result + (this.secureKeys == null ? 0 : this.secureKeys.hashCode());
            result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
            result = 31 * result + (this.verificationPattern == null ? 0 : this.verificationPattern.toString().hashCode());
            result = 31 * result + (this.verificationURI == null ? 0 : this.verificationURI.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Form other = (Form)obj;
            if (this.cookie == null ? other.cookie != null : !this.cookie.equals(other.cookie)) {
                return false;
            }
            if (this.isFiltered != other.isFiltered) {
                return false;
            }
            if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
                return false;
            }
            if (this.secureKeys == null ? other.secureKeys != null : !this.secureKeys.equals(other.secureKeys)) {
                return false;
            }
            if (this.uri == null ? other.uri != null : !this.uri.equals(other.uri)) {
                return false;
            }
            if (this.verificationPattern == null ? other.verificationPattern != null : !this.verificationPattern.toString().equals(other.verificationPattern.toString())) {
                return false;
            }
            return !(this.verificationURI == null ? other.verificationURI != null : !this.verificationURI.equals(other.verificationURI));
        }

        @Override
        public boolean isFiltered() {
            return this.isFiltered;
        }

        @Override
        public int validate() {
            int status = 2;
            int i = 0;
            while (i < 3) {
                try {
                    status = this.sendPost() ? 0 : 4;
                    break;
                }
                catch (Exception exception) {
                    ++i;
                }
            }
            if (this.verificationURI != null && status == 0) {
                try {
                    status = this.verify() ? 0 : 4;
                }
                catch (Exception ex) {
                    status = 2;
                }
            }
            return status;
        }

        protected boolean sendPost() throws Exception {
            URL url = new URL(this.uri.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setUseCaches(false);
            connection.setConnectTimeout(5000);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("User-Agent", "Mozilla/5.0");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setDoOutput(true);
            this.handleProxy(connection);
            DataOutputStream data = new DataOutputStream(connection.getOutputStream());
            data.writeBytes(Form.getForm(this.parameters, this.secureKeys, true));
            data.close();
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                Map<String, List<String>> headerFields = connection.getHeaderFields();
                if (this.cookie == null) {
                    if (this.verificationURI == null && this.verificationPattern != null) {
                        List<String> links = headerFields.get("Link");
                        if (links != null) {
                            for (String link : links) {
                                if (!this.verificationPattern.matcher(link).matches()) continue;
                                return true;
                            }
                        }
                        return false;
                    }
                    return true;
                }
                List<String> list = headerFields.get("Set-Cookie");
                if (list != null) {
                    String prefix = this.cookie + "=";
                    for (String value : list) {
                        if (!value.startsWith(prefix)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        protected boolean verify() throws Exception {
            URL url = new URL(this.verificationURI.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setUseCaches(false);
            connection.setConnectTimeout(5000);
            connection.setRequestMethod("GET");
            connection.setRequestProperty("User-Agent", "Mozilla/5.0");
            this.handleProxy(connection);
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                InputStream inputStream = null;
                try {
                    Matcher matcher;
                    inputStream = connection.getInputStream();
                    String contentType = connection.getHeaderField("Content-Type");
                    if (contentType != null && (matcher = CHARSET_PATTERN.matcher(contentType)).find()) {
                        String charset = matcher.group(1);
                        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                        IOUtil.copy((InputStream)inputStream, (OutputStream)bytes);
                        String content = new String(bytes.toByteArray(), charset);
                        boolean bl = this.verificationPattern.matcher(content).matches();
                        return bl;
                    }
                }
                finally {
                    IOUtil.close((Closeable)inputStream);
                }
            }
            return false;
        }

        protected static String getForm(Map<String, String> parameters, Collection<String> secureKeys, boolean secure) {
            StringBuilder form = new StringBuilder();
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (secure && secureKeys != null && secureKeys.contains(key)) {
                    value = PreferencesUtil.decrypt((String)value);
                }
                if (form.length() != 0) {
                    form.append('&');
                }
                form.append(key);
                form.append('=');
                try {
                    form.append(URLEncoder.encode(value, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            return form.toString();
        }

        public String toString() {
            return Form.getForm(this.parameters, this.secureKeys, false);
        }

        private void handleProxy(HttpURLConnection connection) {
            try {
                ECFURIHandlerImpl.AuthorizationHandler.Authorization authorization;
                Proxy proxy = ProxySetupHelper.getProxy((String)this.uri);
                if (proxy != null && (authorization = new ECFURIHandlerImpl.AuthorizationHandler.Authorization(proxy.getUsername(), proxy.getPassword())).isAuthorized()) {
                    connection.setRequestProperty("Proxy-Authorization", authorization.getAuthorization());
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
    }

    public static class FormPost
    extends Authenticator {
        private final URIConverter uriConverter;
        private final boolean isFiltered;
        private final String uri;
        private final String user;
        private final String password;
        private final Pattern responseLocation;

        public FormPost(URIConverter uriConverter, boolean isFiltered, String uri, String user, String password, String ok, String info, String warning, String error, Pattern responseLocation) {
            super(ok, info, warning, error);
            this.uriConverter = uriConverter;
            this.isFiltered = isFiltered;
            this.uri = uri;
            this.user = user;
            this.password = password;
            this.responseLocation = responseLocation;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.isFiltered ? 1231 : 1237);
            result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
            result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
            result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
            result = 31 * result + (this.responseLocation == null ? 0 : this.responseLocation.toString().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FormPost other = (FormPost)obj;
            if (this.isFiltered != other.isFiltered) {
                return false;
            }
            if (this.user == null ? other.user != null : !this.user.equals(other.user)) {
                return false;
            }
            if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
                return false;
            }
            if (this.uri == null ? other.uri != null : !this.uri.equals(other.uri)) {
                return false;
            }
            return !(this.responseLocation == null ? other.responseLocation != null : !this.responseLocation.toString().equals(other.responseLocation.toString()));
        }

        @Override
        public boolean isFiltered() {
            return this.isFiltered;
        }

        @Override
        public int validate() {
            int status = 2;
            int i = 0;
            while (i < 3) {
                try {
                    status = this.sendPost() ? 0 : 4;
                    break;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    ++i;
                }
            }
            return status;
        }

        protected boolean sendPost() throws IOException {
            final ECFURIHandlerImpl.AuthorizationHandler.Authorization authorization = new ECFURIHandlerImpl.AuthorizationHandler.Authorization(this.user, PreferencesUtil.decrypt((String)this.password));
            ECFURIHandlerImpl.FormHandler formHandler = new ECFURIHandlerImpl.FormHandler(URI.createURI((String)this.uri), this.uriConverter, new ECFURIHandlerImpl.AuthorizationHandler(){

                @Override
                public ECFURIHandlerImpl.AuthorizationHandler.Authorization authorize(URI uri) {
                    return authorization;
                }

                @Override
                public ECFURIHandlerImpl.AuthorizationHandler.Authorization reauthorize(URI uri, ECFURIHandlerImpl.AuthorizationHandler.Authorization authorization2) {
                    return ECFURIHandlerImpl.AuthorizationHandler.Authorization.UNAUTHORIZEABLE;
                }
            }){

                @Override
                protected boolean isRedo() {
                    return true;
                }

                @Override
                protected boolean validHeaders(Map<String, List<String>> headers) {
                    List<String> locations;
                    if (super.validHeaders(headers) && (locations = headers.get("Location")) != null) {
                        for (String location : locations) {
                            if (!responseLocation.matcher(location).matches()) continue;
                            return true;
                        }
                    }
                    return false;
                }
            };
            return formHandler.process();
        }

        protected static String getForm(Map<String, String> parameters, Collection<String> secureKeys, boolean secure) {
            StringBuilder form = new StringBuilder();
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (secure && secureKeys != null && secureKeys.contains(key)) {
                    value = PreferencesUtil.decrypt((String)value);
                }
                if (form.length() != 0) {
                    form.append('&');
                }
                form.append(key);
                form.append('=');
                try {
                    form.append(URLEncoder.encode(value, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            return form.toString();
        }

        public String toString() {
            return "PostForm: uri=" + this.uri + " user=" + this.user + " password=" + (this.password == null ? null : PreferencesUtil.decrypt((String)this.password));
        }
    }
}

