/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists;

import ca.odell.glazedlists.SortedList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyResolver;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.NatColumnTableFormat;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.NatTableComparatorChooser;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralRefreshEvent;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;

public class GlazedListsSortModel<T>
implements ISortModel,
ILayerListener {
    private NatTableComparatorChooser<T> comparatorChooser;
    private NatColumnTableFormat<T> tableFormat;
    protected final SortedList<T> sortedList;
    protected final IColumnAccessor<T> columnAccessor;
    protected final IColumnPropertyResolver columnPropertyResolver;
    protected final IConfigRegistry configRegistry;
    protected final ILayer columnHeaderDataLayer;

    public GlazedListsSortModel(SortedList<T> sortedList, IColumnPropertyAccessor<T> columnPropertyAccessor, IConfigRegistry configRegistry, ILayer dataLayer) {
        this(sortedList, (IColumnAccessor<T>)columnPropertyAccessor, (IColumnPropertyResolver)columnPropertyAccessor, configRegistry, dataLayer);
    }

    public GlazedListsSortModel(SortedList<T> sortedList, IColumnAccessor<T> columnAccessor, IColumnPropertyResolver columnPropertyResolver, IConfigRegistry configRegistry, ILayer dataLayer) {
        this.sortedList = sortedList;
        this.columnAccessor = columnAccessor;
        this.columnPropertyResolver = columnPropertyResolver;
        this.configRegistry = configRegistry;
        this.columnHeaderDataLayer = dataLayer;
        this.columnHeaderDataLayer.addLayerListener((ILayerListener)this);
    }

    protected NatTableComparatorChooser<T> getComparatorChooser() {
        if (this.comparatorChooser == null) {
            this.tableFormat = new NatColumnTableFormat<T>(this.columnAccessor, this.columnPropertyResolver, this.configRegistry, this.columnHeaderDataLayer);
            this.comparatorChooser = new NatTableComparatorChooser<T>(this.sortedList, this.tableFormat);
        }
        return this.comparatorChooser;
    }

    public List<Integer> getSortedColumnIndexes() {
        return this.getComparatorChooser().getSortingColumns();
    }

    public int getSortOrder(int columnIndex) {
        return this.getComparatorChooser().getClickSequence(columnIndex);
    }

    public SortDirectionEnum getSortDirection(int columnIndex) {
        return this.getComparatorChooser().getSortDirectionForColumnIndex(columnIndex);
    }

    public boolean isColumnIndexSorted(int columnIndex) {
        return this.getComparatorChooser().isColumnIndexSorted(columnIndex);
    }

    public List<Comparator> getComparatorsForColumnIndex(int columnIndex) {
        return this.getComparatorChooser().getComparatorsForColumn(columnIndex);
    }

    public Comparator<?> getColumnComparator(int columnIndex) {
        return this.tableFormat.getColumnComparator(columnIndex);
    }

    public void sort(int columnIndex, SortDirectionEnum sortDirection, boolean accumulate) {
        this.getComparatorChooser().sort(columnIndex, sortDirection, accumulate);
    }

    public void clear() {
        this.getComparatorChooser().clearComparator();
    }

    public void handleLayerEvent(ILayerEvent event) {
        if (event instanceof StructuralRefreshEvent && ((StructuralRefreshEvent)event).isHorizontalStructureChanged()) {
            String test = this.getComparatorChooser().toString();
            this.comparatorChooser = null;
            this.getComparatorChooser().fromString(test);
        }
    }

    public void refresh() {
        this.getComparatorChooser().fromString(this.getComparatorChooser().toString());
    }
}

