/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.columnRename;

import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.style.editor.AbstractEditorPanel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ColumnLabelPanel
extends AbstractEditorPanel<String> {
    private Text textField;
    private final String columnLabel;
    private final String newColumnLabel;

    public ColumnLabelPanel(Composite parent, String columnLabel, String newColumnLabel) {
        super(parent, 0);
        this.columnLabel = columnLabel;
        this.newColumnLabel = newColumnLabel;
        this.init();
    }

    private void init() {
        GridLayout gridLayout = new GridLayout(2, false);
        this.setLayout((Layout)gridLayout);
        if (this.columnLabel != null) {
            Label label = new Label((Composite)this, 0);
            label.setText(Messages.getString("ColumnLabel.original"));
            Label originalLabel = new Label((Composite)this, 0);
            originalLabel.setText(this.columnLabel);
        }
        Label renameLabel = new Label((Composite)this, 0);
        renameLabel.setText(Messages.getString("ColumnLabel.rename"));
        this.textField = new Text((Composite)this, 2048);
        GridData gridData = new GridData(200, 15);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.textField.setLayoutData((Object)gridData);
        if (this.newColumnLabel != null && this.newColumnLabel.length() > 0) {
            this.textField.setText(this.newColumnLabel);
            this.textField.selectAll();
        }
    }

    @Override
    public void edit(String newColumnHeaderLabel) throws Exception {
        if (newColumnHeaderLabel != null && newColumnHeaderLabel.length() > 0) {
            this.textField.setText(newColumnHeaderLabel);
            this.textField.selectAll();
        }
    }

    @Override
    public String getEditorName() {
        return Messages.getString("ColumnLabel.editorName");
    }

    @Override
    public String getNewValue() {
        if (this.textField.isEnabled() && this.textField.getText() != null && this.textField.getText().length() > 0) {
            return this.textField.getText();
        }
        return null;
    }
}

