/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.ecore.QVTBase.operations;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.qvt.declarative.ecore.QVTBase.Rule;
import org.eclipse.qvt.declarative.ecore.QVTBase.Transformation;
import org.eclipse.qvt.declarative.ecore.QVTBase.TypedModel;
import org.eclipse.qvt.declarative.ecore.QVTBase.operations.AbstractQVTBaseOperations;
import org.eclipse.qvt.declarative.ecore.QVTBase.operations.QVTBaseMessages;
import org.eclipse.qvt.declarative.ecore.operations.EPackageOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationOperations
extends AbstractQVTBaseOperations {
    public static TransformationOperations INSTANCE = new TransformationOperations();

    public boolean checkEveryModelParameterUsedPackagesIsCompatibleWithExtension(Transformation transformation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (transformation.getExtends() == null) {
            return true;
        }
        boolean allOk = true;
        Map names = this.getNames((List)transformation.getModelParameter());
        Map extendedNames = this.getNames((List)transformation.getExtends().getModelParameter());
        for (String name : names.keySet()) {
            HashSet<EPackage> extendedDeclaredPackages;
            HashSet<EPackage> declaredPackages;
            TypedModel typedModel = (TypedModel)names.get(name);
            TypedModel extendedTypedModel = (TypedModel)extendedNames.get(name);
            if (extendedTypedModel != null && !(declaredPackages = new HashSet<EPackage>((Collection<EPackage>)typedModel.getUsedPackage())).equals(extendedDeclaredPackages = new HashSet<EPackage>((Collection<EPackage>)extendedTypedModel.getUsedPackage()))) {
                Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)typedModel, context), this.getObjectLabel((EObject)extendedTypedModel, context)};
                this.appendError(diagnostics, transformation, QVTBaseMessages._UI_Transformation_ModelParameterUsedPackagesAreNotCompatibleWithExtension, messageSubstitutions);
            }
            allOk = false;
        }
        return allOk;
    }

    public boolean checkExtendsIsAcyclic(Transformation transformation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Set<Transformation> allExtends = this.getAllExtends(transformation);
        if (!allExtends.contains(transformation)) {
            return true;
        }
        Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)transformation, context)};
        this.appendError(diagnostics, transformation, QVTBaseMessages._UI_Transformation_ExtendsContainsACycle, messageSubstitutions);
        return false;
    }

    public boolean checkExtendsIsCompatible(Transformation transformation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Set<EPackage> extendedDeclaredPackages;
        if (transformation.getExtends() == null) {
            return true;
        }
        Set<EPackage> declaredPackages = this.getDeclaredPackages(transformation);
        if (!declaredPackages.equals(extendedDeclaredPackages = this.getDeclaredPackages(transformation.getExtends()))) {
            Object[] messageSubstitutions = new Object[]{"ExtendsIsCompatible", this.getObjectLabel((EObject)transformation, context)};
            this.appendError(diagnostics, transformation, QVTBaseMessages._UI_Transformation_UsedPackagesAreNotCompatibleWithExtends, messageSubstitutions);
        }
        return false;
    }

    public boolean checkModelParameterNamesAreCompatibleWithExtension(Transformation transformation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (transformation.getExtends() == null) {
            return true;
        }
        Map names = this.getNames((List)transformation.getModelParameter());
        Map extendedNames = this.getNames((List)transformation.getExtends().getModelParameter());
        if (names.keySet().equals(extendedNames.keySet())) {
            return true;
        }
        Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)transformation, context), this.getObjectLabel((EObject)transformation.getExtends(), context)};
        this.appendError(diagnostics, transformation, QVTBaseMessages._UI_Transformation_ModelParameterNameIsNotCompatibleWithExtension, messageSubstitutions);
        return false;
    }

    public boolean checkModelParameterNamesAreUnique(Transformation transformation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.checkUniqueNames(transformation, (List)transformation.getModelParameter(), QVTBaseMessages._UI_Transformation_ModelParameterNameIsNotUnique, diagnostics, context);
    }

    public boolean checkRuleNamesAreUnique(Transformation transformation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.checkUniqueNames(transformation, (List)transformation.getRule(), QVTBaseMessages._UI_Transformation_RuleNameIsNotUnique, diagnostics, context);
    }

    public boolean checkSynthesizedTypesAreOwned(Transformation transformation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Set<CollectionType> synthesizedTypes = this.getSynthesizedTypes(transformation);
        if (synthesizedTypes == null) {
            return true;
        }
        boolean allOk = true;
        EList classifiers = transformation.getEClassifiers();
        for (CollectionType synthesizedType : synthesizedTypes) {
            if (classifiers.contains(synthesizedType)) continue;
            Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)synthesizedType, context), this.getObjectLabel((EObject)transformation, context)};
            this.appendError(diagnostics, transformation, QVTBaseMessages._UI_Transformation_SynthesizedTypeIsNotOwned, messageSubstitutions);
            allOk = false;
        }
        return allOk;
    }

    public void computeAllExtends(Transformation transformation, Set<Transformation> allExtends) {
        if (allExtends.contains(transformation)) {
            return;
        }
        allExtends.add(transformation);
        if (transformation.getExtends() == null) {
            return;
        }
        this.computeAllExtends(transformation.getExtends(), allExtends);
    }

    public boolean declaresRule(Transformation transformation, Rule rule) {
        if (transformation.getRule().contains((Object)rule)) {
            return true;
        }
        if (transformation.getExtends() == null) {
            return false;
        }
        return this.declaresRule(transformation.getExtends(), rule);
    }

    public boolean declaresType(Transformation transformation, EClass type) {
        if (type == null) {
            return false;
        }
        Set<EPackage> declaredPackages = this.getDeclaredPackages(transformation);
        if (declaredPackages.contains(type.getEPackage())) {
            return true;
        }
        return this.isUnresolved((EObject)type);
    }

    public boolean definesModel(Transformation transformation, TypedModel typedModel) {
        return transformation.getModelParameter().contains((Object)typedModel);
    }

    public Set<Transformation> getAllExtends(Transformation transformation) {
        HashSet<Transformation> allExtends = new HashSet<Transformation>();
        if (transformation.getExtends() != null) {
            this.computeAllExtends(transformation.getExtends(), allExtends);
        }
        return allExtends;
    }

    public Set<EPackage> getDeclaredPackages(Transformation transformation) {
        HashSet<EPackage> declaredPackages = new HashSet<EPackage>();
        for (TypedModel modelParameter : transformation.getModelParameter()) {
            for (EPackage usedPackage : modelParameter.getUsedPackage()) {
                Set allUsedPackages = EPackageOperations.INSTANCE.getAllEPackages(usedPackage);
                declaredPackages.addAll(allUsedPackages);
            }
        }
        return declaredPackages;
    }

    public Set<CollectionType> getSynthesizedTypes(Transformation transformation) {
        HashSet<CollectionType> synthesizedTypes = null;
        TreeIterator i = transformation.eAllContents();
        while (i.hasNext()) {
            EObject eObject = (EObject)i.next();
            if (!(eObject instanceof ETypedElement)) continue;
            EClassifier type = ((ETypedElement)eObject).getEType();
            while (type instanceof CollectionType) {
                if (synthesizedTypes == null) {
                    synthesizedTypes = new HashSet<CollectionType>();
                }
                synthesizedTypes.add((CollectionType)type);
                type = (EClassifier)((CollectionType)type).getElementType();
            }
        }
        return synthesizedTypes;
    }
}

