/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.codegen.qvti.analyzer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.AS2CGVisitor;
import org.eclipse.ocl.examples.codegen.analyzer.CodeGenAnalyzer;
import org.eclipse.ocl.examples.codegen.cgmodel.CGAccumulator;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCastExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstant;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstantExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorType;
import org.eclipse.ocl.examples.codegen.cgmodel.CGFinalVariable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIfExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIsEqualExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIsKindOfExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIterator;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLetExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGModelFactory;
import org.eclipse.ocl.examples.codegen.cgmodel.CGNamedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGParameter;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariableExp;
import org.eclipse.ocl.examples.codegen.generator.GenModelException;
import org.eclipse.ocl.examples.codegen.java.JavaLocalContext;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Import;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.ids.PrimitiveTypeId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.complete.CompleteClassInternal;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.library.LibraryProperty;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.codegen.qvti.analyzer.QVTiAnalyzer;
import org.eclipse.qvtd.codegen.qvti.java.QVTiCodeGenerator;
import org.eclipse.qvtd.codegen.qvti.java.QVTiGlobalContext;
import org.eclipse.qvtd.codegen.qvticgmodel.CGConnectionAssignment;
import org.eclipse.qvtd.codegen.qvticgmodel.CGConnectionVariable;
import org.eclipse.qvtd.codegen.qvticgmodel.CGEcoreContainerAssignment;
import org.eclipse.qvtd.codegen.qvticgmodel.CGEcorePropertyAssignment;
import org.eclipse.qvtd.codegen.qvticgmodel.CGEcoreRealizedVariable;
import org.eclipse.qvtd.codegen.qvticgmodel.CGFunction;
import org.eclipse.qvtd.codegen.qvticgmodel.CGFunctionCallExp;
import org.eclipse.qvtd.codegen.qvticgmodel.CGFunctionParameter;
import org.eclipse.qvtd.codegen.qvticgmodel.CGGuardVariable;
import org.eclipse.qvtd.codegen.qvticgmodel.CGMapping;
import org.eclipse.qvtd.codegen.qvticgmodel.CGMappingCall;
import org.eclipse.qvtd.codegen.qvticgmodel.CGMappingCallBinding;
import org.eclipse.qvtd.codegen.qvticgmodel.CGMappingExp;
import org.eclipse.qvtd.codegen.qvticgmodel.CGMappingLoop;
import org.eclipse.qvtd.codegen.qvticgmodel.CGMiddlePropertyAssignment;
import org.eclipse.qvtd.codegen.qvticgmodel.CGMiddlePropertyCallExp;
import org.eclipse.qvtd.codegen.qvticgmodel.CGPropertyAssignment;
import org.eclipse.qvtd.codegen.qvticgmodel.CGRealizedVariable;
import org.eclipse.qvtd.codegen.qvticgmodel.CGSequence;
import org.eclipse.qvtd.codegen.qvticgmodel.CGTransformation;
import org.eclipse.qvtd.codegen.qvticgmodel.CGTypedModel;
import org.eclipse.qvtd.codegen.qvticgmodel.QVTiCGModelFactory;
import org.eclipse.qvtd.pivot.qvtbase.BaseModel;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtbase.FunctionParameter;
import org.eclipse.qvtd.pivot.qvtbase.Pattern;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtcorebase.Area;
import org.eclipse.qvtd.pivot.qvtcorebase.Assignment;
import org.eclipse.qvtd.pivot.qvtcorebase.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcorebase.CorePattern;
import org.eclipse.qvtd.pivot.qvtcorebase.EnforcementOperation;
import org.eclipse.qvtd.pivot.qvtcorebase.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.NavigationAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.OppositePropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.PropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtcorebase.VariableAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.analysis.DomainUsage;
import org.eclipse.qvtd.pivot.qvtcorebase.utilities.QVTcoreBaseUtil;
import org.eclipse.qvtd.pivot.qvtimperative.ConnectionAssignment;
import org.eclipse.qvtd.pivot.qvtimperative.ConnectionStatement;
import org.eclipse.qvtd.pivot.qvtimperative.ConnectionVariable;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeBottomPattern;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeDomain;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeModel;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCall;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCallBinding;
import org.eclipse.qvtd.pivot.qvtimperative.MappingLoop;
import org.eclipse.qvtd.pivot.qvtimperative.MappingSequence;
import org.eclipse.qvtd.pivot.qvtimperative.MappingStatement;
import org.eclipse.qvtd.pivot.qvtimperative.VariablePredicate;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiTransformationAnalysis;
import org.eclipse.qvtd.pivot.qvtimperative.util.QVTimperativeVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;

public class QVTiAS2CGVisitor
extends AS2CGVisitor
implements QVTimperativeVisitor<CGNamedElement> {
    protected final @NonNull QVTiAnalyzer analyzer;
    protected final @NonNull QVTiGlobalContext globalContext;
    protected final @NonNull StandardLibraryInternal standardLibrary;

    public QVTiAS2CGVisitor(@NonNull QVTiAnalyzer analyzer, @NonNull QVTiGlobalContext globalContext) {
        super((CodeGenAnalyzer)analyzer);
        this.analyzer = analyzer;
        this.globalContext = globalContext;
        this.standardLibrary = this.environmentFactory.getStandardLibrary();
    }

    protected <T extends EObject> @NonNull T createCopy(@NonNull T aPrototype) {
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        EObject aCopy = copier.copy(aPrototype);
        assert (aCopy != null);
        copier.copyReferences();
        Transformation asTransformation = QVTbaseUtil.getContainingTransformation(aPrototype);
        if (asTransformation != null) {
            QVTiCodeGenerator codeGenerator = this.analyzer.getCodeGenerator();
            QVTiTransformationAnalysis transformationAnalysis = codeGenerator.getTransformationAnalysis(asTransformation);
            QVTimperativeDomainUsageAnalysis domainUsageAnalysis = transformationAnalysis.getDomainUsageAnalysis();
            for (EObject prototypeEObject : copier.keySet()) {
                EObject clonedEObject = (EObject)copier.get((Object)prototypeEObject);
                assert (clonedEObject != null);
                DomainUsage usage = domainUsageAnalysis.basicGetUsage((Element)prototypeEObject);
                if (usage == null) continue;
                domainUsageAnalysis.setUsage((Element)clonedEObject, usage);
            }
        }
        EObject castCopy = aCopy;
        return (T)castCopy;
    }

    protected @NonNull CGValuedElement generateOperationCallExp(@Nullable CGValuedElement cgSource, @NonNull OperationCallExp asOperationCallExp) {
        Operation pOperation = asOperationCallExp.getReferredOperation();
        if (pOperation instanceof Function) {
            Transformation asTransformation;
            if (cgSource == null && (asTransformation = QVTbaseUtil.getContainingTransformation((EObject)asOperationCallExp)) != null) {
                Variable asThis = QVTbaseUtil.getContextVariable((StandardLibrary)this.standardLibrary, (Transformation)asTransformation);
                VariableExp asThisExp = PivotUtil.createVariableExp((Variable)asThis);
                cgSource = (CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asThisExp);
            }
            CGFunctionCallExp cgFunctionCallExp = QVTiCGModelFactory.eINSTANCE.createCGFunctionCallExp();
            cgFunctionCallExp.setReferredOperation(pOperation);
            this.setAst((CGTypedElement)cgFunctionCallExp, (TypedElement)asOperationCallExp);
            cgFunctionCallExp.setRequired(pOperation.isIsRequired());
            cgFunctionCallExp.setSource(cgSource);
            for (OCLExpression pArgument : asOperationCallExp.getOwnedArguments()) {
                CGValuedElement cgArgument = (CGValuedElement)this.doVisit(CGValuedElement.class, (Element)pArgument);
                cgFunctionCallExp.getArguments().add(cgArgument);
            }
            return cgFunctionCallExp;
        }
        return super.generateOperationCallExp(cgSource, asOperationCallExp);
    }

    protected @NonNull CGValuedElement generateOppositePropertyCallExp(@NonNull CGValuedElement cgSource, @NonNull OppositePropertyCallExp asOppositePropertyCallExp) {
        Property asOppositeProperty = (Property)ClassUtil.nonNullModel((Object)asOppositePropertyCallExp.getReferredProperty());
        Property asProperty = (Property)ClassUtil.nonNullModel((Object)asOppositeProperty.getOpposite());
        if (asOppositeProperty.isIsComposite()) {
            return super.generateOppositePropertyCallExp(cgSource, asOppositePropertyCallExp);
        }
        this.globalContext.addOppositeProperty(asOppositeProperty);
        CGMiddlePropertyCallExp cgPropertyCallExp = QVTiCGModelFactory.eINSTANCE.createCGMiddlePropertyCallExp();
        cgPropertyCallExp.setAst((Element)asOppositePropertyCallExp);
        cgPropertyCallExp.setReferredProperty(asProperty);
        this.setAst((CGTypedElement)cgPropertyCallExp, (TypedElement)asOppositePropertyCallExp);
        cgPropertyCallExp.setRequired(asProperty.isIsRequired());
        cgPropertyCallExp.setSource(cgSource);
        return cgPropertyCallExp;
    }

    protected @Nullable EClassifier getEClassifier(@Nullable Type type) {
        if (type == null) {
            return null;
        }
        CompleteClassInternal completeClass = this.environmentFactory.getCompleteModel().getCompleteClass(type);
        for (Type partialClass : completeClass.getPartialClasses()) {
            EObject esObject = partialClass.getESObject();
            if (!(esObject instanceof EClassifier)) continue;
            return (EClassifier)esObject;
        }
        return null;
    }

    public @NonNull CGFunctionParameter getFunctionParameter(@NonNull FunctionParameter asFunctionParameter) {
        CGFunctionParameter cgFunctionParameter = (CGFunctionParameter)this.getVariablesStack().getParameter((Variable)asFunctionParameter);
        if (cgFunctionParameter == null) {
            cgFunctionParameter = QVTiCGModelFactory.eINSTANCE.createCGFunctionParameter();
            this.analyzer.setNames((CGValuedElement)cgFunctionParameter, asFunctionParameter);
            this.setAst((CGTypedElement)cgFunctionParameter, (TypedElement)asFunctionParameter);
            cgFunctionParameter.setTypeId(this.analyzer.getTypeId(asFunctionParameter.getTypeId()));
            this.addParameter((Variable)asFunctionParameter, cgFunctionParameter);
        }
        return cgFunctionParameter;
    }

    public @NonNull CGGuardVariable getGuardVariable(@NonNull Variable asVariable) {
        CGGuardVariable cgGuardVariable = (CGGuardVariable)this.getVariablesStack().getParameter(asVariable);
        assert (cgGuardVariable == null);
        boolean isConnectionVariable = asVariable instanceof ConnectionVariable;
        boolean isPrimitiveVariable = QVTimperativeUtil.isPrimitiveVariable((Variable)asVariable);
        cgGuardVariable = isConnectionVariable ? QVTiCGModelFactory.eINSTANCE.createCGConnectionVariable() : QVTiCGModelFactory.eINSTANCE.createCGGuardVariable();
        this.analyzer.setNames((CGValuedElement)cgGuardVariable, asVariable);
        this.setAst((CGTypedElement)cgGuardVariable, (TypedElement)asVariable);
        cgGuardVariable.setTypeId(this.analyzer.getTypeId(asVariable.getTypeId()));
        if (!isConnectionVariable && !isPrimitiveVariable) {
            cgGuardVariable.setTypedModel(this.getTypedModel(asVariable));
        }
        this.addParameter(asVariable, cgGuardVariable);
        return cgGuardVariable;
    }

    public @NonNull CGRealizedVariable getRealizedVariable(@NonNull RealizedVariable pRealizedVariable) {
        AS2CGVisitor.Variables variablesStack = this.getVariablesStack();
        CGVariable cgVariable2 = variablesStack.getVariable((VariableDeclaration)pRealizedVariable);
        CGRealizedVariable cgVariable = (CGRealizedVariable)cgVariable2;
        if (cgVariable == null) {
            EClassifier eClassifier = this.getEClassifier(pRealizedVariable.getType());
            if (eClassifier != null) {
                CGEcoreRealizedVariable cgEcoreRealizedVariable = QVTiCGModelFactory.eINSTANCE.createCGEcoreRealizedVariable();
                cgEcoreRealizedVariable.setEClassifier(eClassifier);
                cgVariable = cgEcoreRealizedVariable;
            }
            if (cgVariable == null) {
                cgVariable = QVTiCGModelFactory.eINSTANCE.createCGRealizedVariable();
            }
            this.setAst((CGTypedElement)cgVariable, (TypedElement)pRealizedVariable);
            cgVariable.setTypedModel(this.getTypedModel((Variable)pRealizedVariable));
            variablesStack.putVariable((VariableDeclaration)pRealizedVariable, (CGVariable)cgVariable);
        }
        return cgVariable;
    }

    protected @NonNull CGTypedModel getTypedModel(@NonNull Variable pVariable) {
        Area pArea = (Area)ClassUtil.nonNullState((Object)QVTcoreBaseUtil.getContainingArea((EObject)pVariable));
        TypedModel asTypedModel = null;
        if (pArea instanceof Domain) {
            asTypedModel = (TypedModel)ClassUtil.nonNullState((Object)((Domain)pArea).getTypedModel());
        } else {
            Transformation pTransformation = ((Mapping)pArea).getTransformation();
            asTypedModel = (TypedModel)ClassUtil.nonNullState((Object)pTransformation.getModelParameter(null));
        }
        return (CGTypedModel)ClassUtil.nonNullState((Object)this.analyzer.getTypedModel(asTypedModel));
    }

    public @Nullable CGNamedElement visitAssignment(@NonNull Assignment object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable CGNamedElement visitBaseModel(@NonNull BaseModel object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable CGNamedElement visitBottomPattern(@NonNull BottomPattern object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable CGNamedElement visitConnectionAssignment(@NonNull ConnectionAssignment asConnectionAssignment) {
        ConnectionVariable asVariable = asConnectionAssignment.getTargetVariable();
        if (asVariable == null) {
            return null;
        }
        CGVariable cgVariable = this.getVariable((VariableDeclaration)asVariable);
        OCLExpression asInitValue = asConnectionAssignment.getValue();
        CGValuedElement initValue = (CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asInitValue);
        CGConnectionAssignment cgConnectionAssignment = QVTiCGModelFactory.eINSTANCE.createCGConnectionAssignment();
        cgConnectionAssignment.setConnectionVariable(cgVariable);
        cgConnectionAssignment.setInitValue(initValue);
        cgConnectionAssignment.setTypeId(initValue.getTypeId());
        cgConnectionAssignment.setRequired(initValue.isRequired());
        return cgConnectionAssignment;
    }

    public @Nullable CGNamedElement visitConnectionStatement(@NonNull ConnectionStatement asConnectionStatement) {
        ConnectionVariable asVariable = asConnectionStatement.getTargetVariable();
        if (asVariable == null) {
            return null;
        }
        CGVariable cgVariable = this.getVariable((VariableDeclaration)asVariable);
        OCLExpression asInitValue = asConnectionStatement.getValue();
        assert (cgVariable instanceof CGConnectionVariable || cgVariable instanceof CGAccumulator);
        CGValuedElement initValue = (CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asInitValue);
        CGConnectionAssignment cgConnectionAssignment = QVTiCGModelFactory.eINSTANCE.createCGConnectionAssignment();
        cgConnectionAssignment.setConnectionVariable(cgVariable);
        cgConnectionAssignment.setInitValue(initValue);
        cgConnectionAssignment.setTypeId(initValue.getTypeId());
        cgConnectionAssignment.setRequired(initValue.isRequired());
        return cgConnectionAssignment;
    }

    public @Nullable CGNamedElement visitConnectionVariable(@NonNull ConnectionVariable asConnectionVariable) {
        CGVariable cgVariable = this.getVariable((VariableDeclaration)asConnectionVariable);
        CGValuedElement initValue = (CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asConnectionVariable.getOwnedInit());
        cgVariable.setInit(initValue);
        cgVariable.setTypeId(initValue.getTypeId());
        cgVariable.setRequired(initValue.isRequired());
        return cgVariable;
    }

    public @Nullable CGNamedElement visitCoreDomain(@NonNull CoreDomain object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable CGNamedElement visitCorePattern(@NonNull CorePattern object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable CGNamedElement visitDomain(@NonNull Domain object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable CGNamedElement visitEnforcementOperation(@NonNull EnforcementOperation object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable CGNamedElement visitFunction(@NonNull Function asFunction) {
        CGFunction cgFunction = QVTiCGModelFactory.eINSTANCE.createCGFunction();
        this.setAst((CGTypedElement)cgFunction, (TypedElement)asFunction);
        cgFunction.setRequired(asFunction.isIsRequired());
        for (Parameter pParameter : asFunction.getOwnedParameters()) {
            cgFunction.getParameters().add((CGParameter)this.doVisit(CGParameter.class, (Element)pParameter));
        }
        OCLExpression query = asFunction.getQueryExpression();
        if (query != null) {
            cgFunction.setBody((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)query));
        }
        this.analyzer.addFunction(asFunction, cgFunction);
        return cgFunction;
    }

    public @Nullable CGNamedElement visitFunctionParameter(@NonNull FunctionParameter asFunctionParameter) {
        return this.getFunctionParameter(asFunctionParameter);
    }

    public @Nullable CGNamedElement visitGuardPattern(@NonNull GuardPattern object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable CGNamedElement visitImperativeBottomPattern(@NonNull ImperativeBottomPattern object) {
        return this.visitBottomPattern((BottomPattern)object);
    }

    public @Nullable CGNamedElement visitImperativeDomain(@NonNull ImperativeDomain object) {
        return this.visitCoreDomain((CoreDomain)object);
    }

    public @Nullable CGNamedElement visitImperativeModel(@NonNull ImperativeModel object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable CGNamedElement visitImport(@NonNull Import object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable CGNamedElement visitMapping(@NonNull Mapping pMapping) {
        String name = pMapping.getName();
        CGMapping cgMapping = QVTiCGModelFactory.eINSTANCE.createCGMapping();
        this.setAst(cgMapping, (NamedElement)pMapping);
        this.analyzer.addMapping(pMapping, cgMapping);
        PrimitiveTypeId pivotTypeId = TypeId.BOOLEAN;
        CGMappingExp cgMappingExp = QVTiCGModelFactory.eINSTANCE.createCGMappingExp();
        this.setAst((CGNamedElement)cgMappingExp, (NamedElement)pMapping);
        cgMappingExp.setTypeId(this.analyzer.getTypeId((TypeId)pivotTypeId));
        PredicateTreeBuilder bodyBuilder = new PredicateTreeBuilder(pMapping, cgMapping);
        bodyBuilder.doGuards();
        bodyBuilder.doBottoms(cgMappingExp);
        MappingStatement mappingStatements = pMapping.getMappingStatement();
        if (mappingStatements != null) {
            cgMappingExp.setBody((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)mappingStatements));
        }
        List<CGGuardVariable> cgFreeVariables = cgMapping.getFreeVariables();
        ArrayList<CGGuardVariable> sortedVariables = new ArrayList<CGGuardVariable>(cgFreeVariables);
        Collections.sort(sortedVariables, CGVariableComparator.INSTANCE);
        cgFreeVariables.clear();
        cgFreeVariables.addAll(sortedVariables);
        return cgMapping;
    }

    public @Nullable CGNamedElement visitMappingCall(@NonNull MappingCall asMappingCall) {
        CGMappingCall cgMappingCall = QVTiCGModelFactory.eINSTANCE.createCGMappingCall();
        this.setAst((CGTypedElement)cgMappingCall, (TypedElement)asMappingCall);
        ArrayList<CGMappingCallBinding> cgMappingCallBindings = new ArrayList<CGMappingCallBinding>();
        for (MappingCallBinding asMappingCallBinding : asMappingCall.getBinding()) {
            CGMappingCallBinding cgMappingCallBinding = (CGMappingCallBinding)this.doVisit(CGMappingCallBinding.class, (Element)asMappingCallBinding);
            cgMappingCallBindings.add(cgMappingCallBinding);
        }
        Collections.sort(cgMappingCallBindings, CGMappingCallBindingComparator.INSTANCE);
        cgMappingCall.getMappingCallBindings().addAll(cgMappingCallBindings);
        return cgMappingCall;
    }

    public @Nullable CGNamedElement visitMappingCallBinding(@NonNull MappingCallBinding asMappingCallBinding) {
        Variable asBoundVariable = asMappingCallBinding.getBoundVariable();
        CGMappingCallBinding cgMappingCallBinding = QVTiCGModelFactory.eINSTANCE.createCGMappingCallBinding();
        cgMappingCallBinding.setName(asBoundVariable.getName());
        cgMappingCallBinding.setAst((Element)asMappingCallBinding);
        cgMappingCallBinding.setRequired(asBoundVariable.isIsRequired());
        cgMappingCallBinding.setValue((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asMappingCallBinding.getValue()));
        cgMappingCallBinding.setTypeId(this.analyzer.getTypeId(asBoundVariable.getTypeId()));
        return cgMappingCallBinding;
    }

    public @Nullable CGNamedElement visitMappingLoop(@NonNull MappingLoop asMappingLoop) {
        Variable asIterator;
        CGMappingLoop cgMappingLoop = QVTiCGModelFactory.eINSTANCE.createCGMappingLoop();
        EList asIterators = asMappingLoop.getOwnedIterators();
        if (asIterators.size() > 0 && (asIterator = (Variable)asIterators.get(0)) != null) {
            CGIterator cgIterator = this.getIterator((VariableDeclaration)asIterator);
            cgIterator.setTypeId(this.analyzer.getTypeId(asIterator.getTypeId()));
            cgIterator.setRequired(asIterator.isIsRequired());
            if (asIterator.isIsRequired()) {
                cgIterator.setNonNull();
            }
            cgMappingLoop.getIterators().add(cgIterator);
        }
        cgMappingLoop.setSource((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asMappingLoop.getOwnedSource()));
        cgMappingLoop.setAst((Element)asMappingLoop);
        CollectionType collectionType = this.standardLibrary.getCollectionType();
        Operation forAllIteration = (Operation)NameUtil.getNameable((Iterable)collectionType.getOwnedOperations(), (String)"forAll");
        cgMappingLoop.setReferredIteration((Iteration)forAllIteration);
        cgMappingLoop.setBody((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asMappingLoop.getOwnedBody()));
        return cgMappingLoop;
    }

    public @Nullable CGNamedElement visitMappingSequence(@NonNull MappingSequence asMappingSequence) {
        CGSequence cgSequence = QVTiCGModelFactory.eINSTANCE.createCGSequence();
        List<CGValuedElement> cgMappingStatements = cgSequence.getStatements();
        for (MappingStatement asMappingStatement : asMappingSequence.getMappingStatements()) {
            CGValuedElement cgMappingStatement = (CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asMappingStatement);
            cgMappingStatements.add(cgMappingStatement);
        }
        return cgSequence;
    }

    public @Nullable CGNamedElement visitMappingStatement(@NonNull MappingStatement object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable CGNamedElement visitNavigationAssignment(@NonNull NavigationAssignment asNavigationAssignment) {
        Transformation asTransformation = (Transformation)ClassUtil.nonNullModel((Object)QVTbaseUtil.getContainingTransformation((EObject)asNavigationAssignment));
        QVTiTransformationAnalysis transformationAnalysis = this.analyzer.getCodeGenerator().getTransformationAnalysis(asTransformation);
        Integer cacheIndex = transformationAnalysis.getCacheIndex(asNavigationAssignment);
        if (cacheIndex != null) {
            CGMiddlePropertyAssignment cgPropertyAssignment = QVTiCGModelFactory.eINSTANCE.createCGMiddlePropertyAssignment();
            this.setAst((CGNamedElement)cgPropertyAssignment, (Element)asNavigationAssignment);
            cgPropertyAssignment.setSlotValue((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asNavigationAssignment.getSlotExpression()));
            Property asProperty = QVTcoreBaseUtil.getTargetProperty((NavigationAssignment)asNavigationAssignment);
            cgPropertyAssignment.setReferredProperty(asProperty);
            cgPropertyAssignment.setTypeId(this.analyzer.getTypeId((TypeId)TypeId.OCL_VOID));
            cgPropertyAssignment.setInitValue((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asNavigationAssignment.getValue()));
            EStructuralFeature eStructuralFeature = (EStructuralFeature)asProperty.getESObject();
            if (eStructuralFeature != null) {
                try {
                    this.genModelHelper.getGetAccessor(eStructuralFeature);
                    cgPropertyAssignment.setEStructuralFeature(eStructuralFeature);
                }
                catch (GenModelException e) {
                    System.out.println("Missing getAccessor for " + eStructuralFeature + "ignored : " + e.getMessage());
                }
            }
            return cgPropertyAssignment;
        }
        Property asTargetProperty = QVTcoreBaseUtil.getTargetProperty((NavigationAssignment)asNavigationAssignment);
        LibraryProperty libraryProperty = this.metamodelManager.getImplementation((Element)asNavigationAssignment, null, asTargetProperty);
        CGPropertyAssignment cgPropertyAssignment = null;
        if (this.isEcoreProperty(libraryProperty)) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)asTargetProperty.getESObject();
            if (eStructuralFeature != null) {
                try {
                    this.genModelHelper.getGetAccessor(eStructuralFeature);
                    CGEcorePropertyAssignment cgEcorePropertyAssignment = QVTiCGModelFactory.eINSTANCE.createCGEcorePropertyAssignment();
                    cgEcorePropertyAssignment.setEStructuralFeature(eStructuralFeature);
                    cgPropertyAssignment = cgEcorePropertyAssignment;
                }
                catch (GenModelException e) {
                    System.out.println("Missing getAccessor for " + eStructuralFeature + "ignored : " + e.getMessage());
                }
            } else {
                Property asOppositeProperty = asTargetProperty.getOpposite();
                eStructuralFeature = (EStructuralFeature)(asOppositeProperty != null ? asOppositeProperty.getESObject() : null);
                if (eStructuralFeature != null) {
                    assert (((EReference)eStructuralFeature).isContainment());
                    try {
                        this.genModelHelper.getGetAccessor(eStructuralFeature);
                        CGEcoreContainerAssignment cgEcoreContainerAssignment = QVTiCGModelFactory.eINSTANCE.createCGEcoreContainerAssignment();
                        cgEcoreContainerAssignment.setEStructuralFeature(eStructuralFeature);
                        cgPropertyAssignment = cgEcoreContainerAssignment;
                    }
                    catch (GenModelException e) {
                        System.out.println("Missing getAccessor for " + eStructuralFeature + "ignored : " + e.getMessage());
                    }
                }
            }
        }
        if (cgPropertyAssignment == null) {
            cgPropertyAssignment = QVTiCGModelFactory.eINSTANCE.createCGPropertyAssignment();
        }
        this.setAst((CGNamedElement)cgPropertyAssignment, (Element)asNavigationAssignment);
        cgPropertyAssignment.setSlotValue((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asNavigationAssignment.getSlotExpression()));
        cgPropertyAssignment.setReferredProperty(asTargetProperty);
        cgPropertyAssignment.setTypeId(this.analyzer.getTypeId((TypeId)TypeId.OCL_VOID));
        cgPropertyAssignment.setInitValue((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asNavigationAssignment.getValue()));
        CGExecutorProperty cgExecutorProperty = this.analyzer.createExecutorProperty(asTargetProperty);
        cgPropertyAssignment.setExecutorProperty(cgExecutorProperty);
        return cgPropertyAssignment;
    }

    public @Nullable CGNamedElement visitPattern(@NonNull Pattern object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable CGIfExp visitPredicate(@NonNull Predicate asPredicate) {
        CGIfExp cgPredicate = CGModelFactory.eINSTANCE.createCGIfExp();
        cgPredicate.setTypeId(this.analyzer.getTypeId((TypeId)TypeId.BOOLEAN));
        cgPredicate.setRequired(true);
        OCLExpression asConditionExpression = asPredicate.getConditionExpression();
        assert (asConditionExpression != null);
        cgPredicate.setCondition((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asConditionExpression));
        CGConstantExp cgElse = this.analyzer.createCGConstantExp(asConditionExpression, (CGConstant)this.analyzer.getBoolean(false));
        this.setAst((CGTypedElement)cgElse, (TypedElement)asConditionExpression);
        cgElse.setTypeId(this.analyzer.getTypeId((TypeId)TypeId.BOOLEAN));
        cgElse.setRequired(true);
        cgPredicate.setElseExpression((CGValuedElement)cgElse);
        return cgPredicate;
    }

    public @Nullable CGNamedElement visitOppositePropertyAssignment(@NonNull OppositePropertyAssignment asPropertyAssignment) {
        return this.visitNavigationAssignment((NavigationAssignment)asPropertyAssignment);
    }

    public @Nullable CGNamedElement visitPropertyAssignment(@NonNull PropertyAssignment asPropertyAssignment) {
        return this.visitNavigationAssignment((NavigationAssignment)asPropertyAssignment);
    }

    public @Nullable CGNamedElement visitRealizedVariable(@NonNull RealizedVariable object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable CGNamedElement visitRule(@NonNull Rule object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable CGNamedElement visitTransformation(@NonNull Transformation asTransformation) {
        this.analyzer.getCodeGenerator().getTransformationAnalysis(asTransformation);
        CGTransformation cgTransformation = QVTiCGModelFactory.eINSTANCE.createCGTransformation();
        this.setAst((CGNamedElement)cgTransformation, (NamedElement)asTransformation);
        this.pushCurrentClass(cgTransformation);
        List<CGTypedModel> cgTypedModels = cgTransformation.getTypedModels();
        for (TypedModel asTypedModel : asTransformation.getModelParameter()) {
            CGTypedModel cgTypedModel = (CGTypedModel)this.doVisit(CGTypedModel.class, (Element)asTypedModel);
            cgTypedModel.setModelIndex(cgTypedModels.size());
            cgTypedModels.add(cgTypedModel);
        }
        for (Rule asRule : asTransformation.getRule()) {
            CGMapping cgMapping = (CGMapping)this.doVisit(CGMapping.class, (Element)asRule);
            cgTransformation.getMappings().add(cgMapping);
        }
        for (Operation asOperation : asTransformation.getOwnedOperations()) {
            CGOperation cgOperation = (CGOperation)this.doVisit(CGOperation.class, (Element)asOperation);
            cgTransformation.getOperations().add(cgOperation);
        }
        this.popCurrentClass(cgTransformation);
        return cgTransformation;
    }

    public @Nullable CGNamedElement visitTypedModel(@NonNull TypedModel asTypedModel) {
        CGTypedModel cgTypedModel = QVTiCGModelFactory.eINSTANCE.createCGTypedModel();
        this.setAst(cgTypedModel, (NamedElement)asTypedModel);
        this.analyzer.addTypedModel(asTypedModel, cgTypedModel);
        return cgTypedModel;
    }

    public @Nullable CGNamedElement visitVariable(@NonNull Variable asVariable) {
        CGVariable cgVariable = this.getVariable((VariableDeclaration)asVariable);
        CGValuedElement initValue = (CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asVariable.getOwnedInit());
        cgVariable.setInit(initValue);
        cgVariable.setTypeId(initValue.getTypeId());
        cgVariable.setRequired(initValue.isRequired());
        return cgVariable;
    }

    public @Nullable CGNamedElement visitVariableAssignment(@NonNull VariableAssignment asVariableAssignment) {
        Variable asVariable = asVariableAssignment.getTargetVariable();
        if (asVariable == null) {
            return null;
        }
        CGVariable cgVariable = this.getVariable((VariableDeclaration)asVariable);
        OCLExpression asInitValue = asVariableAssignment.getValue();
        assert (!(cgVariable instanceof CGConnectionVariable));
        CGValuedElement initValue = (CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asInitValue);
        cgVariable.setInit(initValue);
        cgVariable.setTypeId(initValue.getTypeId());
        cgVariable.setRequired(initValue.isRequired());
        return cgVariable;
    }

    public @Nullable CGNamedElement visitVariablePredicate(@NonNull VariablePredicate asPredicate) {
        OCLExpression asExpression = asPredicate.getConditionExpression();
        assert (asExpression != null);
        Variable asVariable = asPredicate.getTargetVariable();
        CGValuedElement cgExpression = (CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asExpression);
        cgExpression.setName("temp1_" + asVariable.getName());
        CGFinalVariable cgUncastVariable = CGModelFactory.eINSTANCE.createCGFinalVariable();
        cgUncastVariable.setName("temp2_" + asVariable.getName());
        cgUncastVariable.setInit(cgExpression);
        cgUncastVariable.setTypeId(cgExpression.getTypeId());
        cgUncastVariable.setRequired(cgExpression.isRequired());
        CGLetExp cgOuterLetExp = CGModelFactory.eINSTANCE.createCGLetExp();
        this.setAst((CGNamedElement)cgOuterLetExp, (Element)asPredicate);
        cgOuterLetExp.setInit((CGVariable)cgUncastVariable);
        cgOuterLetExp.setTypeId(this.analyzer.getTypeId((TypeId)TypeId.BOOLEAN));
        cgOuterLetExp.setRequired(true);
        CGIfExp cgPredicate = CGModelFactory.eINSTANCE.createCGIfExp();
        cgPredicate.setTypeId(this.analyzer.getTypeId((TypeId)TypeId.BOOLEAN));
        cgPredicate.setRequired(true);
        CGConstantExp cgElse = this.analyzer.createCGConstantExp(asExpression, (CGConstant)this.analyzer.getBoolean(false));
        this.setAst((CGNamedElement)cgElse, (Element)asPredicate);
        cgElse.setTypeId(this.analyzer.getTypeId((TypeId)TypeId.BOOLEAN));
        cgElse.setRequired(true);
        cgPredicate.setElseExpression((CGValuedElement)cgElse);
        CGIsKindOfExp cgIsKindOfExp = CGModelFactory.eINSTANCE.createCGIsKindOfExp();
        cgIsKindOfExp.setTypeId(this.analyzer.getTypeId((TypeId)TypeId.BOOLEAN));
        cgIsKindOfExp.setRequired(true);
        CGVariableExp cgUncastVariableExp1 = CGModelFactory.eINSTANCE.createCGVariableExp();
        this.setAst((CGTypedElement)cgUncastVariableExp1, (TypedElement)asVariable);
        cgUncastVariableExp1.setReferredVariable((CGVariable)cgUncastVariable);
        cgUncastVariableExp1.setTypeId(cgUncastVariable.getTypeId());
        cgUncastVariableExp1.setRequired(cgUncastVariable.isRequired());
        cgIsKindOfExp.setSource((CGValuedElement)cgUncastVariableExp1);
        CGExecutorType cgExecutorType = this.analyzer.createExecutorType((Type)ClassUtil.nonNullState((Object)asVariable.getType()));
        cgIsKindOfExp.setExecutorType(cgExecutorType);
        cgPredicate.setCondition((CGValuedElement)cgIsKindOfExp);
        cgOuterLetExp.setIn((CGValuedElement)cgPredicate);
        CGVariableExp cgUncastVariableExp2 = CGModelFactory.eINSTANCE.createCGVariableExp();
        this.setAst((CGTypedElement)cgUncastVariableExp2, (TypedElement)asVariable);
        cgUncastVariableExp2.setReferredVariable((CGVariable)cgUncastVariable);
        cgUncastVariableExp2.setTypeId(cgUncastVariable.getTypeId());
        cgUncastVariableExp2.setRequired(cgUncastVariable.isRequired());
        CGCastExp cgCastExp = CGModelFactory.eINSTANCE.createCGCastExp();
        cgCastExp.setSource((CGValuedElement)cgUncastVariableExp2);
        cgCastExp.setExecutorType(cgExecutorType);
        TypeId asTypeId = cgExecutorType.getASTypeId();
        assert (asTypeId != null);
        cgCastExp.setTypeId(this.analyzer.getTypeId(asTypeId));
        CGFinalVariable cgCastVariable = (CGFinalVariable)this.createCGVariable(asVariable);
        cgCastVariable.setInit((CGValuedElement)cgCastExp);
        CGLetExp cgCastLetExp = CGModelFactory.eINSTANCE.createCGLetExp();
        this.setAst((CGNamedElement)cgCastLetExp, (Element)asPredicate);
        cgCastLetExp.setInit((CGVariable)cgCastVariable);
        cgCastLetExp.setTypeId(this.analyzer.getTypeId((TypeId)TypeId.BOOLEAN));
        cgCastLetExp.setRequired(true);
        cgPredicate.setThenExpression((CGValuedElement)cgCastLetExp);
        return cgCastLetExp;
    }

    public static class CGMappingCallBindingComparator
    implements Comparator<CGMappingCallBinding> {
        public static final @NonNull CGMappingCallBindingComparator INSTANCE = new CGMappingCallBindingComparator();

        @Override
        public int compare(CGMappingCallBinding o1, CGMappingCallBinding o2) {
            String n2;
            MappingCallBinding b1 = (MappingCallBinding)o1.getAst();
            MappingCallBinding b2 = (MappingCallBinding)o2.getAst();
            Variable v1 = b1 != null ? b1.getBoundVariable() : null;
            Variable v2 = b2 != null ? b2.getBoundVariable() : null;
            String n1 = v1 != null ? v1.getName() : null;
            String string = n2 = v2 != null ? v2.getName() : null;
            if (n1 == null) {
                n1 = "";
            }
            if (n2 == null) {
                n2 = "";
            }
            return n1.compareTo(n2);
        }
    }

    public static class CGVariableComparator
    implements Comparator<CGVariable> {
        public static final @NonNull CGVariableComparator INSTANCE = new CGVariableComparator();

        @Override
        public int compare(CGVariable o1, CGVariable o2) {
            String n2;
            Variable v1 = (Variable)o1.getAst();
            Variable v2 = (Variable)o2.getAst();
            String n1 = v1 != null ? v1.getName() : null;
            String string = n2 = v2 != null ? v2.getName() : null;
            if (n1 == null) {
                n1 = "";
            }
            if (n2 == null) {
                n2 = "";
            }
            return n1.compareTo(n2);
        }
    }

    protected class PredicateTreeBuilder {
        protected final @NonNull Mapping asMapping;
        protected final @NonNull CGMapping cgMapping;
        private @Nullable CGValuedElement cgLeafExp = null;

        public PredicateTreeBuilder(@NonNull Mapping asMapping, CGMapping cgMapping) {
            this.asMapping = asMapping;
            this.cgMapping = cgMapping;
        }

        private void appendCheckedLetVariable(@NonNull Variable asVariable, @NonNull OCLExpression asInit) {
            Type sourceType = (Type)ClassUtil.nonNullState((Object)asInit.getType());
            Type targetType = (Type)ClassUtil.nonNullState((Object)asVariable.getType());
            boolean needsNullTest = !asInit.isIsRequired() && asVariable.isIsRequired();
            boolean needsTypeCheck = !sourceType.conformsTo((StandardLibrary)QVTiAS2CGVisitor.this.standardLibrary, targetType);
            CGValuedElement cgInit = (CGValuedElement)QVTiAS2CGVisitor.this.doVisit(CGValuedElement.class, (Element)asInit);
            if (needsTypeCheck || needsNullTest) {
                CGFinalVariable cgRawVariable = CGModelFactory.eINSTANCE.createCGFinalVariable();
                QVTiAS2CGVisitor.this.setAst((CGTypedElement)cgRawVariable, (TypedElement)asInit);
                cgRawVariable.setInit(cgInit);
                cgRawVariable.setName("raw_" + asVariable.getName());
                CGLetExp cgRawLetExp = CGModelFactory.eINSTANCE.createCGLetExp();
                QVTiAS2CGVisitor.this.setAst((CGTypedElement)cgRawLetExp, (TypedElement)asInit);
                cgRawLetExp.setInit((CGVariable)cgRawVariable);
                cgRawLetExp.setTypeId(QVTiAS2CGVisitor.this.analyzer.getTypeId((TypeId)TypeId.BOOLEAN));
                this.appendSubTree((CGValuedElement)cgRawLetExp);
                if (needsNullTest) {
                    this.appendNonNullPredicate(cgRawVariable);
                }
                if (needsTypeCheck) {
                    CGExecutorType cgType = QVTiAS2CGVisitor.this.analyzer.createExecutorType(targetType);
                    this.appendIsKindOfPredicate(cgRawVariable, cgType);
                    CGCastExp cgCastExp = CGModelFactory.eINSTANCE.createCGCastExp();
                    cgCastExp.setSource((CGValuedElement)QVTiAS2CGVisitor.this.analyzer.createCGVariableExp((CGVariable)cgRawVariable));
                    cgCastExp.setExecutorType(cgType);
                    cgCastExp.setTypeId(QVTiAS2CGVisitor.this.codeGenerator.getAnalyzer().getTypeId(asVariable.getTypeId()));
                    cgInit = cgCastExp;
                } else {
                    cgInit = QVTiAS2CGVisitor.this.analyzer.createCGVariableExp((CGVariable)cgRawVariable);
                }
            }
            CGFinalVariable cgVariable = (CGFinalVariable)QVTiAS2CGVisitor.this.createCGVariable(asVariable);
            cgVariable.setInit(cgInit);
            CGLetExp cgLetExp = CGModelFactory.eINSTANCE.createCGLetExp();
            QVTiAS2CGVisitor.this.setAst((CGTypedElement)cgLetExp, (TypedElement)asVariable);
            cgLetExp.setInit((CGVariable)cgVariable);
            cgLetExp.setTypeId(QVTiAS2CGVisitor.this.analyzer.getTypeId((TypeId)TypeId.BOOLEAN));
            this.appendSubTree((CGValuedElement)cgLetExp);
        }

        private void appendIsKindOfPredicate(@NonNull CGFinalVariable cgVariable, @NonNull CGExecutorType cgExecutorType) {
            @NonNull CGIsKindOfExp cgCondition = CGModelFactory.eINSTANCE.createCGIsKindOfExp();
            cgCondition.setSource((CGValuedElement)QVTiAS2CGVisitor.this.analyzer.createCGVariableExp((CGVariable)cgVariable));
            cgCondition.setExecutorType(cgExecutorType);
            cgCondition.setTypeId(QVTiAS2CGVisitor.this.analyzer.getTypeId((TypeId)TypeId.BOOLEAN));
            CGIfExp cgIfExp = CGModelFactory.eINSTANCE.createCGIfExp();
            cgIfExp.setTypeId(QVTiAS2CGVisitor.this.analyzer.getTypeId((TypeId)TypeId.BOOLEAN));
            cgIfExp.setCondition((CGValuedElement)cgCondition);
            cgIfExp.setElseExpression(QVTiAS2CGVisitor.this.analyzer.createCGConstantExp((CGConstant)QVTiAS2CGVisitor.this.analyzer.getBoolean(false)));
            this.appendSubTree((CGValuedElement)cgIfExp);
        }

        private void appendNonNullPredicate(@NonNull CGFinalVariable cgVariable) {
            CGIsEqualExp cgCondition = CGModelFactory.eINSTANCE.createCGIsEqualExp();
            cgCondition.setNotEquals(true);
            cgCondition.setSource((CGValuedElement)QVTiAS2CGVisitor.this.analyzer.createCGVariableExp((CGVariable)cgVariable));
            cgCondition.setArgument(QVTiAS2CGVisitor.this.analyzer.createCGConstantExp((CGConstant)QVTiAS2CGVisitor.this.analyzer.getNull()));
            cgCondition.setTypeId(QVTiAS2CGVisitor.this.analyzer.getTypeId((TypeId)TypeId.BOOLEAN));
            cgCondition.setInvalidating(false);
            cgCondition.setValidating(true);
            CGIfExp cgIfExp = CGModelFactory.eINSTANCE.createCGIfExp();
            cgIfExp.setTypeId(QVTiAS2CGVisitor.this.analyzer.getTypeId((TypeId)TypeId.BOOLEAN));
            cgIfExp.setName(cgVariable.getName());
            cgIfExp.setCondition((CGValuedElement)cgCondition);
            cgIfExp.setElseExpression(QVTiAS2CGVisitor.this.analyzer.createCGConstantExp((CGConstant)QVTiAS2CGVisitor.this.analyzer.getBoolean(false)));
            this.appendSubTree((CGValuedElement)cgIfExp);
        }

        private void appendSubTree(@NonNull CGValuedElement cgElement) {
            CGValuedElement cgElementRoot = cgElement;
            while (cgElementRoot.eContainer() != null) {
                cgElementRoot = (CGValuedElement)cgElementRoot.eContainer();
            }
            if (this.cgMapping.getBody() == null) {
                this.cgMapping.setBody(cgElementRoot);
            }
            if (this.cgLeafExp instanceof CGLetExp) {
                ((CGLetExp)this.cgLeafExp).setIn(cgElementRoot);
            } else if (this.cgLeafExp instanceof CGIfExp) {
                ((CGIfExp)this.cgLeafExp).setThenExpression(cgElementRoot);
            } else assert (this.cgLeafExp == null);
            this.cgLeafExp = cgElement;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public void doBottoms(@NonNull CGMappingExp cgMappingExp) {
            ArrayList<@NonNull BottomPattern> pBottomPatterns = new ArrayList<BottomPattern>();
            BottomPattern pBottomPattern2 = this.asMapping.getBottomPattern();
            if (pBottomPattern2 != null) {
                pBottomPatterns.add(pBottomPattern2);
            }
            for (Object pDomain : ClassUtil.nullFree((EList)this.asMapping.getDomain())) {
                if (!(pDomain instanceof CoreDomain) || (pBottomPattern2 = ((CoreDomain)pDomain).getBottomPattern()) == null) continue;
                pBottomPatterns.add(pBottomPattern2);
            }
            for (BottomPattern pBottomPattern2 : pBottomPatterns) {
                for (Variable asVariable : ClassUtil.nullFree((EList)pBottomPattern2.getVariable())) {
                    OCLExpression asInit = asVariable.getOwnedInit();
                    if (asVariable instanceof ConnectionVariable) {
                        CGAccumulator cgAccumulator = CGModelFactory.eINSTANCE.createCGAccumulator();
                        cgAccumulator.setAst((Element)asVariable);
                        cgAccumulator.setName(asVariable.getName());
                        if (asInit != null) {
                            CGValuedElement cgInit = (CGValuedElement)QVTiAS2CGVisitor.this.doVisit(CGValuedElement.class, (Element)asInit);
                            cgAccumulator.setTypeId(cgInit.getTypeId());
                            cgAccumulator.setInit(cgInit);
                        } else {
                            cgAccumulator.setTypeId(QVTiAS2CGVisitor.this.analyzer.getTypeId(asVariable.getTypeId()));
                        }
                        cgAccumulator.setNonNull();
                        cgMappingExp.getOwnedAccumulators().add(cgAccumulator);
                        QVTiAS2CGVisitor.this.getVariablesStack().putVariable((VariableDeclaration)asVariable, (CGVariable)cgAccumulator);
                        continue;
                    }
                    if (asInit == null) continue;
                    this.appendCheckedLetVariable(asVariable, asInit);
                }
            }
            for (BottomPattern pBottomPattern2 : pBottomPatterns) {
                @NonNull EList assignment = ClassUtil.nullFree((EList)pBottomPattern2.getAssignment());
                for (Iterator pAssignment : assignment) {
                    if (!(pAssignment instanceof VariableAssignment)) continue;
                    VariableAssignment asVariableAssignment = (VariableAssignment)pAssignment;
                    Variable asVariable = asVariableAssignment.getTargetVariable();
                    OCLExpression asInit = asVariableAssignment.getValue();
                    assert (asVariable != null && asInit != null);
                    this.appendCheckedLetVariable(asVariable, asInit);
                }
            }
            for (BottomPattern pBottomPattern2 : pBottomPatterns) {
                for (Predicate asPredicate : ClassUtil.nullFree((EList)pBottomPattern2.getPredicate())) {
                    this.appendSubTree((CGValuedElement)QVTiAS2CGVisitor.this.doVisit(CGValuedElement.class, (Element)asPredicate));
                }
            }
            ArrayList<@NonNull RealizedVariable> pRealizedVariables = new ArrayList<RealizedVariable>();
            for (BottomPattern pBottomPattern3 : pBottomPatterns) {
                for (RealizedVariable asRealizedVariable : ClassUtil.nullFree((EList)pBottomPattern3.getRealizedVariable())) {
                    OCLExpression asInit = asRealizedVariable.getOwnedInit();
                    if (asInit == null) {
                        pRealizedVariables.add(asRealizedVariable);
                        continue;
                    }
                    this.appendCheckedLetVariable((Variable)asRealizedVariable, asInit);
                }
            }
            Collections.sort(pRealizedVariables, NameUtil.NAMEABLE_COMPARATOR);
            @NonNull List cgRealizedVariables = ClassUtil.nullFree(cgMappingExp.getRealizedVariables());
            for (RealizedVariable pRealizedVariable : pRealizedVariables) {
                CGRealizedVariable cgVariable = QVTiAS2CGVisitor.this.getRealizedVariable(pRealizedVariable);
                cgRealizedVariables.add(cgVariable);
            }
            @NonNull List cgConnectionAssignments = ClassUtil.nullFree(cgMappingExp.getConnectionAssignments());
            @NonNull List cgPropertyAssignments = ClassUtil.nullFree(cgMappingExp.getAssignments());
            for (BottomPattern pBottomPattern4 : pBottomPatterns) {
                @NonNull EList assignment = ClassUtil.nullFree((EList)pBottomPattern4.getAssignment());
                for (Assignment pAssignment : assignment) {
                    if (pAssignment instanceof PropertyAssignment) {
                        cgPropertyAssignments.add((CGPropertyAssignment)QVTiAS2CGVisitor.this.doVisit(CGPropertyAssignment.class, (Element)pAssignment));
                        continue;
                    }
                    if (pAssignment instanceof ConnectionAssignment) {
                        cgConnectionAssignments.add((CGConnectionAssignment)QVTiAS2CGVisitor.this.doVisit(CGConnectionAssignment.class, (Element)pAssignment));
                        continue;
                    }
                    assert (pAssignment instanceof VariableAssignment);
                }
            }
            this.appendSubTree(cgMappingExp);
        }

        public void doGuards() {
            ArrayList<@NonNull GuardPattern> guardPatterns = new ArrayList<GuardPattern>();
            GuardPattern pGuardPattern = this.asMapping.getGuardPattern();
            if (pGuardPattern != null) {
                guardPatterns.add(pGuardPattern);
            }
            for (Domain pDomain : ClassUtil.nullFree((EList)this.asMapping.getDomain())) {
                GuardPattern guardPattern;
                if (!(pDomain instanceof CoreDomain) || (guardPattern = ((CoreDomain)pDomain).getGuardPattern()) == null) continue;
                guardPatterns.add(guardPattern);
            }
            HashSet<@NonNull Iterator> predicatedVariables = new HashSet<Iterator>();
            for (GuardPattern pGuardPattern2 : guardPatterns) {
                for (Predicate predicate : pGuardPattern2.getPredicate()) {
                    if (!(predicate instanceof VariablePredicate)) continue;
                    Iterator targetVariable = ((VariablePredicate)predicate).getTargetVariable();
                    assert (targetVariable != null);
                    predicatedVariables.add(targetVariable);
                }
            }
            ArrayList<@NonNull Variable> pGuardVariables = new ArrayList<Variable>();
            for (GuardPattern pGuardPattern3 : guardPatterns) {
                for (Variable pGuardVariable : ClassUtil.nullFree((EList)pGuardPattern3.getVariable())) {
                    if (predicatedVariables.contains(pGuardVariable)) continue;
                    pGuardVariables.add(pGuardVariable);
                }
            }
            Collections.sort(pGuardVariables, new Comparator<NamedElement>(){

                @Override
                public int compare(@NonNull NamedElement o1, @NonNull NamedElement o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            ArrayList<@NonNull CGGuardVariable> cgFreeVariables = new ArrayList<CGGuardVariable>();
            for (Variable pGuardVariable : pGuardVariables) {
                OCLExpression initExpression = pGuardVariable.getOwnedInit();
                if (initExpression == null) {
                    CGGuardVariable cgUnboundVariable = QVTiAS2CGVisitor.this.getGuardVariable(pGuardVariable);
                    cgFreeVariables.add(cgUnboundVariable);
                    continue;
                }
                CGFinalVariable cgBoundVariable = (CGFinalVariable)QVTiAS2CGVisitor.this.getVariable((VariableDeclaration)pGuardVariable);
                CGValuedElement cgInit = (CGValuedElement)QVTiAS2CGVisitor.this.doVisit(CGValuedElement.class, (Element)initExpression);
                cgBoundVariable.setInit(cgInit);
                JavaLocalContext javaLocalContext = QVTiAS2CGVisitor.this.globalContext.getLocalContext((CGElement)this.cgMapping);
            }
            Collections.sort(cgFreeVariables, new Comparator<CGGuardVariable>(){

                @Override
                public int compare(@NonNull CGGuardVariable o1, @NonNull CGGuardVariable o2) {
                    String n1 = o1.getName();
                    String n2 = o2.getName();
                    return n1.compareTo(n2);
                }
            });
            this.cgMapping.getFreeVariables().addAll(cgFreeVariables);
            for (GuardPattern pGuardPattern4 : guardPatterns) {
                for (Predicate asPredicate : ClassUtil.nullFree((EList)pGuardPattern4.getPredicate())) {
                    this.appendSubTree((CGValuedElement)QVTiAS2CGVisitor.this.doVisit(CGValuedElement.class, (Element)asPredicate));
                }
            }
        }

        public String toString() {
            return String.valueOf(this.cgMapping.getBody());
        }
    }
}

