/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.core.ui.vm.asm;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.atl.core.ATLCoreException;
import org.eclipse.m2m.atl.core.IExtractor;
import org.eclipse.m2m.atl.core.IModel;
import org.eclipse.m2m.atl.core.ui.vm.asm.ASMModelWrapper;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASMExtractor
implements IExtractor {
    public void extract(IModel sourceModel, String target, Map<String, Object> options) throws ATLCoreException {
        this.extract(sourceModel, target);
    }

    public void extract(IModel sourceModel, String target) throws ATLCoreException {
        ASMModelWrapper modelWrapper = (ASMModelWrapper)sourceModel;
        ASMModel asmModel = modelWrapper.getAsmModel();
        try {
            if (target.startsWith("file:/")) {
                modelWrapper.getModelLoader().save(asmModel, URI.createFileURI((String)target.substring(6)).toString());
            } else if (target.startsWith("platform:/resource")) {
                modelWrapper.getModelLoader().save(asmModel, URI.createFileURI((String)target.substring(18)).toString());
            }
        }
        catch (IOException e) {
            throw new ATLCoreException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void extract(IModel sourceModel, OutputStream target, Map<String, Object> options) throws ATLCoreException {
        throw new ATLCoreException("Extraction on OutputStream unsupported by ModelLoader");
    }
}

