/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.properties.internal.quickfix;

import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.customization.properties.generation.layout.ILayoutGenerator;
import org.eclipse.papyrus.customization.properties.generation.layout.StandardLayoutGenerator;
import org.eclipse.papyrus.infra.properties.contexts.Context;
import org.eclipse.papyrus.infra.properties.contexts.ContextsPackage;
import org.eclipse.papyrus.infra.properties.contexts.DataContextElement;
import org.eclipse.papyrus.infra.properties.contexts.Property;
import org.eclipse.papyrus.infra.properties.contexts.Section;
import org.eclipse.papyrus.infra.properties.contexts.View;
import org.eclipse.papyrus.infra.properties.environment.PropertyEditorType;
import org.eclipse.papyrus.infra.properties.environment.WidgetType;
import org.eclipse.papyrus.infra.properties.ui.CompositeWidget;
import org.eclipse.papyrus.infra.properties.ui.PropertyEditor;
import org.eclipse.papyrus.infra.properties.ui.UiFactory;
import org.eclipse.papyrus.infra.properties.ui.UiPackage;
import org.eclipse.papyrus.infra.properties.ui.Widget;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.constants.PropertiesPluginValidationConstants;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.messages.Messages;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.quickfix.AbstractModelEditResolutionFactory;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.util.PropertiesCache;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.util.WidgetTypeHelper;
import org.eclipse.ui.IMarkerResolution;

class DataContextPropertyResolutionFactory
extends AbstractModelEditResolutionFactory {
    DataContextPropertyResolutionFactory(int problemID) {
        super(problemID);
    }

    @Override
    protected Iterable<IMarkerResolution> createResolutions() {
        switch (this.getProblemID()) {
            case 16715845: {
                return List.of(this.addDataContextProperty(), this.addDataContextPropertyAndEditor());
            }
            case 16715846: {
                return List.of(this.removeDataContextProperty());
            }
        }
        return List.of();
    }

    IMarkerResolution addDataContextProperty() {
        return this.createResolution(Messages.DataContextPropertyResolutionFactory_0, Messages.DataContextPropertyResolutionFactory_1, DataContextElement.class, this::createAddDataContextPropertyCommand);
    }

    IMarkerResolution addDataContextPropertyAndEditor() {
        return this.createResolution(Messages.DataContextPropertyResolutionFactory_2, Messages.DataContextPropertyResolutionFactory_3, DataContextElement.class, this::createAddDataContextPropertyAndEditorCommand);
    }

    private Command createAddDataContextPropertyCommand(EditingDomain domain, DataContextElement element) {
        return PropertiesPluginValidationConstants.getObjectToReference(this.getMarker(), EObject.class, domain).map(sourceProperty -> this.createDataContextProperty(domain, (EObject)sourceProperty)).map(property -> AddCommand.create((EditingDomain)domain, (Object)element, (Object)ContextsPackage.Literals.DATA_CONTEXT_ELEMENT__PROPERTIES, (Object)property)).orElse(null);
    }

    private Command createAddDataContextPropertyAndEditorCommand(EditingDomain domain, DataContextElement element) {
        return PropertiesPluginValidationConstants.getObjectToReference(this.getMarker(), EObject.class, domain).map(sourceProperty -> this.createDataContextProperty(domain, (EObject)sourceProperty)).map(property -> {
            CompoundCommand result = new CompoundCommand();
            result.append(AddCommand.create((EditingDomain)domain, (Object)element, (Object)ContextsPackage.Literals.DATA_CONTEXT_ELEMENT__PROPERTIES, (Object)property));
            List<Section> sections = PropertiesCache.getInstance((Notifier)element).getSections(element);
            if (sections.isEmpty()) {
                Command createViews = this.createCreateViewsForPropertyEditorCommand(domain, element, (Property)property);
                if (createViews != null) {
                    result.append(createViews);
                }
            } else {
                for (Section section : PropertiesCache.getInstance((Notifier)element).getSections(element)) {
                    Command createPropertyEditor;
                    if (this.getElementMultiplicity(section) != 1 || (createPropertyEditor = this.createCreatePropertyEditorCommand(domain, section, element, (Property)property)) == null) continue;
                    result.append(createPropertyEditor);
                }
            }
            return result.unwrap();
        }).orElse(null);
    }

    private Command createCreatePropertyEditorCommand(EditingDomain domain, Section section, DataContextElement element, Property property) {
        WidgetType type;
        Command result = null;
        CompositeWidget composite = (CompositeWidget)Iterators.getLast(this.widgeterator(section), null);
        if (composite != null && this.getPropertyEditor(section, element, property) == null && (type = WidgetTypeHelper.getInstance((Widget)composite).getDefaultWidgetType(property)) instanceof PropertyEditorType) {
            PropertyEditor editor = UiFactory.eINSTANCE.createPropertyEditor();
            editor.setProperty(property);
            editor.setWidgetType((PropertyEditorType)type);
            result = AddCommand.create((EditingDomain)domain, (Object)composite, (Object)UiPackage.Literals.COMPOSITE_WIDGET__WIDGETS, (Object)editor);
        }
        return result;
    }

    private Command createCreateViewsForPropertyEditorCommand(EditingDomain domain, DataContextElement element, Property property) {
        CompoundCommand result = new CompoundCommand();
        Context context = this.getContext(element);
        ILayoutGenerator layout = this.getLayoutGeneratorClass().map(this::instantiateLayout).orElseGet(StandardLayoutGenerator::new);
        Stream.of(this.createView(context, element, 1), this.createView(context, element, -1)).map(view -> this.createLayoutCommand(domain, layout, context, element, (View)view, (Collection<? extends Property>)Set.of(property))).forEach(arg_0 -> ((CompoundCommand)result).append(arg_0));
        return result.unwrap();
    }

    IMarkerResolution removeDataContextProperty() {
        return this.createResolution(Messages.DataContextPropertyResolutionFactory_4, Messages.DataContextPropertyResolutionFactory_5, Property.class, this::createDeleteDataContextPropertyCommand);
    }

    private Command createDeleteDataContextPropertyCommand(EditingDomain domain, Property property) {
        DataContextElement element = property.getContextElement();
        return Optional.ofNullable(element).map(container -> {
            CompoundCommand result = new CompoundCommand();
            result.append(RemoveCommand.create((EditingDomain)domain, (Object)property));
            PropertiesCache.getInstance((Notifier)element).getSections(element).forEach(Section::getWidget);
            PropertiesCache.getInstance((Notifier)element).getReferencers((EObject)property, UiPackage.Literals.PROPERTY_EDITOR__PROPERTY).stream().map(propertyEditor -> RemoveCommand.create((EditingDomain)domain, (Object)propertyEditor)).forEach(arg_0 -> ((CompoundCommand)result).append(arg_0));
            return result.unwrap();
        }).orElse(null);
    }
}

