/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editpolicies;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AbstractMaskManagedEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.helper.PropertyLabelHelper;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public abstract class DisplayAssociationEndEditPolicy
extends AbstractMaskManagedEditPolicy {
    private final PropertyLabelHelper propertyLabelHelper = this.createPropertyLabelHelper();

    @Override
    protected Element initSemanticElement() {
        return this.propertyLabelHelper.getUMLElement(this.getHost());
    }

    @Override
    public void addAdditionalListeners() {
        Property umlElement = this.getUMLElement();
        if (umlElement != null) {
            if (umlElement.getType() != null) {
                this.getDiagramEventBroker().addNotificationListener((EObject)umlElement.getType(), (NotificationListener)this);
            }
            this.getDiagramEventBroker().addNotificationListener((EObject)umlElement.getUpperValue(), (NotificationListener)this);
            this.getDiagramEventBroker().addNotificationListener((EObject)umlElement.getLowerValue(), (NotificationListener)this);
        }
    }

    @Override
    protected Collection<String> getDefaultDisplayValue() {
        return Arrays.asList("visibility", "derived", "name");
    }

    public Map<String, String> getMasks() {
        return this.propertyLabelHelper.getMasks();
    }

    public Property getUMLElement() {
        Element element = super.getUMLElement();
        if (element instanceof Property) {
            return (Property)element;
        }
        return null;
    }

    @Override
    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        Object object = notification.getNotifier();
        Property property = this.getUMLElement();
        if (property == null) {
            return;
        }
        if (notification.getFeature() == NotationPackage.Literals.EDGE__TARGET || notification.getFeature() == NotationPackage.Literals.EDGE__SOURCE) {
            this.refreshDisplay();
        }
        if (object == null) {
            return;
        }
        if (notification.getFeature() == UMLPackage.Literals.LITERAL_INTEGER__VALUE) {
            this.refreshDisplay();
        } else if (notification.getFeature() == UMLPackage.Literals.LITERAL_UNLIMITED_NATURAL__VALUE) {
            this.refreshDisplay();
        }
        if (object.equals(property)) {
            this.notifyPropertyChanged(property, notification);
        } else if (object.equals(property.getType())) {
            this.notifyPropertyTypeChanged(property.getType(), notification);
        }
        if (this.isMaskManagedAnnotation(object)) {
            this.refreshDisplay();
        }
        if (this.isRemovedMaskManagedLabelAnnotation(object, notification)) {
            this.refreshDisplay();
        }
    }

    protected void notifyPropertyChanged(Property property, Notification notification) {
        switch (notification.getFeatureID(Property.class)) {
            case 5: 
            case 9: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 35: 
            case 37: 
            case 42: 
            case 43: {
                this.refreshDisplay();
                break;
            }
            case 15: {
                switch (notification.getEventType()) {
                    case 3: {
                        this.getDiagramEventBroker().addNotificationListener((EObject)notification.getNewValue(), (NotificationListener)this);
                        this.refreshDisplay();
                        break;
                    }
                    case 5: {
                        if (notification.getNewValue() instanceof List) {
                            List addedElements = (List)notification.getNewValue();
                            for (Object addedElement : addedElements) {
                                if (!(addedElement instanceof EObject)) continue;
                                this.getDiagramEventBroker().addNotificationListener((EObject)addedElement, (NotificationListener)this);
                            }
                        }
                        this.refreshDisplay();
                        break;
                    }
                    case 4: {
                        this.getDiagramEventBroker().removeNotificationListener((EObject)notification.getOldValue(), (NotificationListener)this);
                        this.refreshDisplay();
                        break;
                    }
                    case 6: {
                        if (notification.getOldValue() instanceof List) {
                            List removedElements = (List)notification.getOldValue();
                            for (Object removedElement : removedElements) {
                                if (!(removedElement instanceof EObject)) continue;
                                this.getDiagramEventBroker().removeNotificationListener((EObject)removedElement, (NotificationListener)this);
                            }
                        }
                        this.refreshDisplay();
                        break;
                    }
                    case 1: {
                        if (notification.getNewValue() != null) {
                            this.getDiagramEventBroker().addNotificationListener((EObject)notification.getNewValue(), (NotificationListener)this);
                        }
                        if (notification.getOldValue() != null) {
                            this.getDiagramEventBroker().removeNotificationListener((EObject)notification.getOldValue(), (NotificationListener)this);
                        }
                        this.refreshDisplay();
                    }
                }
                break;
            }
        }
    }

    protected void notifyPropertyTypeChanged(Type type, Notification notification) {
        switch (notification.getFeatureID(Property.class)) {
            case 5: {
                this.refreshDisplay();
                break;
            }
        }
    }

    @Override
    public void refreshDisplay() {
        this.propertyLabelHelper.refreshEditPartDisplay(this.getHost());
    }

    @Override
    protected void removeAdditionalListeners() {
        super.removeAdditionalListeners();
        if (this.getUMLElement() != null && this.getUMLElement().getType() != null) {
            this.getDiagramEventBroker().removeNotificationListener((EObject)this.getUMLElement().getType(), (NotificationListener)this);
        }
    }

    protected abstract PropertyLabelHelper createPropertyLabelHelper();
}

