/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.architecture;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.papyrus.infra.architecture.Activator;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.architecture.commands.IModelConversionCommand;
import org.eclipse.papyrus.infra.architecture.commands.IModelCreationCommand;
import org.eclipse.papyrus.infra.architecture.commands.ModelCommandProviderRegistry;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDescription;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDescriptionPreferences;
import org.eclipse.papyrus.infra.core.architecture.ArchitecturePackage;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureViewpoint;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.sasheditor.DiModelUtils;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModelUtils;

public class ArchitectureDescriptionUtils {
    private ModelSet modelSet;
    private ArchitectureDomainManager manager = ArchitectureDomainManager.getInstance();

    public ArchitectureDescriptionUtils(ModelSet modelSet) {
        this.modelSet = modelSet;
    }

    public ModelSet getModelSet() {
        return this.modelSet;
    }

    public MergedArchitectureContext getArchitectureContext() {
        String contextId = this.getArchitectureContextId();
        return this.manager.getArchitectureContextById(contextId);
    }

    public String getArchitectureContextId() {
        ArchitectureDescription description = DiModelUtils.getArchitectureDescription((ModelSet)this.modelSet);
        if (description != null) {
            return description.getContextId();
        }
        return ArchitectureDomainManager.getInstance().getDefaultArchitectureContextId();
    }

    public Collection<MergedArchitectureViewpoint> getArchitectureViewpoints() {
        ArrayList<MergedArchitectureViewpoint> viewpoints = new ArrayList<MergedArchitectureViewpoint>();
        for (String viewpointId : this.getArchitectureViewpointIds()) {
            MergedArchitectureViewpoint viewpoint = this.manager.getArchitectureViewpointById(viewpointId);
            if (viewpoint == null) continue;
            viewpoints.add(viewpoint);
        }
        return viewpoints;
    }

    public Collection<String> getArchitectureViewpointIds() {
        ArchitectureDescriptionPreferences preferences = SashModelUtils.getArchitectureDescriptionPreferences((ModelSet)this.modelSet);
        if (preferences != null) {
            return preferences.getViewpointIds();
        }
        LinkedHashSet<String> viewpointIds = new LinkedHashSet<String>();
        MergedArchitectureContext context = this.getArchitectureContext();
        if (context != null) {
            Collection<MergedArchitectureViewpoint> viewpoints = context.getDefaultViewpoints();
            if (viewpoints.isEmpty()) {
                viewpoints = context.getViewpoints();
            }
            for (MergedArchitectureViewpoint viewpoint : viewpoints) {
                viewpointIds.add(viewpoint.getId());
            }
        }
        return viewpointIds;
    }

    public Command createNewModel(String contextId, String[] viewpointIds) {
        CompoundCommand cc = new CompoundCommand("Create New Model");
        cc.append(this.getSetContextCommand(contextId));
        cc.append(this.getSetViewpointCommand(viewpointIds));
        cc.append(this.getModelCreationCommand(contextId));
        cc.append(ModelCommandProviderRegistry.getInstance().getModelCreationCommand(this.modelSet, contextId));
        return cc;
    }

    public Command switchArchitectureContextId(String contextId) {
        CompoundCommand cc = new CompoundCommand("Switch Architecture Context");
        cc.append(this.getModelConversionCommand(contextId));
        cc.append(ModelCommandProviderRegistry.getInstance().getModelConversionCommand(this.modelSet, contextId));
        cc.append(this.getSetContextCommand(contextId));
        return cc;
    }

    public Command switchArchitectureViewpointIds(String[] viewpointIds) {
        CompoundCommand cc = new CompoundCommand("Switch Architecture Viewpoints");
        cc.append(this.getSetViewpointCommand(viewpointIds));
        return cc;
    }

    protected Command getSetContextCommand(final String contextId) {
        return new RecordingCommand(this.modelSet.getTransactionalEditingDomain()){

            protected void doExecute() {
                ArchitectureDescription description = DiModelUtils.getOrAddArchitectureDescription((ModelSet)ArchitectureDescriptionUtils.this.modelSet);
                description.setContextId(contextId);
            }
        };
    }

    protected Command getModelCreationCommand(String contextId) {
        final MergedArchitectureContext context = this.manager.getArchitectureContextById(contextId);
        if (context.getCreationCommandClassName() == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return new RecordingCommand(this.modelSet.getTransactionalEditingDomain()){

            protected void doExecute() {
                try {
                    IModelCreationCommand creationCommand = context.getCreationCommandClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                    creationCommand.createModel(ArchitectureDescriptionUtils.this.modelSet);
                }
                catch (Exception e) {
                    Activator.log.error((Throwable)e);
                }
            }
        };
    }

    protected Command getModelConversionCommand(String contextId) {
        final MergedArchitectureContext context = this.manager.getArchitectureContextById(contextId);
        if (context.getConversionCommandClassName() == null) {
            return null;
        }
        return new RecordingCommand(this.modelSet.getTransactionalEditingDomain()){

            protected void doExecute() {
                try {
                    IModelConversionCommand conversionCommand = context.getConversionCommandClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                    conversionCommand.convertModel(ArchitectureDescriptionUtils.this.modelSet);
                }
                catch (Exception e) {
                    Activator.log.error((Throwable)e);
                }
            }
        };
    }

    protected Command getSetViewpointCommand(final String[] viewpointIds) {
        return new RecordingCommand(this.modelSet.getTransactionalEditingDomain()){

            protected void doExecute() {
                ArchitectureDescriptionPreferences preferences = SashModelUtils.getOrAddArchitectureDescriptionPreferences((ModelSet)ArchitectureDescriptionUtils.this.modelSet);
                Arrays.sort(viewpointIds);
                preferences.eSet((EStructuralFeature)ArchitecturePackage.eINSTANCE.getArchitectureDescriptionPreferences_ViewpointIds(), Arrays.asList(viewpointIds));
            }
        };
    }
}

