/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.validation.constraints;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.uml2.uml.AcceptCallAction;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Trigger;

public class FumlAcceptCallActionCallEventOperationsConstraint
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        AcceptCallAction acceptCallAction = (AcceptCallAction)ctx.getTarget();
        if (acceptCallAction.getContext() instanceof Class) {
            Class cls = (Class)acceptCallAction.getContext();
            Set classes = cls.allParents().stream().filter(c -> c instanceof Class).map(c -> (Class)Class.class.cast(c)).collect(Collectors.toSet());
            classes.add(cls);
            HashSet<Operation> triggersOperation = new HashSet<Operation>();
            for (Trigger trigger : acceptCallAction.getTriggers()) {
                if (!(trigger.getEvent() instanceof CallEvent)) continue;
                triggersOperation.add(((CallEvent)trigger.getEvent()).getOperation());
            }
            HashSet classesOperation = new HashSet();
            for (Class clazz : classes) {
                classesOperation.addAll(clazz.getOwnedOperations());
            }
            if (!classesOperation.containsAll(triggersOperation)) {
                return ctx.createFailureStatus(new Object[]{"AcceptCallAction - The operations of the call events on the triggers of an accept call action must be owned or inherited by the context class of the action."});
            }
        }
        return ctx.createSuccessStatus();
    }
}

