/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.dev.tools.handlers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.model2doc.dev.tools.Activator;
import org.eclipse.papyrus.model2doc.dev.tools.handlers.SelectionUtils;
import org.eclipse.papyrus.model2doc.dev.tools.utils.XMLFormatter;

public abstract class AbstractZipFileHandler
extends AbstractHandler {
    protected static final String XML_EXTENSION = "xml";

    protected static final String getOSPathFromURI(URI uri) {
        String workspaceLocation = null;
        if (uri.isPlatformResource()) {
            workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true))).getRawLocation().toOSString();
        }
        return workspaceLocation;
    }

    protected final List<URI> getSelectedFileURI() {
        Iterator iter = AbstractZipFileHandler.getCurrentStructuredSelection().iterator();
        ArrayList<URI> uris = new ArrayList<URI>();
        while (iter.hasNext()) {
            Object current = iter.next();
            String pathName = null;
            if (current instanceof IAdaptable) {
                IFile f = (IFile)((IAdaptable)current).getAdapter(IFile.class);
                pathName = f.getFullPath().toPortableString();
            }
            URI uri = URI.createPlatformResourceURI(pathName, (boolean)true);
            if (!this.getFileExtension().equals(uri.fileExtension()) && !this.getTemplateExtension().equals(uri.fileExtension())) continue;
            uris.add(uri);
        }
        return uris;
    }

    protected abstract String getTemplateExtension();

    protected abstract String getFileExtension();

    public void setEnabled(Object evaluationContext) {
        super.setBaseEnabled(this.getSelectedFileURI().size() > 0);
    }

    public static final IStructuredSelection getCurrentStructuredSelection() {
        return SelectionUtils.getCurrentStructuredSelection();
    }

    protected static final void refreshWorkspace() {
        try {
            Activator.log.info("Refresh workspace");
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Activator.log.error("Exception during workspace refresh", (Throwable)e);
        }
    }

    protected static final void formatXMLFile(String filePath) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(filePath));
        XMLFormatter.format(file);
    }
}

