/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.emf.template2structure.internal.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.model2doc.core.logger.IModel2DocLogger;
import org.eclipse.papyrus.model2doc.emf.documentstructure.BodyPart;
import org.eclipse.papyrus.model2doc.emf.documentstructure.Paragraph;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentStructureTemplatePackage;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.EAttributeAsParagraph;
import org.eclipse.papyrus.model2doc.emf.template2structure.mapping.AbstractBodyPartTemplateToStructureMapper;
import org.eclipse.papyrus.model2doc.emf.template2structure.mapping.IMappingService;

public class EAttributeAsParagraphMapper
extends AbstractBodyPartTemplateToStructureMapper<EAttributeAsParagraph> {
    private static final String EMPTY_STRING = "";

    public EAttributeAsParagraphMapper() {
        super(DocumentStructureTemplatePackage.eINSTANCE.getEAttributeAsParagraph(), BodyPart.class);
    }

    @Override
    protected <T> List<T> doMap(IMappingService mappingService, EAttributeAsParagraph documentTemplateElement, EObject semanticModelElement, Class<T> expectedReturnedClass, IModel2DocLogger logger) {
        if (!documentTemplateElement.generateBranch(semanticModelElement)) {
            return Collections.emptyList();
        }
        if (!documentTemplateElement.isGenerate() || !(semanticModelElement instanceof EObject)) {
            return Collections.emptyList();
        }
        Iterator eAttributeValuesIter = documentTemplateElement.getEAttributeValues(semanticModelElement).iterator();
        ArrayList<T> generatedElements = new ArrayList<T>();
        while (eAttributeValuesIter.hasNext()) {
            Paragraph paragraph = STRUCTURE_EFACTORY.createParagraph();
            Object value = eAttributeValuesIter.next();
            if (value == null) {
                value = EMPTY_STRING;
            }
            paragraph.setText(value.toString());
            generatedElements.add(expectedReturnedClass.cast(paragraph));
        }
        return this.buildMapperResult(documentTemplateElement, semanticModelElement, expectedReturnedClass, generatedElements);
    }
}

