/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.xtend.codeassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.internal.xtend.expression.codeassist.LazyVar;
import org.eclipse.internal.xtend.xtend.XtendFile;
import org.eclipse.internal.xtend.xtend.ast.Around;
import org.eclipse.internal.xtend.xtend.ast.Extension;
import org.eclipse.internal.xtend.xtend.codeassist.Partition;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.ExpressionFacade;
import org.eclipse.xtend.expression.ResourceManager;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.typesystem.ParameterizedType;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastAnalyzer {
    private static final Pattern ENDS_WITH_SINGLE_LINE_COMMENT_PATTERN = Pattern.compile("//.*$");
    private static final Pattern CONTAINS_SINGLE_LINE_COMMENT_PATTERN = Pattern.compile("//.*$", 8);
    private static final Pattern BEGIN_MULTI_LINE_COMMENT_PATTERN = Pattern.compile("/\\*", 8);
    private static final Pattern COMPLETE_MULTI_LINE_COMMENT_PATTERN = Pattern.compile("/\\*.*\\*/", 40);
    private static final Pattern PARAM_PATTERN = Pattern.compile("([\\[\\]:\\w]+)\\s+([\\w]+)");
    private static final Pattern IMPORT_PATTERN = Pattern.compile("import\\s+([\\w\\:]+)\\s*;");
    private static final Pattern INCOMPLETE_IMPORT_PATTERN = Pattern.compile("import\\s+[\\w\\:]*\\z");
    private static final Pattern EXTENSION_PATTERN = Pattern.compile("extension\\s+([\\w\\:]+)\\s*(reexport)?\\s*;");
    private static final Pattern INCOMPLETE_EXTENSION_PATTERN = Pattern.compile("extension\\s+[\\w\\:]*\\z");
    private static final Pattern FUNCTION_PATTERN = Pattern.compile("((\\w+)\\s+)?(create\\s+([\\w:]+)(\\s+(\\w+))?\\s+)?([\\w:]+)\\s*\\(\\s*([\\[\\]:\\w\\s\\,]+)?\\s*\\)\\s*:\\s*[^;]*\\z");
    private static final Pattern AROUND_PATTERN = Pattern.compile("around\\s+([\\w:*]+)\\s*\\(\\s*([\\[\\]:\\w\\s\\,]+)?[\\s,*]*\\)\\s*:\\s*[^;]*\\z");
    private static final Pattern TYPEDECL_PATTERN = Pattern.compile("(;|\\A)\\s*\\w+(\\s*\\[\\w+\\]*)?\\s*\\w+\\s*\\(([\\[\\]:\\w\\s,]*)\\z");
    private static final Pattern TYPEDECL_PARAM_PATTERN = Pattern.compile("(,|\\(|\\A)\\s*[\\[\\]:\\w]*\\z");

    private FastAnalyzer() {
    }

    public static boolean isInsideTypeDeclaration(String s) {
        Matcher m = TYPEDECL_PATTERN.matcher(s);
        if (m.find()) {
            return TYPEDECL_PARAM_PATTERN.matcher(m.group(3)).find();
        }
        return false;
    }

    public static boolean isInsideExtensionImport(String s) {
        Matcher m = INCOMPLETE_EXTENSION_PATTERN.matcher(s);
        return m.find();
    }

    public static boolean isInsideImport(String s) {
        Matcher m = INCOMPLETE_IMPORT_PATTERN.matcher(s);
        return m.find();
    }

    public static boolean isInsideExpression(String s) {
        Matcher m1 = AROUND_PATTERN.matcher(s);
        if (!m1.find()) {
            Matcher m = FUNCTION_PATTERN.matcher(s);
            return m.find();
        }
        return true;
    }

    public static boolean isInsideComment(String input) {
        Matcher singleLineCommentMatcher = ENDS_WITH_SINGLE_LINE_COMMENT_PATTERN.matcher(input);
        if (singleLineCommentMatcher.find()) {
            return true;
        }
        Matcher removeSingleLineCommentsMatcher = CONTAINS_SINGLE_LINE_COMMENT_PATTERN.matcher(input);
        String inputWithoutSingleLineComments = removeSingleLineCommentsMatcher.replaceAll("\n");
        Matcher beinMultiLineCommentMatcher = BEGIN_MULTI_LINE_COMMENT_PATTERN.matcher(inputWithoutSingleLineComments);
        if (beinMultiLineCommentMatcher.find()) {
            int lastBeginMultiLineComment = -1;
            do {
                lastBeginMultiLineComment = beinMultiLineCommentMatcher.start();
            } while (beinMultiLineCommentMatcher.find());
            Matcher completeMultiLineCommentMatcher = COMPLETE_MULTI_LINE_COMMENT_PATTERN.matcher(inputWithoutSingleLineComments);
            return !completeMultiLineCommentMatcher.find(lastBeginMultiLineComment);
        }
        return false;
    }

    public static final List<String> findImports(String template) {
        Matcher m = IMPORT_PATTERN.matcher(template);
        ArrayList<String> result = new ArrayList<String>();
        while (m.find()) {
            result.add(m.group(1));
        }
        return result;
    }

    public static final List<String> findExtensions(String template) {
        Matcher m = EXTENSION_PATTERN.matcher(template);
        ArrayList<String> result = new ArrayList<String>();
        while (m.find()) {
            result.add(m.group(1));
        }
        return result;
    }

    public static final Stack<Set<LazyVar>> computeStack(String toAnalyze) {
        Matcher m = AROUND_PATTERN.matcher(toAnalyze);
        Pattern p = AROUND_PATTERN;
        HashSet<LazyVar> vars = new HashSet<LazyVar>();
        if (!m.find()) {
            m = FUNCTION_PATTERN.matcher(toAnalyze);
            p = FUNCTION_PATTERN;
            if (m.find()) {
                int start = m.start();
                toAnalyze = toAnalyze.substring(start);
                m = p.matcher(toAnalyze);
                m.find();
                if (m.group(4) != null) {
                    LazyVar v = new LazyVar();
                    v.typeName = m.group(4);
                    v.name = m.group(6);
                    if (v.name == null) {
                        v.name = "this";
                    }
                    vars.add(v);
                }
                FastAnalyzer.fillParams(vars, m.group(8));
            }
        } else {
            FastAnalyzer.fillParams(vars, m.group(2));
            LazyVar v = new LazyVar();
            v.typeName = "xtend::AdviceContext";
            v.name = "ctx";
            vars.add(v);
        }
        Stack<Set<LazyVar>> stack = new Stack<Set<LazyVar>>();
        stack.push(vars);
        return stack;
    }

    private static void fillParams(Set<LazyVar> vars, String params) {
        if (params != null && !"".equals(params.trim())) {
            StringTokenizer st = new StringTokenizer(params, ",");
            while (st.hasMoreTokens()) {
                String param = st.nextToken();
                Matcher m = PARAM_PATTERN.matcher(param);
                if (!m.find()) continue;
                LazyVar v = new LazyVar();
                v.typeName = m.group(1);
                v.name = m.group(2);
                vars.add(v);
            }
        }
    }

    public static final Partition computePartition(String str) {
        if (FastAnalyzer.isInsideComment(str)) {
            return Partition.COMMENT;
        }
        if (FastAnalyzer.isInsideImport(str)) {
            return Partition.NAMESPACE_IMPORT;
        }
        if (FastAnalyzer.isInsideExtensionImport(str)) {
            return Partition.EXTENSION_IMPORT;
        }
        if (FastAnalyzer.isInsideTypeDeclaration(str)) {
            return Partition.TYPE_DECLARATION;
        }
        if (FastAnalyzer.isInsideExpression(str)) {
            return Partition.EXPRESSION;
        }
        return Partition.DEFAULT;
    }

    public static final ExecutionContext computeExecutionContext(String str, ExecutionContext ctx, final List<Extension> extensions) {
        Partition p = FastAnalyzer.computePartition(str);
        if (p == Partition.EXPRESSION || p == Partition.TYPE_DECLARATION || p == Partition.DEFAULT) {
            final List<String> imports = FastAnalyzer.findImports(str);
            final List<String> extensionImports = FastAnalyzer.findExtensions(str);
            XtendFile tpl = new XtendFile(){
                private String fqn;

                @Override
                public String getFullyQualifiedName() {
                    return this.fqn;
                }

                @Override
                public void setFullyQualifiedName(String fqn) {
                    this.fqn = fqn;
                }

                @Override
                public String[] getImportedNamespaces() {
                    return imports.toArray(new String[imports.size()]);
                }

                @Override
                public String[] getImportedExtensions() {
                    return extensionImports.toArray(new String[extensionImports.size()]);
                }

                @Override
                public List<Extension> getExtensions() {
                    return extensions;
                }

                @Override
                public void analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
                }

                @Override
                public List<Extension> getPublicExtensions(ResourceManager rm, ExecutionContext ctx) {
                    return extensions;
                }

                @Override
                public List<Extension> getPublicExtensions(ResourceManager resourceManager, ExecutionContext ctx, Set<String> flowoverCache) {
                    return extensions;
                }

                @Override
                public List<Around> getArounds() {
                    return Collections.emptyList();
                }
            };
            ctx = ctx.cloneWithResource(tpl);
            Stack<Set<LazyVar>> s = FastAnalyzer.computeStack(str);
            for (Set set : s) {
                for (LazyVar v : set) {
                    Type vType = null;
                    if (v.typeName != null) {
                        vType = ctx.getTypeForName(v.typeName);
                    } else {
                        vType = new ExpressionFacade(ctx).analyze(v.expression, new HashSet<AnalysationIssue>());
                        if (v.forEach) {
                            vType = vType instanceof ParameterizedType ? ((ParameterizedType)vType).getInnerType() : null;
                        }
                    }
                    ctx = ctx.cloneWithVariable(new Variable(v.name, vType));
                }
            }
        }
        return ctx;
    }
}

