/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpand2.incremental;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.NullProgressMonitor;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.utils.FileCopy;
import org.eclipse.emf.mwe.utils.Reader;
import org.eclipse.emf.mwe.utils.Writer;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.xpand2.incremental.FileCleaner;
import org.eclipse.xpand2.incremental.IncrementalGenerationCallback;
import org.eclipse.xpand2.incremental.compare.EmfCompare;
import org.eclipse.xpand2.output.Outlet;
import org.eclipse.xtend.expression.ExecutionContext;

public class IncrementalGenerationFacade
extends IncrementalGenerationCallback {
    private static final String NEWMODEL_SLOT = "model";
    private static final String OLDMODEL_SLOT = "__OLDMODEL";
    private static final String OLDTRACE_SLOT = "__OLDTRACE";
    private static final String NEWTRACE_SLOT = "__NEWTRACE";
    private static final String DIFF_SLOT = "__DIFF";
    private String newModelFile;
    private String oldModelFile;
    private String traceModelFile;
    private List<Outlet> outlets = new ArrayList<Outlet>();
    private SyntaxElement firstExpression;
    private Reader oldModelReader;
    private Reader newModelReader;
    private Reader traceModelReader;
    private Writer traceModelWriter;
    private EmfCompare modelComparer;
    private FileCleaner cleaner;
    private FileCopy copier;
    private WorkflowContext workflowContext;
    private Issues issues;

    public String getNewModelFile() {
        return this.newModelFile;
    }

    public void setNewModelFile(String newModelFile) {
        this.newModelFile = newModelFile;
    }

    public String getOldModelFile() {
        return this.oldModelFile;
    }

    public void setOldModelFile(String oldModelFile) {
        this.oldModelFile = oldModelFile;
    }

    public String getTraceModelFile() {
        return this.traceModelFile;
    }

    public void setTraceModelFile(String traceModelFile) {
        this.traceModelFile = traceModelFile;
    }

    public void addOutlet(Outlet outlet) {
        if (outlet == null) {
            return;
        }
        this.outlets.add(outlet);
    }

    protected void checkConfigurationInternal(Issues issues) {
        if (this.getOldModelFile() == null) {
            issues.addError("No oldModelFile given. Cannot do incremental generation.");
        }
        if (this.getNewModelFile() == null) {
            issues.addError("No newModelFile given. Cannot do incremental generation.");
        }
        if (this.getTraceModelFile() == null) {
            issues.addError("No traceModelFile given. Cannot do incremental generation.");
        }
        if (this.outlets.isEmpty()) {
            issues.addError("No outlets given.");
        }
        this.setDiffModelSlot(DIFF_SLOT);
        this.setNewTraceModelSlot(NEWTRACE_SLOT);
        this.setOldTraceModelSlot(OLDTRACE_SLOT);
        super.checkConfigurationInternal(issues);
    }

    public void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        this.workflowContext = ctx;
        this.issues = issues;
        this.prepareComponents();
        this.newModelReader.invoke(ctx, monitor, issues);
        this.oldModelReader.invoke(ctx, monitor, issues);
        this.modelComparer.invoke(ctx, monitor, issues);
        this.traceModelReader.invoke(ctx, monitor, issues);
        super.invokeInternal(ctx, monitor, issues);
    }

    private void prepareComponents() {
        this.oldModelReader = new Reader();
        this.oldModelReader.setUri(this.oldModelFile);
        this.oldModelReader.setModelSlot(OLDMODEL_SLOT);
        this.oldModelReader.setIgnoreMissingModel(true);
        this.oldModelReader.setFirstElementOnly(true);
        this.newModelReader = new Reader();
        this.newModelReader.setUri(this.newModelFile);
        this.newModelReader.setModelSlot(NEWMODEL_SLOT);
        this.newModelReader.setFirstElementOnly(true);
        this.traceModelReader = new Reader();
        this.traceModelReader.setUri(this.traceModelFile);
        this.traceModelReader.setModelSlot(OLDTRACE_SLOT);
        this.traceModelReader.setIgnoreMissingModel(true);
        this.traceModelReader.setFirstElementOnly(true);
        this.traceModelWriter = new Writer();
        this.traceModelWriter.setUri(this.traceModelFile);
        this.traceModelWriter.setModelSlot(NEWTRACE_SLOT);
        this.traceModelWriter.setIgnoreEmptySlot(true);
        this.modelComparer = new EmfCompare();
        this.modelComparer.setOldModelSlot(OLDMODEL_SLOT);
        this.modelComparer.setNewModelSlot(NEWMODEL_SLOT);
        this.modelComparer.setDiffModelSlot(DIFF_SLOT);
        this.cleaner = new FileCleaner();
        this.cleaner.setOldTraceModelSlot(OLDTRACE_SLOT);
        this.cleaner.setNewTraceModelSlot(NEWTRACE_SLOT);
        for (Outlet o : this.outlets) {
            this.cleaner.addOutlet(o);
        }
        this.copier = new FileCopy();
        this.copier.setSourceFile(this.newModelFile);
        this.copier.setTargetFile(this.oldModelFile);
    }

    public boolean pre(SyntaxElement element, ExecutionContext ctx) {
        if (this.firstExpression == null) {
            this.firstExpression = element;
        }
        return super.pre(element, ctx);
    }

    public void post(SyntaxElement element, ExecutionContext ctx, Object expressionResult) {
        super.post(element, ctx, expressionResult);
        if (element == this.firstExpression) {
            NullProgressMonitor nullMonitor = new NullProgressMonitor();
            this.cleaner.invoke(this.workflowContext, (ProgressMonitor)nullMonitor, this.issues);
            this.traceModelWriter.invoke(this.workflowContext, (ProgressMonitor)nullMonitor, this.issues);
            this.copier.invoke(this.workflowContext, (ProgressMonitor)nullMonitor, this.issues);
        }
    }
}

