/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.config.java;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.lsp4mp.commons.MicroProfileJavaInlayHintSettings;
import org.eclipse.lsp4mp.jdt.core.java.inlayhint.JavaASTInlayHint;
import org.eclipse.lsp4mp.jdt.core.java.inlayhint.JavaInlayHintsContext;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;

public class MicroProfileConfigASTInlayHint
extends JavaASTInlayHint {
    private static final Logger LOGGER = Logger.getLogger(MicroProfileConfigASTInlayHint.class.getName());

    public boolean visit(FieldDeclaration fieldDeclaration) {
        List modifiers = fieldDeclaration.modifiers();
        for (Object modifier : modifiers) {
            if (!(modifier instanceof NormalAnnotation) || !AnnotationUtils.isMatchAnnotation((Annotation)((NormalAnnotation)modifier), "org.eclipse.microprofile.config.inject.ConfigProperty")) continue;
            ITypeBinding fieldBinding = fieldDeclaration.getType().resolveBinding();
            this.getContext().addConverterInlayHint(fieldBinding, (ASTNode)fieldDeclaration);
        }
        return true;
    }

    public boolean visit(NormalAnnotation annotation) {
        if (AnnotationUtils.isMatchAnnotation((Annotation)annotation, "org.eclipse.microprofile.config.inject.ConfigProperty") && annotation.getParent() instanceof FieldDeclaration) {
            JavaInlayHintsContext context = this.getContext();
            MicroProfileJavaInlayHintSettings settings = context.getSettings();
            if (settings.getDefaultValues().isEnabled()) {
                MicroProfileConfigASTInlayHint.generateDefaultValueInlayHint(annotation, context);
            }
            if (settings.getConverters().isEnabled()) {
                MicroProfileConfigASTInlayHint.generateConverterInlayHint(annotation, context);
            }
        }
        return true;
    }

    private static void generateConverterInlayHint(NormalAnnotation annotation, JavaInlayHintsContext context) {
        FieldDeclaration fieldDeclaration = (FieldDeclaration)annotation.getParent();
        List fragments = fieldDeclaration.fragments();
        if (!fragments.isEmpty()) {
            ITypeBinding fieldBinding = fieldDeclaration.getType().resolveBinding();
            context.addConverterInlayHint(fieldBinding, (ASTNode)fragments.get(0));
        }
    }

    private static void generateDefaultValueInlayHint(NormalAnnotation annotation, JavaInlayHintsContext context) {
        try {
            Expression defaultValueExpr;
            Expression nameExpr = AnnotationUtils.getAnnotationMemberValueExpression((Annotation)annotation, "name");
            if (nameExpr != null && (defaultValueExpr = AnnotationUtils.getAnnotationMemberValueExpression((Annotation)annotation, "defaultValue")) == null) {
                String propertyKey = JDTTypeUtils.extractStringValue(nameExpr);
                String propertyValue = context.getMicroProfileProject().getProperty(propertyKey);
                if (StringUtils.isNotBlank((CharSequence)propertyValue)) {
                    context.addInlayHint(", defaultValue=\"" + propertyValue + "\"", nameExpr.getStartPosition() + nameExpr.getLength(), 0);
                }
            }
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.WARNING, "Exception when trying to get defaultValue of a @ConfigProperty annotation while calculating diagnostics for it", e);
        }
    }
}

