/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.completion;

import com.google.common.base.Functions;
import com.google.common.base.Strings;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ContextInformationValidator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.internal.ArrayUtil;
import org.eclipse.lsp4e.internal.CancellationSupport;
import org.eclipse.lsp4e.internal.CancellationUtil;
import org.eclipse.lsp4e.internal.NullSafetyHelper;
import org.eclipse.lsp4e.operations.completion.LSCompletionProposal;
import org.eclipse.lsp4e.operations.completion.LSCompletionProposalComparator;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.CompletionContext;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemDefaults;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.SignatureHelpParams;
import org.eclipse.lsp4j.SignatureInformation;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.ui.texteditor.ITextEditor;

public class LSContentAssistProcessor
implements IContentAssistProcessor {
    private static final ICompletionProposal[] NO_COMPLETION_PROPOSALS = new ICompletionProposal[0];
    private static final long TRIGGERS_TIMEOUT = 50L;
    private static final long CONTEXT_INFORMATION_TIMEOUT = 1000L;
    private @Nullable IDocument currentDocument;
    private @Nullable String errorMessage;
    private final boolean errorAsCompletionItem;
    private volatile char[] completionTriggerChars = ArrayUtil.NO_CHARS;
    private @Nullable CompletableFuture<List<@Nullable Void>> completionTriggerCharsFuture;
    private @Nullable CompletableFuture<List<@Nullable Void>> contextInformationTriggerCharsFuture;
    private @Nullable CompletableFuture<List<@Nullable Void>> contextInformationLanguageServersFuture;
    private volatile char[] contextTriggerChars = ArrayUtil.NO_CHARS;
    private final boolean incompleteAsCompletionItem;
    private CancellationSupport completionCancellationSupport;
    private CancellationSupport triggerCharsCancellationSupport;
    private final Comparator<LSCompletionProposal> proposalComparator = new LSCompletionProposalComparator();

    public LSContentAssistProcessor() {
        this(true);
    }

    public LSContentAssistProcessor(boolean errorAsCompletionItem) {
        this(errorAsCompletionItem, true);
    }

    public LSContentAssistProcessor(boolean errorAsCompletionItem, boolean incompleteAsCompletionItem) {
        this.errorAsCompletionItem = errorAsCompletionItem;
        this.completionCancellationSupport = new CancellationSupport();
        this.triggerCharsCancellationSupport = new CancellationSupport();
        this.incompleteAsCompletionItem = incompleteAsCompletionItem;
    }

    /*
     * WARNING - void declaration
     */
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        Position completionPosition;
        Character triggerChar;
        IDocument document = viewer.getDocument();
        if (document == null) {
            return NO_COMPLETION_PROPOSALS;
        }
        try {
            triggerChar = LSPEclipseUtils.getCharacterAtPosition(document, offset);
            completionPosition = LSPEclipseUtils.toPosition(offset, document);
        }
        catch (BadLocationException e) {
            return NO_COMPLETION_PROPOSALS;
        }
        URI uri = LSPEclipseUtils.toUri(document);
        if (uri == null) {
            return NO_COMPLETION_PROPOSALS;
        }
        this.initiateLanguageServers(document);
        CompletionContext context = LSPEclipseUtils.toCompletionContext(triggerChar, this.completionTriggerChars);
        CompletionParams param = LSPEclipseUtils.toCompletionParams(uri, completionPosition, context);
        List<ICompletionProposal> proposals = Collections.synchronizedList(new ArrayList());
        AtomicBoolean anyIncomplete = new AtomicBoolean(false);
        try {
            this.completionCancellationSupport.cancel();
            CancellationSupport cancellationSupport = new CancellationSupport();
            CompletableFuture completionLanguageServersFuture = cancellationSupport.execute(((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withFilter(capabilities -> capabilities.getCompletionProvider() != null)).collectAll((w, ls) -> ((CompletableFuture)cancellationSupport.execute(ls.getTextDocumentService().completion(param)).thenAccept(completion -> {
                boolean isIncomplete = completion != null && completion.isRight() && ((CompletionList)completion.getRight()).isIncomplete();
                proposals.addAll(LSContentAssistProcessor.toProposals(document, offset, (Either<List<CompletionItem>, CompletionList>)completion, w, cancellationSupport, isIncomplete));
                if (isIncomplete) {
                    anyIncomplete.set(true);
                }
            })).exceptionally(t -> {
                if (!CancellationUtil.isRequestCancelledException(t)) {
                    LanguageServerPlugin.logError("'%s' LS failed to compute completion items.".formatted(languageServerWrapper.serverDefinition.label), t);
                }
                return null;
            })));
            this.completionCancellationSupport = cancellationSupport;
            completionLanguageServersFuture.get();
        }
        catch (ExecutionException e) {
            this.errorMessage = this.createErrorMessage(offset, e);
            return this.createErrorProposal(offset, e);
        }
        catch (InterruptedException e) {
            this.completionCancellationSupport.cancel();
            return NO_COMPLETION_PROPOSALS;
        }
        catch (CancellationException e) {
            // empty catch block
        }
        ArrayList<Object> completeProposals = new ArrayList<Object>();
        for (ICompletionProposal proposal : proposals) {
            void completeProposal;
            if (!(proposal instanceof LSCompletionProposal)) {
                return (ICompletionProposal[])proposals.toArray(ICompletionProposal[]::new);
            }
            LSCompletionProposal lSCompletionProposal = (LSCompletionProposal)proposal;
            completeProposals.add(completeProposal);
        }
        completeProposals.sort(this.proposalComparator);
        ICompletionProposal incompleteProposal = this.createIncompleteProposal(offset, anyIncomplete.get());
        if (incompleteProposal != null && !completeProposals.isEmpty()) {
            ArrayList<Object> incompleteProposals = completeProposals;
            incompleteProposals.add(incompleteProposal);
            return (ICompletionProposal[])incompleteProposals.toArray(ICompletionProposal[]::new);
        }
        return (ICompletionProposal[])completeProposals.toArray(ICompletionProposal[]::new);
    }

    private ICompletionProposal[] createErrorProposal(int offset, Exception ex) {
        if (this.errorAsCompletionItem) {
            return new ICompletionProposal[]{new CompletionProposal("", offset, 0, 0, null, Messages.completionError, null, ex.getMessage())};
        }
        return NO_COMPLETION_PROPOSALS;
    }

    private String createErrorMessage(int offset, Exception ex) {
        return Messages.completionError + " : " + ex.getMessage();
    }

    private @Nullable ICompletionProposal createIncompleteProposal(int offset, boolean incomplete) {
        if (this.incompleteAsCompletionItem && incomplete) {
            return new CompletionProposal("", offset, 0, 0, null, Messages.completionIncomplete, null, Messages.continueIncomplete);
        }
        return null;
    }

    private void initiateLanguageServers(IDocument document) {
        if (this.currentDocument != document) {
            this.currentDocument = document;
            this.triggerCharsCancellationSupport.cancel();
            this.completionTriggerChars = ArrayUtil.NO_CHARS;
            this.contextTriggerChars = ArrayUtil.NO_CHARS;
            this.completionTriggerCharsFuture = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withFilter(capabilities -> capabilities.getCompletionProvider() != null)).collectAll((w, ls) -> {
                List triggerChars = NullSafetyHelper.castNonNull(w.getServerCapabilities()).getCompletionProvider().getTriggerCharacters();
                this.completionTriggerChars = LSContentAssistProcessor.mergeTriggers(this.completionTriggerChars, triggerChars);
                return CompletableFuture.completedFuture(null);
            });
            this.triggerCharsCancellationSupport.execute(this.completionTriggerCharsFuture);
            this.contextInformationTriggerCharsFuture = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withFilter(capabilities -> capabilities.getSignatureHelpProvider() != null)).collectAll((w, ls) -> {
                List triggerChars = NullSafetyHelper.castNonNull(w.getServerCapabilities()).getSignatureHelpProvider().getTriggerCharacters();
                this.contextTriggerChars = LSContentAssistProcessor.mergeTriggers(this.contextTriggerChars, triggerChars);
                return CompletableFuture.completedFuture(null);
            });
            this.contextInformationLanguageServersFuture = this.triggerCharsCancellationSupport.execute(this.contextInformationTriggerCharsFuture);
        }
    }

    private void initiateLanguageServers() {
        IDocument document;
        ITextEditor textEditor = UI.getActiveTextEditor();
        if (textEditor != null && (document = LSPEclipseUtils.getDocument(textEditor)) != null) {
            this.initiateLanguageServers(document);
        }
    }

    private static List<ICompletionProposal> toProposals(IDocument document, int offset, @Nullable Either<List<CompletionItem>, CompletionList> completionList, LanguageServerWrapper languageServerWrapper, CancelChecker cancelChecker, boolean isIncomplete) {
        if (completionList == null) {
            return Collections.emptyList();
        }
        cancelChecker.checkCanceled();
        CompletionItemDefaults defaults = (CompletionItemDefaults)completionList.map(o -> null, CompletionList::getItemDefaults);
        return ((List)completionList.map((Function)Functions.identity(), CompletionList::getItems)).stream().filter(Objects::nonNull).map(item -> new LSCompletionProposal(document, offset, (CompletionItem)item, defaults, languageServerWrapper, isIncomplete)).filter(proposal -> {
            cancelChecker.checkCanceled();
            return proposal.validate(document, offset, null);
        }).map(ICompletionProposal.class::cast).toList();
    }

    public IContextInformation @Nullable [] computeContextInformation(ITextViewer viewer, int offset) {
        SignatureHelpParams param;
        IDocument document = viewer.getDocument();
        if (document == null) {
            return new IContextInformation[0];
        }
        this.initiateLanguageServers(document);
        try {
            param = LSPEclipseUtils.toSignatureHelpParams(offset, document);
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
            return new IContextInformation[0];
        }
        List contextInformations = Collections.synchronizedList(new ArrayList());
        try {
            this.contextInformationLanguageServersFuture = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withFilter(capabilities -> capabilities.getSignatureHelpProvider() != null)).collectAll(ls -> ls.getTextDocumentService().signatureHelp(param).thenAccept(signatureHelp -> {
                if (signatureHelp != null) {
                    signatureHelp.getSignatures().stream().map(LSContentAssistProcessor::toContextInformation).forEach(contextInformations::add);
                }
            }));
            this.contextInformationLanguageServersFuture.get(1000L, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException | ResponseErrorException e) {
            if (!CancellationUtil.isRequestCancelledException(e)) {
                LanguageServerPlugin.logError(e);
            }
            return new IContextInformation[0];
        }
        catch (InterruptedException e) {
            LanguageServerPlugin.logError(e);
            Thread.currentThread().interrupt();
            return new IContextInformation[0];
        }
        catch (TimeoutException e) {
            LanguageServerPlugin.logWarning("Could not compute  context information due to timeout after 1000 milliseconds");
            return new IContextInformation[0];
        }
        return (IContextInformation[])contextInformations.toArray(IContextInformation[]::new);
    }

    private static IContextInformation toContextInformation(SignatureInformation information) {
        StringBuilder signature = new StringBuilder(information.getLabel());
        String docString = LSPEclipseUtils.getDocString((Either<String, MarkupContent>)information.getDocumentation());
        if (docString != null && !docString.isEmpty()) {
            signature.append('\n').append(docString);
        }
        return new ContextInformation(information.getLabel(), signature.toString());
    }

    private void getFuture(@Nullable CompletableFuture<?> future) {
        block5: {
            if (future == null) {
                return;
            }
            try {
                future.get(50L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LanguageServerPlugin.logError(e);
                Thread.currentThread().interrupt();
            }
            catch (TimeoutException e) {
                LanguageServerPlugin.logWarning("Could not get trigger characters due to timeout after 50 milliseconds");
            }
            catch (CancellationException | ExecutionException | OperationCanceledException | ResponseErrorException e) {
                if (CancellationUtil.isRequestCancelledException(e)) break block5;
                LanguageServerPlugin.logError(e);
            }
        }
    }

    private static char[] mergeTriggers(char @Nullable [] initialArray, @Nullable Collection<String> additionalTriggers) {
        if (initialArray == null) {
            initialArray = ArrayUtil.NO_CHARS;
        }
        if (additionalTriggers == null) {
            additionalTriggers = Collections.emptySet();
        }
        HashSet<Character> triggers = new HashSet<Character>(initialArray.length);
        char[] cArray = initialArray;
        int n = initialArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            triggers.add(Character.valueOf(c));
            ++n2;
        }
        additionalTriggers.stream().filter(s -> !Strings.isNullOrEmpty((String)s)).map(triggerChar -> Character.valueOf(triggerChar.charAt(0))).forEach(triggers::add);
        char[] res = new char[triggers.size()];
        int i = 0;
        for (Character c : triggers) {
            res[i] = c.charValue();
            ++i;
        }
        return res;
    }

    public char @Nullable [] getCompletionProposalAutoActivationCharacters() {
        this.initiateLanguageServers();
        this.getFuture(this.completionTriggerCharsFuture);
        return this.completionTriggerChars;
    }

    public char @Nullable [] getContextInformationAutoActivationCharacters() {
        this.initiateLanguageServers();
        this.getFuture(this.contextInformationTriggerCharsFuture);
        return this.contextTriggerChars;
    }

    public @Nullable String getErrorMessage() {
        return this.errorMessage;
    }

    public @Nullable IContextInformationValidator getContextInformationValidator() {
        return new ContextInformationValidator((IContentAssistProcessor)this);
    }
}

