/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.format;

import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerLifecycle;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.VersionedEdits;
import org.eclipse.lsp4e.internal.DocumentUtil;
import org.eclipse.lsp4e.operations.format.LSPFormatter;
import org.eclipse.lsp4j.DocumentOnTypeFormattingOptions;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class LSPonTypeFormattingReconcilingStrategy
implements IReconcilingStrategy,
ITextViewerLifecycle {
    private final IPreferenceStore prefStore = LanguageServerPlugin.getDefault().getPreferenceStore();
    private boolean isOnTypeFormattingEnabled = this.prefStore.getBoolean("onTypeFormattingReconcilingStrategy.enabled");
    private final IPropertyChangeListener formattingPrefsListener = event -> {
        Object newValue = event.getNewValue();
        if (newValue != null && event.getProperty() == "onTypeFormattingReconcilingStrategy.enabled") {
            this.isOnTypeFormattingEnabled = Boolean.parseBoolean(newValue.toString());
        }
    };
    private @Nullable ITextViewer textViewer;
    private @Nullable IDocument document;
    private boolean isUndoOrRedoInProgress = false;
    private final IOperationHistoryListener operationHistoryListener = new IOperationHistoryListener(){

        public void historyNotification(OperationHistoryEvent event) {
            if (event.getEventType() == 10 || event.getEventType() == 9) {
                LSPonTypeFormattingReconcilingStrategy.this.isUndoOrRedoInProgress = true;
            }
        }
    };
    private final ITextListener textListener = new ITextListener(){
        private @Nullable DocumentEvent documentEvent;
        private volatile boolean isListening = true;
        private UIJob job = new UIJob("format on type"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    if ((this).LSPonTypeFormattingReconcilingStrategy.this.textViewer != null) {
                        StyledText widget = (this).LSPonTypeFormattingReconcilingStrategy.this.textViewer.getTextWidget();
                        if (widget == null || widget.isDisposed()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        if (!(this).LSPonTypeFormattingReconcilingStrategy.this.isUndoOrRedoInProgress) {
                            isListening = false;
                            LSPonTypeFormattingReconcilingStrategy.this.doFormatOnType((this).LSPonTypeFormattingReconcilingStrategy.this.textViewer, (this).LSPonTypeFormattingReconcilingStrategy.this.document, documentEvent);
                        }
                    }
                }
                finally {
                    isListening = true;
                }
                return Status.OK_STATUS;
            }
        };

        public void textChanged(@Nullable TextEvent event) {
            if (LSPonTypeFormattingReconcilingStrategy.this.isOnTypeFormattingEnabled && this.isListening && event != null) {
                DocumentEvent docEvent = event.getDocumentEvent();
                if (!event.getViewerRedrawState() || docEvent == null || docEvent.getText().isEmpty()) {
                    return;
                }
                LSPonTypeFormattingReconcilingStrategy.this.isUndoOrRedoInProgress = false;
                this.job.cancel();
                this.documentEvent = docEvent;
                this.job.schedule(50L);
            }
        }
    };

    public void install(@Nullable ITextViewer textViewer) {
        if (textViewer == null) {
            return;
        }
        this.textViewer = textViewer;
        this.textViewer.addTextListener(this.textListener);
        IOperationHistory history = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
        history.addOperationHistoryListener(this.operationHistoryListener);
        this.prefStore.addPropertyChangeListener(this.formattingPrefsListener);
    }

    public void uninstall() {
        IOperationHistory history = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
        history.removeOperationHistoryListener(this.operationHistoryListener);
        this.prefStore.removePropertyChangeListener(this.formattingPrefsListener);
        if (this.textViewer != null) {
            this.textViewer.removeTextListener(this.textListener);
        }
        this.textViewer = null;
    }

    public void setDocument(@Nullable IDocument document) {
        this.document = document;
    }

    public void reconcile(@Nullable DirtyRegion dirtyRegion, @Nullable IRegion subRegion) {
    }

    public void reconcile(@Nullable IRegion partition) {
    }

    void doFormatOnType(@Nullable ITextViewer viewer, @Nullable IDocument document, @Nullable DocumentEvent event) {
        if (document == null || event == null || event.fText.isEmpty() || viewer == null) {
            return;
        }
        String[] triggerCharArr = new String[]{""};
        LanguageServers.LanguageServerDocumentExecutor executor = (LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withCapability(capabilities -> {
            DocumentOnTypeFormattingOptions provider = capabilities.getDocumentOnTypeFormattingProvider();
            if (provider != null) {
                String firstTriggerChar = provider.getFirstTriggerCharacter();
                String spaceRemovalRegex = "[\\s&&[^" + Pattern.quote(firstTriggerChar) + "]]+";
                String filteredText = documentEvent.fText.replaceAll(spaceRemovalRegex, "");
                if (filteredText.equals(firstTriggerChar)) {
                    stringArray[0] = firstTriggerChar;
                } else if (provider.getMoreTriggerCharacter() != null) {
                    for (String c : provider.getMoreTriggerCharacter()) {
                        if (!documentEvent.fText.equals(c)) continue;
                        stringArray[0] = c;
                        break;
                    }
                }
            }
            return Either.forLeft((Object)(provider != null && !triggerCharArr[0].isEmpty() ? 1 : 0));
        });
        if (!executor.anyMatching()) {
            return;
        }
        FormattingOptions formattingOptions = LSPFormatter.getFormatOptions();
        TextDocumentIdentifier textDocumentIdentifier = LSPEclipseUtils.toTextDocumentIdentifier(document);
        if (textDocumentIdentifier == null) {
            return;
        }
        try {
            long modificationStamp = DocumentUtil.getDocumentModificationStamp(document);
            int position = event.fOffset + event.fText.length();
            DocumentOnTypeFormattingParams params = new DocumentOnTypeFormattingParams(textDocumentIdentifier, formattingOptions, LSPEclipseUtils.toPosition(position, document), triggerCharArr[0]);
            Optional edits = executor.computeFirst(ls -> ls.getTextDocumentService().onTypeFormatting(params)).get(1L, TimeUnit.SECONDS);
            if (!edits.isEmpty()) {
                int caretOffset = new VersionedEdits(modificationStamp, (List)edits.get(), document).apply(position);
                viewer.setSelectedRange(caretOffset, 0);
                viewer.revealRange(caretOffset, 0);
            }
        }
        catch (InterruptedException | ConcurrentModificationException | ExecutionException | TimeoutException | BadLocationException e) {
            LanguageServerPlugin.logError(e);
        }
    }
}

