/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.extensions;

import java.util.Collections;
import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.MockXMLLanguageServer;
import org.eclipse.lemminx.XMLLanguageServer;
import org.eclipse.lemminx.services.extensions.IWorkspaceServiceParticipant;
import org.eclipse.lsp4j.DidChangeWorkspaceFoldersParams;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.WorkspaceFoldersChangeEvent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class WorkspaceServiceParticipantTest
extends AbstractCacheBasedTest {
    private CaptureWokspaceServiceCalls workspaceServiceParticipant;
    private XMLLanguageServer server;

    @BeforeEach
    public void initializeLanguageService() {
        this.server = new MockXMLLanguageServer();
        this.workspaceServiceParticipant = new CaptureWokspaceServiceCalls();
        this.server.getXMLLanguageService().registerWorkspaceServiceParticipant((IWorkspaceServiceParticipant)this.workspaceServiceParticipant);
    }

    @Test
    public void testWorkspaceFolders() {
        DidChangeWorkspaceFoldersParams params = new DidChangeWorkspaceFoldersParams(new WorkspaceFoldersChangeEvent(Collections.singletonList(new WorkspaceFolder("added", "added")), Collections.singletonList(new WorkspaceFolder("removed", "removed"))));
        this.server.getWorkspaceService().didChangeWorkspaceFolders(params);
        Assertions.assertArrayEquals((Object[])new String[]{"added"}, (Object[])this.workspaceServiceParticipant.didChangeWorkspaceFolders.getEvent().getAdded().stream().map(WorkspaceFolder::getUri).toArray(String[]::new));
        Assertions.assertArrayEquals((Object[])new String[]{"removed"}, (Object[])this.workspaceServiceParticipant.didChangeWorkspaceFolders.getEvent().getRemoved().stream().map(WorkspaceFolder::getUri).toArray(String[]::new));
    }

    private static class CaptureWokspaceServiceCalls
    implements IWorkspaceServiceParticipant {
        public DidChangeWorkspaceFoldersParams didChangeWorkspaceFolders;

        private CaptureWokspaceServiceCalls() {
        }

        public void didChangeWorkspaceFolders(DidChangeWorkspaceFoldersParams params) {
            this.didChangeWorkspaceFolders = params;
        }
    }
}

