/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.beans.PropertyDescriptor;
import java.util.Set;
import org.eclipse.core.databinding.beans.IBeanMapProperty;
import org.eclipse.core.databinding.beans.IBeanSetProperty;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.set.ISetProperty;
import org.eclipse.core.databinding.property.set.SetProperty;
import org.eclipse.core.internal.databinding.beans.BeanMapPropertyDecorator;
import org.eclipse.core.internal.databinding.beans.BeanObservableSetDecorator;

public class BeanSetPropertyDecorator<S, E>
extends SetProperty<S, E>
implements IBeanSetProperty<S, E> {
    private final ISetProperty<S, E> delegate;
    private final PropertyDescriptor propertyDescriptor;

    public BeanSetPropertyDecorator(ISetProperty<S, E> delegate, PropertyDescriptor propertyDescriptor) {
        this.delegate = delegate;
        this.propertyDescriptor = propertyDescriptor;
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    public Object getElementType() {
        return this.delegate.getElementType();
    }

    protected Set<E> doGetSet(S source) {
        return this.delegate.getSet(source);
    }

    protected void doSetSet(S source, Set<E> set) {
        this.delegate.setSet(source, set);
    }

    protected void doUpdateSet(S source, SetDiff<E> diff) {
        this.delegate.updateSet(source, diff);
    }

    @Override
    public IBeanMapProperty<S, E, Object> values(String propertyName) {
        return this.values(propertyName, null);
    }

    @Override
    public <V> IBeanMapProperty<S, E, V> values(String propertyName, Class<V> valueType) {
        Class beanClass = (Class)this.delegate.getElementType();
        return this.values(BeanProperties.value(beanClass, propertyName, valueType));
    }

    @Override
    public <V> IBeanMapProperty<S, E, V> values(IBeanValueProperty<? super E, V> property) {
        return new BeanMapPropertyDecorator(super.values(property), property.getPropertyDescriptor());
    }

    public IObservableSet<E> observe(S source) {
        return new BeanObservableSetDecorator(this.delegate.observe(source), this.propertyDescriptor);
    }

    public IObservableSet<E> observe(Realm realm, S source) {
        return new BeanObservableSetDecorator(this.delegate.observe(realm, source), this.propertyDescriptor);
    }

    public <U extends S> IObservableSet<E> observeDetail(IObservableValue<U> master) {
        return new BeanObservableSetDecorator(this.delegate.observeDetail(master), this.propertyDescriptor);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

