/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.modelio.exml.model;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.hawk.core.model.IHawkAttribute;
import org.eclipse.hawk.core.model.IHawkReference;
import org.eclipse.hawk.core.model.IHawkStructuralFeature;
import org.eclipse.hawk.modelio.exml.metamodel.AbstractModelioObject;
import org.eclipse.hawk.modelio.exml.metamodel.ModelioAttribute;
import org.eclipse.hawk.modelio.exml.metamodel.ModelioClass;
import org.eclipse.hawk.modelio.exml.metamodel.ModelioDataType;
import org.eclipse.hawk.modelio.exml.metamodel.ModelioReference;
import org.eclipse.hawk.modelio.exml.metamodel.register.MetamodelRegister;
import org.eclipse.hawk.modelio.exml.model.ModelioProxy;
import org.eclipse.hawk.modelio.exml.model.parser.ExmlObject;
import org.eclipse.hawk.modelio.exml.model.parser.ExmlReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelioObject
extends AbstractModelioObject {
    public static final String COMMON_EXML = "modelio-objects.exml";
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelioObject.class);
    private final ModelioClass mc;
    private final ExmlObject exml;
    private Map<String, String> mmPackageVersions;

    public ModelioObject(ModelioClass mc, ExmlObject exml, Map<String, String> mmPackageVersions) {
        assert (mc != null);
        assert (exml != null);
        this.mc = mc;
        this.exml = exml;
        this.mmPackageVersions = mmPackageVersions;
    }

    public boolean isRoot() {
        return this.exml.getParentUID() == null;
    }

    public String getUri() {
        return String.valueOf(this.exml.getFile().toURI().toString()) + "#" + this.getUriFragment();
    }

    public String getUriFragment() {
        return this.exml.getUID();
    }

    public boolean isFragmentUnique() {
        return true;
    }

    public ModelioClass getType() {
        return this.mc;
    }

    public ModelioClass getRootType() {
        LinkedList<ModelioClass> typeQueue = new LinkedList<ModelioClass>();
        typeQueue.add(this.getType());
        while (!typeQueue.isEmpty()) {
            ModelioClass current = (ModelioClass)typeQueue.removeFirst();
            if (current.getSuperTypes().isEmpty()) {
                return current;
            }
            for (ModelioClass st : current.getSuperTypes()) {
                typeQueue.addLast(st);
            }
        }
        return null;
    }

    public boolean isSet(IHawkStructuralFeature hsf) {
        if (hsf instanceof ModelioAttribute) {
            return this.exml.getAttributes().containsKey(hsf.getName());
        }
        if (hsf instanceof ModelioReference) {
            if (hsf.getName().equals("hawkParent") && this.exml.getParentUID() != null) {
                return true;
            }
            if (this.exml.getLinks().containsKey(hsf.getName()) || this.exml.getCompositions().containsKey(hsf.getName())) {
                return hsf.isMany() ? true : this.get((ModelioReference)hsf, false) != null;
            }
        }
        return false;
    }

    public Object get(IHawkAttribute attr) {
        String rawValue;
        block28: {
            rawValue = this.exml.getAttribute(attr.getName());
            if (rawValue == null) break block28;
            ModelioDataType mdt = (ModelioDataType)attr.getType();
            switch (mdt.getInstanceType()) {
                case "Short": {
                    return Short.valueOf(rawValue);
                }
                case "Long": {
                    return Long.valueOf(rawValue);
                }
                case "Integer": {
                    return Integer.valueOf(rawValue);
                }
                case "Float": {
                    return Float.valueOf(rawValue);
                }
                case "Double": {
                    return Double.valueOf(rawValue);
                }
                case "Character": {
                    return Character.valueOf(rawValue.charAt(0));
                }
                case "Byte": {
                    return Byte.valueOf(rawValue);
                }
                case "Boolean": {
                    return Boolean.valueOf(rawValue);
                }
            }
            return rawValue;
        }
        return rawValue;
    }

    public Object get(IHawkReference ref, boolean b) {
        ArrayList<AbstractModelioObject> linked = new ArrayList<AbstractModelioObject>();
        if (ref.getName().equals("hawkParent") && this.exml.getParentUID() != null) {
            ExmlReference parentRef = new ExmlReference(this.exml.getFile());
            parentRef.setName("hawkParent");
            parentRef.setMClassName(this.getRootType().getName());
            parentRef.setUID(this.exml.getParentUID());
            return new ModelioProxy((ModelioClass)ref.getType(), parentRef);
        }
        List<ExmlReference> links = this.exml.getLinks().get(ref.getName());
        if (links != null) {
            for (ExmlReference r : links) {
                ModelioClass rMC = MetamodelRegister.INSTANCE.getModelioClass(r.getMClassName(), this.mmPackageVersions);
                if (rMC == null) {
                    LOGGER.warn("Could not find class with name '{}', ignoring instance", (Object)r.getMClassName());
                    continue;
                }
                linked.add(new ModelioProxy(rMC, r));
            }
        } else {
            List<ExmlReference> cmp = this.exml.getCompositions().get(ref.getName());
            if (cmp != null) {
                for (ExmlReference r : cmp) {
                    ModelioClass rMC = MetamodelRegister.INSTANCE.getModelioClass(r.getMClassName(), this.mmPackageVersions);
                    if (rMC == null) {
                        LOGGER.warn("Could not find class with name '{}', ignoring instance", (Object)r.getMClassName());
                        continue;
                    }
                    if (r instanceof ExmlObject) {
                        linked.add(new ModelioObject(rMC, (ExmlObject)r, this.mmPackageVersions));
                        continue;
                    }
                    linked.add(new ModelioProxy(rMC, r));
                }
            }
        }
        if (ref.isMany()) {
            return linked;
        }
        if (!linked.isEmpty()) {
            return linked.get(0);
        }
        return null;
    }

    @Override
    public String getExml() {
        return this.exml.getFile().getPath();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.exml == null ? 0 : this.exml.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModelioObject other = (ModelioObject)obj;
        return !(this.exml == null ? other.exml != null : !this.exml.equals(other.exml));
    }

    public String toString() {
        return "ModelioObject [mc=" + this.mc.getName() + ", exml=" + this.getExml() + ", uid=" + this.exml.getUID() + ", pid=" + this.exml.getParentUID() + "]";
    }
}

