/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.git;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.eclipse.hawk.core.ICredentialsStore;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.IVcsManager;
import org.eclipse.hawk.core.VcsChangeType;
import org.eclipse.hawk.core.VcsCommit;
import org.eclipse.hawk.core.VcsCommitItem;
import org.eclipse.hawk.core.VcsRepositoryDelta;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.RevisionSyntaxException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.io.NullOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGitRepository
implements IVcsManager {
    public static final String BRANCH_QPARAM = "branch";
    private static final Logger LOG = LoggerFactory.getLogger(JGitRepository.class);
    private String branch;
    private Repository repository;
    private String firstRevision;
    private Path rootLocation;
    private boolean active;
    private boolean isFrozen;

    public String getCurrentRevision() throws Exception {
        try {
            ObjectId oid = this.repository.resolve(this.branch);
            return ObjectId.toString((ObjectId)oid);
        }
        catch (AmbiguousObjectException | IncorrectObjectTypeException | RevisionSyntaxException e) {
            throw new IllegalStateException("Unexpected exception", e);
        }
        catch (IOException e) {
            throw new UnableToFindRevisionException("Unable to resolve the tip of branch " + this.branch, e);
        }
    }

    public synchronized String getFirstRevision() throws Exception {
        if (this.firstRevision == null) {
            this.repository.scanForRepoChanges();
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (RevWalk walk = new RevWalk(this.repository);){
                    walk.markStart(walk.parseCommit((AnyObjectId)this.repository.resolve(this.branch)));
                    walk.sort(RevSort.COMMIT_TIME_DESC, true);
                    walk.sort(RevSort.REVERSE, true);
                    RevCommit commit = walk.next();
                    this.firstRevision = ObjectId.toString((ObjectId)commit.getId());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new UnableToFindRevisionException("Unable to resolve the first revision", e);
            }
        }
        return this.firstRevision;
    }

    public List<VcsCommitItem> getDelta(String startRevision) throws Exception {
        if (startRevision != null && startRevision.startsWith("-")) {
            startRevision = null;
        }
        return this.getDelta(startRevision, this.getCurrentRevision()).getCompactedCommitItems();
    }

    public VcsRepositoryDelta getDelta(String startRevision, String endRevision) throws Exception {
        if (startRevision != null) {
            if (startRevision.startsWith("-")) {
                startRevision = null;
            } else {
                this.checkRangeAncestry(startRevision, endRevision);
            }
        }
        ArrayList<VcsCommit> deltaCommits = new ArrayList<VcsCommit>();
        VcsRepositoryDelta delta = new VcsRepositoryDelta(deltaCommits);
        delta.setManager((IVcsManager)this);
        Throwable throwable = null;
        Object var6_7 = null;
        try (Git git = Git.open((File)this.rootLocation.toFile());){
            Iterable revs = startRevision == null ? git.log().add((AnyObjectId)ObjectId.fromString((String)endRevision)).call() : git.log().addRange((AnyObjectId)ObjectId.fromString((String)startRevision), (AnyObjectId)ObjectId.fromString((String)endRevision)).call();
            ArrayList commits = new ArrayList();
            RevCommit previous = null;
            for (RevCommit rev : revs) {
                if (previous == null && rev.getParentCount() > 0) {
                    previous = rev.getParent(0);
                }
                this.diff(rev, previous).stream().findFirst().ifPresent(c -> {
                    boolean bl = commits.add(c.getCommit());
                });
                previous = rev;
            }
            ListIterator itCommit = commits.listIterator(commits.size());
            while (itCommit.hasPrevious()) {
                VcsCommit commit = (VcsCommit)itCommit.previous();
                deltaCommits.add(commit);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return delta;
    }

    private void checkRangeAncestry(String startRevision, String endRevision) throws UnmergedAncestryException, UnableToFindRevisionException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (RevWalk walk = new RevWalk(this.repository);){
                RevCommit startCommit = walk.parseCommit((AnyObjectId)this.repository.resolve(startRevision));
                RevCommit endCommit = walk.parseCommit((AnyObjectId)this.repository.resolve(endRevision));
                if (!walk.isMergedInto(startCommit, endCommit)) {
                    throw new UnmergedAncestryException(String.format("Revision %s (end) is in a branch not merged into the branch that contains revision %s (start).", endRevision, startRevision));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UnableToFindRevisionException("Unable to resolve the delta of revision", e);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File importFile(String revision, String path, File optionalTemp) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        try {
            var4_4 = null;
            var5_7 = null;
            try {
                block37: {
                    revWalk = new RevWalk(this.repository);
                    try {
                        var7_10 = null;
                        var8_13 = null;
                        try {
                            block38: {
                                treeWalk = TreeWalk.forPath((Repository)this.repository, (String)path, (RevTree)revWalk.parseCommit((AnyObjectId)ObjectId.fromString((String)revision)).getTree());
                                if (treeWalk != null) break block37;
                                JGitRepository.LOG.warn("Could not find path '{}' on revision {} of the Git repository at '{}'", new Object[]{path, revision, this.rootLocation});
                                if (treeWalk == null) break block38;
                                treeWalk.close();
                            }
                            if (revWalk == null) return null;
                        }
                        catch (Throwable var8_14) {
                            if (var7_10 == null) {
                                var7_10 = var8_14;
                                throw var7_10;
                            }
                            if (var7_10 == var8_14) throw var7_10;
                            var7_10.addSuppressed(var8_14);
                            throw var7_10;
                        }
                    }
                    catch (Exception e) {
                        JGitRepository.LOG.error("There was an error traversing the Git tree to retrieve the file contents.", (Throwable)e);
                        return optionalTemp;
                    }
                    catch (Throwable var4_5) {
                        throw var4_5;
                    }
                    revWalk.close();
                    return null;
                }
                ** try [egrp 8[TRYBLOCK] [6 : 120->315)] { 
lbl41:
                // 1 sources

                blobId = treeWalk.getObjectId(0);
                var11_17 = null;
                var12_19 = null;
                try {
                    objectReader = this.repository.newObjectReader();
                    try {
                        objectLoader = objectReader.open((AnyObjectId)blobId);
                        bytes = objectLoader.getBytes();
                        try {
                            var16_24 = null;
                            var17_27 = null;
                            try {
                                fOS = new FileOutputStream(optionalTemp);
                                try {
                                    fOS.write(bytes);
                                    return optionalTemp;
                                }
                                finally {
                                    if (fOS != null) {
                                        fOS.close();
                                    }
                                }
                            }
                            catch (Throwable var17_28) {
                                if (var16_24 == null) {
                                    var16_24 = var17_28;
                                    throw var16_24;
                                }
                                if (var16_24 == var17_28) throw var16_24;
                                var16_24.addSuppressed(var17_28);
                                throw var16_24;
                            }
                        }
                        catch (Exception e) {
                            JGitRepository.LOG.error("There was an error writing the contents of the file in the repository into the provided file.", (Throwable)e);
                            return optionalTemp;
                        }
                    }
                    finally {
                        if (objectReader != null) {
                            objectReader.close();
                        }
                    }
                }
                catch (Throwable var12_20) {
                    if (var11_17 == null) {
                        var11_17 = var12_20;
                        throw var11_17;
                    }
                    if (var11_17 == var12_20) throw var11_17;
                    var11_17.addSuppressed(var12_20);
                    throw var11_17;
                }
lbl82:
                // 1 sources

                finally {
                    if (treeWalk != null) {
                        treeWalk.close();
                    }
                }
            }
            catch (Throwable var5_8) {
                if (var4_4 == null) {
                    var4_4 = var5_8;
                    throw var4_4;
                }
                if (var4_4 == var5_8) throw var4_4;
                var4_4.addSuppressed(var5_8);
                throw var4_4;
            }
        }
        catch (Exception e) {
            JGitRepository.LOG.error("There was an error accessing the Git repository to retrieve the file contents.", (Throwable)e);
        }
        return optionalTemp;
    }

    public boolean isActive() {
        return this.active;
    }

    public void init(String vcsloc, IModelIndexer indexer) throws Exception {
        File canonicalFile;
        Path path;
        try {
            URI uri = new URI(vcsloc);
            path = Paths.get(uri.resolve("."));
            List pairs = URLEncodedUtils.parse((URI)uri, (Charset)Charset.forName("UTF-8"));
            for (NameValuePair pair : pairs) {
                if (!BRANCH_QPARAM.equals(pair.getName())) continue;
                this.branch = pair.getValue();
            }
        }
        catch (IllegalArgumentException | URISyntaxException ex) {
            path = Paths.get(vcsloc, new String[0]);
        }
        try {
            canonicalFile = path.toFile().getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Unable to access '%s' as a local folder", vcsloc));
        }
        if (!canonicalFile.isDirectory()) {
            throw new IllegalArgumentException(String.format("The location pointed to by %s is not a folder", vcsloc));
        }
        this.rootLocation = canonicalFile.toPath();
        FileRepositoryBuilder builder = (FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().addCeilingDirectory(canonicalFile.getParentFile())).findGitDir(canonicalFile);
        if (builder.getGitDir() == null) {
            throw new IllegalArgumentException(String.format("The location pointed to by %s doesn't appear to be a valid Git repository (.git folder not found or invalid).", vcsloc));
        }
        this.repository = ((FileRepositoryBuilder)builder.setMustExist(true)).build();
        if (this.branch == null) {
            this.branch = this.repository.getFullBranch();
        }
    }

    public void run() {
        this.active = true;
    }

    public void shutdown() {
        this.rootLocation = null;
        this.repository.close();
        this.active = false;
    }

    public String getLocation() {
        return this.rootLocation.toString();
    }

    public String getBranch() {
        return this.branch;
    }

    public boolean isAuthSupported() {
        return false;
    }

    public String getUsername() {
        throw new UnsupportedOperationException("Git repository does not support authentication.");
    }

    public String getPassword() {
        throw new UnsupportedOperationException("Git repository does not support authentication.");
    }

    public void setCredentials(String username, String password, ICredentialsStore credStore) {
        throw new UnsupportedOperationException("Git repository does not support authentication.");
    }

    public String getHumanReadableName() {
        return "Git Repository (JGit-based)";
    }

    public boolean isPathLocationAccepted() {
        return true;
    }

    public boolean isURLLocationAccepted() {
        return true;
    }

    public String getRepositoryPath(String rawPath) {
        return this.rootLocation.relativize(Paths.get(rawPath, new String[0])).toString();
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    public void setFrozen(boolean f) {
        this.isFrozen = f;
    }

    private Collection<VcsCommitItem> diff(RevCommit current, RevCommit previous) throws IOException {
        ArrayList<VcsCommitItem> result = new ArrayList<VcsCommitItem>();
        Throwable throwable = null;
        Object var5_6 = null;
        try (DiffFormatter diffFmt = new DiffFormatter((OutputStream)NullOutputStream.INSTANCE);){
            diffFmt.setRepository(this.repository);
            VcsCommit commit = this.asVcsCommit(current);
            for (DiffEntry diff : diffFmt.scan(previous == null ? null : previous.getTree(), current.getTree())) {
                VcsCommitItem item = new VcsCommitItem();
                switch (diff.getChangeType()) {
                    case ADD: {
                        item.setChangeType(VcsChangeType.ADDED);
                        item.setPath("/" + diff.getNewPath());
                        break;
                    }
                    case DELETE: {
                        item.setChangeType(VcsChangeType.DELETED);
                        item.setPath("/" + diff.getOldPath());
                        break;
                    }
                    case MODIFY: {
                        item.setChangeType(VcsChangeType.UPDATED);
                        item.setPath("/" + diff.getNewPath());
                        break;
                    }
                    case RENAME: {
                        item.setChangeType(VcsChangeType.REPLACED);
                        item.setPath("/" + diff.getNewPath());
                        break;
                    }
                    case COPY: {
                        item.setChangeType(VcsChangeType.UNKNOWN);
                    }
                }
                item.setCommit(commit);
                commit.getItems().add(item);
                result.add(item);
            }
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private VcsCommit asVcsCommit(RevCommit current) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        PersonIdent authorIdent = current.getAuthorIdent();
        Date commitDate = authorIdent.getWhen();
        if (current.getParentCount() > 0) {
            Throwable throwable = null;
            Object var5_6 = null;
            try (RevWalk walk = new RevWalk(this.repository);){
                walk.markStart(walk.parseCommit((AnyObjectId)current.getId()));
                int nCommitsSameTimestamp = 0;
                for (RevCommit ancestor : walk) {
                    if (!ancestor.getAuthorIdent().getWhen().equals(commitDate)) break;
                    ++nCommitsSameTimestamp;
                }
                if (nCommitsSameTimestamp > 0) {
                    Instant newInstant = commitDate.toInstant().plus(Duration.ofMillis(nCommitsSameTimestamp));
                    commitDate = Date.from(newInstant);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        VcsCommit commit = new VcsCommit();
        commit.setAuthor(authorIdent.getName());
        commit.setJavaDate(commitDate);
        commit.setMessage(current.getFullMessage());
        commit.setRevision(current.getName());
        return commit;
    }

    public String getDefaultLocation() {
        return "file://path/to/gitrepo?branch=BRANCH";
    }

    public class UnableToFindRevisionException
    extends Exception {
        private static final long serialVersionUID = -7277359120689923918L;

        public UnableToFindRevisionException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public class UnmergedAncestryException
    extends Exception {
        private static final long serialVersionUID = -1805916162822065083L;

        public UnmergedAncestryException(String message) {
            super(message);
        }
    }
}

