/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.launchview.internal.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.debug.ui.launchview.internal.LaunchViewMessages;
import org.eclipse.debug.ui.launchview.internal.model.LaunchObjectContainerModel;
import org.eclipse.debug.ui.launchview.internal.model.LaunchObjectFavoriteContainerModel;
import org.eclipse.debug.ui.launchview.internal.model.LaunchObjectModel;
import org.eclipse.debug.ui.launchview.internal.model.LaunchViewModel;
import org.eclipse.debug.ui.launchview.internal.view.EditAction;
import org.eclipse.debug.ui.launchview.internal.view.LaunchAction;
import org.eclipse.debug.ui.launchview.internal.view.LaunchViewContentProvider;
import org.eclipse.debug.ui.launchview.internal.view.LaunchViewLabelProvider;
import org.eclipse.debug.ui.launchview.internal.view.RelaunchAction;
import org.eclipse.debug.ui.launchview.internal.view.TerminateAction;
import org.eclipse.debug.ui.launchview.services.ILaunchObject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class LaunchViewImpl
implements Supplier<Set<ILaunchObject>> {
    private static final String CONTEXT_MENU_ID = "LaunchViewContextMenu";
    private LaunchViewModel model;
    private final Runnable reset = () -> this.queueReset();
    private final Job resetJob = new Job(LaunchViewMessages.LaunchView_Reset){

        protected IStatus run(IProgressMonitor monitor) {
            LaunchViewImpl.this.reset();
            return Status.OK_STATUS;
        }
    };
    private FilteredTree tree;
    @Inject
    EMenuService menuService;

    public LaunchViewImpl() {
        this.resetJob.setSystem(true);
    }

    @PostConstruct
    public void createView(Composite parent, MPart part) {
        this.model = LaunchViewModel.getService();
        this.model.addUpdateListener(this.reset);
        this.tree = new FilteredTree(parent, 2050, new PatternFilter(){

            public void setPattern(String pattern) {
                if (pattern != null && !pattern.isEmpty() && pattern.indexOf("*") != 0 && pattern.indexOf("?") != 0 && pattern.indexOf(".") != 0) {
                    super.setPattern("*" + pattern);
                } else {
                    super.setPattern(pattern);
                }
            }

            protected boolean isLeafMatch(Viewer viewer, Object element) {
                if (!(element instanceof LaunchObjectModel) || element instanceof LaunchObjectContainerModel) {
                    return false;
                }
                String txt = ((LaunchObjectModel)element).getLabel().toString();
                return this.wordMatches(txt);
            }
        }, true, true);
        this.tree.getViewer().setContentProvider((IContentProvider)new LaunchViewContentProvider());
        this.tree.getViewer().setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new LaunchViewLabelProvider()));
        this.tree.getViewer().getTree().setLayout((Layout)new GridLayout());
        this.tree.getViewer().getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.createMenus(part);
        this.tree.getViewer().addDoubleClickListener(e -> {
            ITreeSelection selection = this.tree.getViewer().getStructuredSelection();
            if (selection.isEmpty()) {
                return;
            }
            for (Object selected : selection.toList()) {
                if (!(selected instanceof LaunchObjectContainerModel)) continue;
                this.tree.getViewer().setExpandedState(selected, !this.tree.getViewer().getExpandedState(selected));
                return;
            }
            new LaunchAction(DebugPlugin.getDefault().getLaunchManager().getLaunchMode("run"), this).run();
        });
        this.tree.getViewer().setComparator(new ViewerComparator(String.CASE_INSENSITIVE_ORDER));
        this.reset();
    }

    @Focus
    public void onFocus() {
        this.tree.getViewer().getControl().setFocus();
    }

    private void createMenus(MPart part) {
        part.getMenus().clear();
        MMenu viewMenu = MMenuFactory.INSTANCE.createMenu();
        viewMenu.setElementId("menu:" + part.getElementId());
        viewMenu.getTags().add("ViewMenu");
        MDirectMenuItem refresh = MMenuFactory.INSTANCE.createDirectMenuItem();
        refresh.setLabel(LaunchViewMessages.LaunchView_Refresh);
        refresh.setIconURI("platform:/plugin/org.eclipse.debug.ui.launchview/icons/refresh.png");
        refresh.setObject((Object)new RefreshHandler());
        MDirectMenuItem terminateAll = MMenuFactory.INSTANCE.createDirectMenuItem();
        terminateAll.setLabel(LaunchViewMessages.LaunchView_TerminateAll);
        terminateAll.setIconURI("platform:/plugin/org.eclipse.debug.ui.launchview/icons/terminate_all_co.png");
        terminateAll.setObject((Object)new TerminateAllHandler());
        viewMenu.getChildren().add(refresh);
        viewMenu.getChildren().add(MMenuFactory.INSTANCE.createMenuSeparator());
        viewMenu.getChildren().add(terminateAll);
        this.model.getProviders().forEach(p -> p.contributeViewMenu(this, viewMenu));
        part.getMenus().add(viewMenu);
        MPopupMenu ctxMenu = MMenuFactory.INSTANCE.createPopupMenu();
        ctxMenu.setElementId(CONTEXT_MENU_ID);
        for (ILaunchMode mode : this.getPreSortedLaunchModes()) {
            ctxMenu.getChildren().add(new LaunchAction(mode, this).asMMenuItem());
        }
        ctxMenu.getChildren().add(MMenuFactory.INSTANCE.createMenuSeparator());
        ctxMenu.getChildren().add(new RelaunchAction(this).asMMenuItem());
        ctxMenu.getChildren().add(new TerminateAction(this).asMMenuItem());
        ctxMenu.getChildren().add(MMenuFactory.INSTANCE.createMenuSeparator());
        ctxMenu.getChildren().add(new EditAction(this).asMMenuItem());
        this.model.getProviders().forEach(p -> p.contributeContextMenu(this, (MMenu)ctxMenu));
        part.getMenus().add(ctxMenu);
        this.menuService.registerContextMenu((Object)this.tree.getViewer().getControl(), CONTEXT_MENU_ID);
    }

    private List<ILaunchMode> getPreSortedLaunchModes() {
        ArrayList<ILaunchMode> modes = new ArrayList<ILaunchMode>();
        ILaunchMode run = null;
        ILaunchMode debug = null;
        ILaunchMode profile = null;
        ILaunchMode coverage = null;
        ILaunchMode[] launchModes = DebugPlugin.getDefault().getLaunchManager().getLaunchModes();
        ArrayList<ILaunchMode> others = new ArrayList<ILaunchMode>();
        ILaunchMode[] iLaunchModeArray = launchModes;
        int n = launchModes.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchMode m = iLaunchModeArray[n2];
            switch (m.getIdentifier()) {
                case "run": {
                    run = m;
                    break;
                }
                case "debug": {
                    debug = m;
                    break;
                }
                case "profile": {
                    profile = m;
                    break;
                }
                case "coverage": {
                    coverage = m;
                    break;
                }
                default: {
                    others.add(m);
                }
            }
            ++n2;
        }
        if (run != null) {
            modes.add(run);
        }
        if (debug != null) {
            modes.add(debug);
        }
        if (coverage != null) {
            modes.add(coverage);
        }
        if (profile != null) {
            modes.add(profile);
        }
        modes.addAll(others);
        return modes;
    }

    private void queueReset() {
        this.resetJob.cancel();
        this.resetJob.schedule(100L);
    }

    @Override
    public Set<ILaunchObject> get() {
        ISelection selection = this.tree.getViewer().getSelection();
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        if (structuredSelection.isEmpty()) {
            return Collections.emptySet();
        }
        TreeSet<LaunchObjectModel> elements = new TreeSet<LaunchObjectModel>();
        for (Object selected : structuredSelection.toList()) {
            if (selected instanceof LaunchObjectContainerModel || !(selected instanceof LaunchObjectModel)) continue;
            elements.add((LaunchObjectModel)selected);
        }
        return elements.stream().map(m -> m.getObject()).filter(Objects::nonNull).collect(Collectors.toCollection(TreeSet::new));
    }

    private synchronized void reset() {
        this.tree.getDisplay().syncExec(() -> {
            this.tree.getViewer().getTree().setRedraw(false);
            try {
                TreePath[] exp = this.tree.getViewer().getExpandedTreePaths();
                this.tree.getViewer().setInput((Object)this.model.getModel());
                this.tree.getViewer().setExpandedTreePaths(exp);
            }
            finally {
                this.tree.getViewer().getTree().setRedraw(true);
            }
        });
    }

    @PreDestroy
    public void destroy() {
        this.model.removeUpdateListener(this.reset);
    }

    private final class RefreshHandler {
        private RefreshHandler() {
        }

        @Execute
        public void handle() {
            LaunchViewImpl.this.reset();
        }
    }

    private final class TerminateAllHandler {
        private TerminateAllHandler() {
        }

        @Execute
        public void handle() {
            LaunchObjectContainerModel root = (LaunchObjectContainerModel)LaunchViewImpl.this.tree.getViewer().getInput();
            if (root == null) {
                return;
            }
            for (LaunchObjectModel container : root.getChildren()) {
                if (container instanceof LaunchObjectFavoriteContainerModel || !(container instanceof LaunchObjectContainerModel)) continue;
                for (LaunchObjectModel m : ((LaunchObjectContainerModel)container).getChildren()) {
                    if (m.getObject() == null || !m.getObject().canTerminate()) continue;
                    m.getObject().terminate();
                }
            }
        }
    }
}

