/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.emf;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.hawk.core.model.IHawkClass;
import org.eclipse.hawk.core.model.IHawkClassifier;
import org.eclipse.hawk.core.model.IHawkMetaModelResource;
import org.eclipse.hawk.core.model.IHawkPackage;
import org.eclipse.hawk.emf.EMFModelElement;
import org.eclipse.hawk.emf.EMFWrapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMFPackage
extends EMFModelElement
implements IHawkPackage {
    private static final Logger LOGGER = LoggerFactory.getLogger(EMFPackage.class);
    private EPackage ep;
    private IHawkMetaModelResource r;

    public EMFPackage(EPackage e, EMFWrapperFactory wf, IHawkMetaModelResource res) {
        super((EModelElement)e, wf);
        this.ep = e;
        this.r = res;
    }

    public String getName() {
        return this.ep.getName();
    }

    public EPackage getEObject() {
        return this.ep;
    }

    public IHawkClass getClassifier(String string) {
        EClassifier e = this.ep.getEClassifier(string);
        if (e instanceof EClass) {
            return this.wf.createClass((EClass)e);
        }
        LOGGER.warn("Called getEClassifier(String string) on non-eclass {}: BUG?", (Object)e);
        return null;
    }

    public String getNsURI() {
        return this.ep.getNsURI();
    }

    public Set<IHawkClassifier> getClasses() {
        HashSet<IHawkClassifier> ret = new HashSet<IHawkClassifier>();
        for (EClassifier e : this.ep.getEClassifiers()) {
            if (e instanceof EClass) {
                ret.add((IHawkClassifier)this.wf.createClass((EClass)e));
                continue;
            }
            if (!(e instanceof EDataType)) continue;
            ret.add((IHawkClassifier)this.wf.createDataType((EDataType)e));
        }
        return ret;
    }

    public IHawkMetaModelResource getResource() {
        return this.r;
    }

    @Override
    public int hashCode() {
        return this.ep.hashCode();
    }
}

