/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.io.emf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.parser.CifParser;
import org.eclipse.escet.cif.parser.ast.ASpecification;
import org.eclipse.escet.cif.prettyprinter.CifPrettyPrinter;
import org.eclipse.escet.cif.typechecker.CifTypeChecker;
import org.eclipse.escet.common.app.framework.PlatformUriUtils;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.OutputStreamCodeBox;
import org.eclipse.escet.common.java.exceptions.InputOutputException;
import org.eclipse.escet.common.typechecker.SemanticProblem;
import org.eclipse.escet.setext.runtime.SyntaxWarning;
import org.eclipse.escet.setext.runtime.exceptions.SyntaxException;

public class CifResource
extends ResourceImpl {
    public CifResource() {
    }

    public CifResource(URI uri) {
        super(uri);
    }

    protected void doLoad(InputStream stream, Map<?, ?> options) throws IOException {
        ASpecification specAst;
        String location = null;
        if (this.uri != null) {
            String path = this.uri.toFileString();
            if (path != null) {
                File file = new File(path);
                location = file.getAbsolutePath();
            } else {
                location = this.uri.toString();
                if (PlatformUriUtils.isPlatformUri((String)location)) {
                    location = PlatformUriUtils.normalizePlatformUri((String)location);
                }
            }
        }
        CifParser parser = new CifParser();
        try {
            specAst = (ASpecification)parser.parseStream(stream, location);
        }
        catch (InputOutputException ex) {
            throw new IOException("Failed to read input.", ex);
        }
        catch (SyntaxException ex) {
            CifSyntaxErrorDiagnostic diagnostic = new CifSyntaxErrorDiagnostic(ex);
            if (this.errors == null) {
                this.getErrors();
            }
            this.errors.add((Object)diagnostic);
            return;
        }
        for (SyntaxWarning warning : parser.getWarnings()) {
            CifSyntaxWarningDiagnostic diagnostic = new CifSyntaxWarningDiagnostic(warning);
            if (this.warnings == null) {
                this.getWarnings();
            }
            this.warnings.add((Object)diagnostic);
        }
        CifTypeChecker tchecker = new CifTypeChecker();
        if (location != null) {
            tchecker.setSourceFilePath(location);
        }
        Specification spec = (Specification)tchecker.typeCheck((Object)specAst);
        for (SemanticProblem problem : tchecker.getProblems()) {
            CifSemanticDiagnostic diagnostic = new CifSemanticDiagnostic(problem);
            switch (problem.severity) {
                case ERROR: {
                    if (this.errors == null) {
                        this.getErrors();
                    }
                    this.errors.add((Object)diagnostic);
                    break;
                }
                case WARNING: {
                    if (this.warnings == null) {
                        this.getWarnings();
                    }
                    this.warnings.add((Object)diagnostic);
                }
            }
        }
        if (spec != null) {
            this.getContents().add((Object)spec);
        }
    }

    protected void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        OutputStreamCodeBox streamBox = new OutputStreamCodeBox(outputStream, "a CIF file");
        Specification spec = (Specification)this.getContents().get(0);
        try {
            CifPrettyPrinter.boxSpec((Specification)spec, (CodeBox)streamBox);
        }
        catch (InputOutputException ex) {
            Throwable cause = ex;
            String msg = "Failed to write to a CIF file.";
            if (msg.equals(cause.getMessage())) {
                cause = ex.getCause();
            }
            throw new IOException("Failed to write to a CIF file.", cause);
        }
    }

    public class CifSemanticDiagnostic
    implements Resource.Diagnostic {
        public final SemanticProblem problem;

        public CifSemanticDiagnostic(SemanticProblem problem) {
            this.problem = problem;
        }

        public String getMessage() {
            return this.problem.toString();
        }

        public String getLocation() {
            return CifResource.this.uri == null ? null : CifResource.this.uri.toString();
        }

        public int getLine() {
            return this.problem.position.startLine;
        }

        public int getColumn() {
            return this.problem.position.endLine;
        }

        public String toString() {
            return this.problem.toString();
        }
    }

    public class CifSyntaxErrorDiagnostic
    implements Resource.Diagnostic {
        public final SyntaxException error;

        public CifSyntaxErrorDiagnostic(SyntaxException error) {
            this.error = error;
        }

        public String getMessage() {
            return this.error.toString();
        }

        public String getLocation() {
            return CifResource.this.uri == null ? null : CifResource.this.uri.toString();
        }

        public int getLine() {
            return this.error.getPosition().startLine;
        }

        public int getColumn() {
            return this.error.getPosition().endLine;
        }

        public String toString() {
            return this.error.toString();
        }
    }

    public class CifSyntaxWarningDiagnostic
    implements Resource.Diagnostic {
        public final SyntaxWarning warning;

        public CifSyntaxWarningDiagnostic(SyntaxWarning warning) {
            this.warning = warning;
        }

        public String getMessage() {
            return this.warning.toString();
        }

        public String getLocation() {
            return CifResource.this.uri == null ? null : CifResource.this.uri.toString();
        }

        public int getLine() {
            return this.warning.position.startLine;
        }

        public int getColumn() {
            return this.warning.position.endLine;
        }

        public String toString() {
            return this.warning.toString();
        }
    }
}

