/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaLaunchTab;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ControlAccessibleListener;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class VMArgumentsBlock
extends JavaLaunchTab {
    protected Text fVMArgumentsText;
    private Button fUseStartOnFirstThread = null;
    private Button fHelpfulExceptions = null;
    private Button fUseArgfile = null;
    private Button fPgrmArgVariableButton;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        this.setControl((Control)group);
        GridLayout topLayout = new GridLayout();
        group.setLayout((Layout)topLayout);
        GridData gd = new GridData(1808);
        group.setLayoutData((Object)gd);
        group.setFont(font);
        group.setText(LauncherMessages.JavaArgumentsTab_VM_ar_guments__6);
        this.fVMArgumentsText = new Text((Composite)group, 2626);
        this.fVMArgumentsText.addTraverseListener(e -> {
            switch (e.detail) {
                case 2: 
                case 256: 
                case 512: {
                    e.doit = true;
                    break;
                }
                case 4: 
                case 8: 
                case 16: {
                    if ((this.fVMArgumentsText.getStyle() & 4) == 0 && this.fVMArgumentsText.isEnabled() && (e.stateMask & SWT.MODIFIER_MASK) == 0) break;
                    e.doit = true;
                }
            }
        });
        gd = new GridData(1808);
        gd.heightHint = 40;
        gd.widthHint = 100;
        this.fVMArgumentsText.setLayoutData((Object)gd);
        this.fVMArgumentsText.setFont(font);
        this.fVMArgumentsText.addModifyListener(evt -> this.scheduleUpdateJob());
        ControlAccessibleListener.addListener((Control)this.fVMArgumentsText, group.getText());
        this.fPgrmArgVariableButton = this.createPushButton((Composite)group, LauncherMessages.VMArgumentsBlock_4, null);
        this.fPgrmArgVariableButton.setFont(font);
        this.fPgrmArgVariableButton.setLayoutData((Object)new GridData(128));
        this.fPgrmArgVariableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(VMArgumentsBlock.this.getShell());
                dialog.open();
                String variable = dialog.getVariableExpression();
                if (variable != null) {
                    VMArgumentsBlock.this.fVMArgumentsText.insert(variable);
                }
            }
        });
        if ("macosx".equals(Platform.getOS())) {
            this.fUseStartOnFirstThread = SWTFactory.createCheckButton((Composite)group, (String)LauncherMessages.VMArgumentsBlock_0, null, (boolean)false, (int)1);
            this.fUseStartOnFirstThread.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    VMArgumentsBlock.this.scheduleUpdateJob();
                }
            });
        }
        this.fHelpfulExceptions = SWTFactory.createCheckButton((Composite)group, (String)LauncherMessages.VMArgumentsBlock_2, null, (boolean)true, (int)1);
        this.fHelpfulExceptions.setEnabled(false);
        this.fHelpfulExceptions.setToolTipText(LauncherMessages.JavaArgumentsTab_AttributeTooltip_ActivateHelpfulNullPointerExceptions);
        this.fHelpfulExceptions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VMArgumentsBlock.this.scheduleUpdateJob();
            }
        });
        this.fUseArgfile = SWTFactory.createCheckButton((Composite)group, (String)LauncherMessages.VMArgumentsBlock_3, null, (boolean)true, (int)1);
        this.fUseArgfile.setEnabled(false);
        this.fUseArgfile.setToolTipText(LauncherMessages.JavaArgumentsTab_AttributeTooltip_UseArgfile);
        this.fUseArgfile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VMArgumentsBlock.this.scheduleUpdateJob();
            }
        });
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, null);
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_USE_START_ON_FIRST_THREAD, true);
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SHOW_CODEDETAILS_IN_EXCEPTION_MESSAGES, true);
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_USE_ARGFILE, false);
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.fVMArgumentsText.setText(configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, ""));
            if (this.fUseStartOnFirstThread != null) {
                this.fUseStartOnFirstThread.setSelection(configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_USE_START_ON_FIRST_THREAD, true));
            }
            if (this.fHelpfulExceptions != null) {
                this.fHelpfulExceptions.setSelection(configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_SHOW_CODEDETAILS_IN_EXCEPTION_MESSAGES, true));
            }
            if (this.fUseArgfile != null) {
                this.fUseArgfile.setSelection(configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_USE_ARGFILE, false));
            }
        }
        catch (CoreException e) {
            this.setErrorMessage(LauncherMessages.JavaArgumentsTab_Exception_occurred_reading_configuration___15 + e.getStatus().getMessage());
            JDIDebugUIPlugin.log(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, this.getAttributeValueFrom(this.fVMArgumentsText));
        if (this.fUseStartOnFirstThread != null) {
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_USE_START_ON_FIRST_THREAD, this.fUseStartOnFirstThread.getSelection());
        }
        if (this.isJavaNewerThan((ILaunchConfiguration)configuration, "13")) {
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SHOW_CODEDETAILS_IN_EXCEPTION_MESSAGES, this.fHelpfulExceptions.getSelection());
            this.fHelpfulExceptions.setEnabled(true);
        } else {
            this.fHelpfulExceptions.setEnabled(false);
        }
        if (this.isJavaNewerThan((ILaunchConfiguration)configuration, "1.8")) {
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_USE_ARGFILE, this.fUseArgfile.getSelection());
            this.fUseArgfile.setEnabled(true);
        } else {
            this.fUseArgfile.setEnabled(false);
        }
    }

    private boolean isJavaNewerThan(ILaunchConfiguration configuration, String version) {
        try {
            return JavaRuntime.compareJavaVersions((IVMInstall)JavaRuntime.computeVMInstall((ILaunchConfiguration)configuration), (String)version) > 0;
        }
        catch (CoreException e) {
            return false;
        }
    }

    public String getName() {
        return LauncherMessages.VMArgumentsBlock_VM_Arguments;
    }

    protected String getAttributeValueFrom(Text text) {
        String content = text.getText().trim();
        if (content.length() > 0) {
            return content;
        }
        return null;
    }

    public void setEnabled(boolean enabled) {
        this.fVMArgumentsText.setEnabled(enabled);
        this.fPgrmArgVariableButton.setEnabled(enabled);
    }
}

