/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.emf;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;

public class EMFPath {
    private final LinkedList<Level> levels = new LinkedList();

    public EMFPath(EObject eObject, EStructuralFeature eFeature) {
        this(eObject, eFeature, null);
    }

    public EMFPath(EObject eObject, EStructuralFeature eFeature, EObject root) {
        if (eFeature == null) {
            this.levels.addFirst(new Level(eObject, null, -1));
        } else {
            Object eAttrValue = eObject.eGet(eFeature);
            if (eAttrValue != null) {
                this.levels.addFirst(new Level(eAttrValue, null, -1));
            }
            this.levels.addFirst(new Level(eObject, eFeature, -1));
        }
        EObject eObj = eObject;
        while (eObj != root) {
            EObject eParent = eObj.eContainer();
            if (eParent == null) break;
            EReference eRef = eObj.eContainmentFeature();
            int index = -1;
            if (eRef.isMany()) {
                List eList = (List)eParent.eGet((EStructuralFeature)eRef);
                index = eList.indexOf(eObj);
            }
            this.levels.addFirst(new Level(eParent, (EStructuralFeature)eRef, index));
            eObj = eParent;
        }
        Assert.check((root == null || eObj == root ? 1 : 0) != 0);
    }

    public Object resolveAgainst(EObject root) {
        Object cur = root;
        for (Level level : this.levels) {
            if (level.feature == null) {
                return cur;
            }
            EObject curObj = cur;
            if (curObj == null) {
                String msg = Strings.fmt((String)"Feature %s on null object.", (Object[])new Object[]{level.feature});
                throw new IllegalArgumentException(msg);
            }
            EStructuralFeature feature = curObj.eClass().getEStructuralFeature(level.feature.getFeatureID());
            if (feature != level.feature) {
                String msg = Strings.fmt((String)"Feature %s does not exist for %s.", (Object[])new Object[]{level.feature, curObj});
                throw new IllegalArgumentException(msg);
            }
            cur = curObj.eGet(level.feature);
            if (!level.feature.isMany()) continue;
            List values = (List)cur;
            try {
                cur = values.get(level.index);
            }
            catch (IndexOutOfBoundsException ex) {
                String msg = Strings.fmt((String)"Index out of bounds for feature %s on object %s.", (Object[])new Object[]{level.feature, curObj});
                throw new IllegalArgumentException(msg, ex);
            }
        }
        return cur;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        for (Level level : this.levels) {
            if (text.length() > 0) {
                text.append(" / ");
            }
            text.append(level.toString());
        }
        return text.toString();
    }

    private class Level {
        public Object object;
        public EStructuralFeature feature;
        public Integer index;

        public Level(Object object, EStructuralFeature feature, Integer index) {
            this.object = object;
            this.feature = feature;
            this.index = index;
            Assert.check((object instanceof EObject || feature == null ? 1 : 0) != 0);
            Assert.check((object instanceof EObject || index < 0 ? 1 : 0) != 0);
        }

        public String toString() {
            if (!(this.object instanceof EObject)) {
                if (this.object instanceof String) {
                    return Strings.stringToJava((String)((String)this.object));
                }
                return this.object.toString();
            }
            EObject eObj = (EObject)this.object;
            String name = null;
            for (EStructuralFeature ef : eObj.eClass().getEAllStructuralFeatures()) {
                String nameValue;
                if (!(ef instanceof EAttribute) || !ef.getName().equals("name") && !ef.getName().equals("id") || ef.isMany() || !ef.getEType().getInstanceClassName().equals("java.lang.String") || (nameValue = (String)eObj.eGet(ef)) == null) continue;
                name = "(" + ef.getName() + "=" + nameValue + ")";
                break;
            }
            return Strings.fmt((String)"%s%s%s%s", (Object[])new Object[]{eObj.eClass().getName(), name == null ? "" : name, this.feature == null ? "" : "." + this.feature.getName(), this.index >= 0 ? "[" + String.valueOf(this.index) + "]" : ""});
        }
    }
}

