/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers.checks;

import org.eclipse.escet.cif.checkers.CifCheck;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.common.java.exceptions.UnsupportedException;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class EdgeOnlyStaticEvalGuardPredsCheck
extends CifCheck {
    protected void preprocessEdge(Edge edge, CifCheckViolations violations) {
        for (Expression guard : edge.getGuards()) {
            try {
                CifEvalUtils.evalPred((Expression)guard, (boolean)false, (boolean)true);
            }
            catch (UnsupportedException e) {
                violations.add((PositionObject)guard, "Edge has a guard that cannot be evaluated statically", new Object[0]);
            }
            catch (CifEvalException e) {
                Expression reportExpr = e.expr != null ? e.expr : guard;
                violations.add((PositionObject)reportExpr, "Edge has a guard that cannot be evaluated statically, as evaluating it results in an evaluation error", new Object[0]);
            }
        }
    }
}

