/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import java.util.Comparator;
import java.util.LinkedList;
import org.eclipse.help.IContext2;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.ui.internal.views.ReusableHelpPart;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class ContextHelpSorter
extends ViewerComparator {
    private final IContext2 context;
    private final LinkedList<String> list = new LinkedList();

    public ContextHelpSorter(IContext2 context) {
        super((Comparator)ReusableHelpPart.SHARED_COLLATOR);
        this.context = context;
    }

    public void sort(Viewer viewer, Object[] elements) {
        int i = 0;
        while (i < elements.length) {
            IHelpResource r1 = (IHelpResource)elements[i];
            String c1 = this.context.getCategory(r1);
            if (!this.list.contains(c1)) {
                this.list.add(c1);
            }
            ++i;
        }
        super.sort(viewer, elements);
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (!(e2 instanceof IHelpResource)) {
            return -1;
        }
        if (!(e1 instanceof IHelpResource)) {
            return 1;
        }
        IHelpResource r1 = (IHelpResource)e1;
        IHelpResource r2 = (IHelpResource)e2;
        String c1 = this.context.getCategory(r1);
        String c2 = this.context.getCategory(r2);
        int i1 = this.list.indexOf(c1);
        int i2 = this.list.indexOf(c2);
        return i1 - i2;
    }
}

