/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery.predicates;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.function.Predicate;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ReflectionUtils;

abstract class IsTestableMethod
implements Predicate<Method> {
    private final Class<? extends Annotation> annotationType;
    private final boolean mustReturnPrimitiveVoid;

    IsTestableMethod(Class<? extends Annotation> annotationType, boolean mustReturnPrimitiveVoid) {
        this.annotationType = annotationType;
        this.mustReturnPrimitiveVoid = mustReturnPrimitiveVoid;
    }

    @Override
    public boolean test(Method candidate) {
        if (ReflectionUtils.isStatic((Member)candidate)) {
            return false;
        }
        if (ReflectionUtils.isPrivate((Member)candidate)) {
            return false;
        }
        if (ReflectionUtils.isAbstract((Member)candidate)) {
            return false;
        }
        if (ReflectionUtils.returnsPrimitiveVoid((Method)candidate) != this.mustReturnPrimitiveVoid) {
            return false;
        }
        return AnnotationUtils.isAnnotated((AnnotatedElement)candidate, this.annotationType);
    }
}

