/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers.checks;

import org.eclipse.escet.cif.checkers.CifCheck;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.common.java.exceptions.UnsupportedException;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class LocOnlyStaticEvalInitPredsCheck
extends CifCheck {
    protected void preprocessLocation(Location loc, CifCheckViolations violations) {
        for (Expression initial : loc.getInitials()) {
            try {
                CifEvalUtils.evalPred((Expression)initial, (boolean)true, (boolean)true);
            }
            catch (UnsupportedException e) {
                violations.add((PositionObject)initial, "Location has an initialization predicate that cannot be evaluated statically", new Object[0]);
            }
            catch (CifEvalException e) {
                Expression reportExpr = e.expr != null ? e.expr : initial;
                violations.add((PositionObject)reportExpr, "Location has an initialization predicate that cannot be evaluated statically, as evaluating it results in an evaluation error", new Object[0]);
            }
        }
    }
}

