/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers.checks;

import java.util.Arrays;
import java.util.EnumSet;
import org.eclipse.escet.cif.checkers.CifCheckNoCompDefInst;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.common.CifEquationUtils;
import org.eclipse.escet.cif.metamodel.cif.InvKind;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TimeExpression;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class InvNoSpecificRefsCheck
extends CifCheckNoCompDefInst {
    private final EnumSet<NoSpecificInvRef> disalloweds;
    private EnumSet<InvKind> invKindsToCheck = EnumSet.allOf(InvKind.class);
    private InvKind curInvKind = null;

    public InvNoSpecificRefsCheck(NoSpecificInvRef ... disalloweds) {
        this(EnumSet.copyOf(Arrays.asList(disalloweds)));
    }

    public InvNoSpecificRefsCheck(EnumSet<NoSpecificInvRef> disalloweds) {
        this.disalloweds = disalloweds;
    }

    public InvNoSpecificRefsCheck setInvKinds(InvKind ... invKinds) {
        this.invKindsToCheck = EnumSet.copyOf(Arrays.asList(invKinds));
        return this;
    }

    protected void preprocessInvariant(Invariant inv, CifCheckViolations violations) {
        if (!this.invKindsToCheck.contains(inv.getInvKind())) {
            return;
        }
        this.curInvKind = inv.getInvKind();
        this.walkExpression(inv.getPredicate(), violations);
        this.curInvKind = null;
    }

    protected void preprocessInputVariableExpression(InputVariableExpression inputVarRef, CifCheckViolations violations) {
        if (this.curInvKind != null && this.disalloweds.contains((Object)NoSpecificInvRef.INPUT_VARS)) {
            violations.add((PositionObject)inputVarRef, "An input variable is used in %s invariant", this.getInvViolationDescription(this.curInvKind));
        }
    }

    protected void preprocessTimeExpression(TimeExpression timeRef, CifCheckViolations violations) {
        if (this.curInvKind != null && this.disalloweds.contains((Object)NoSpecificInvRef.TIME_DEPENDENT)) {
            violations.add((PositionObject)timeRef, "Variable \"time\" is used in %s invariant", this.getInvViolationDescription(this.curInvKind));
        }
    }

    protected void preprocessContVariableExpression(ContVariableExpression contVarRef, CifCheckViolations violations) {
        if (this.curInvKind != null) {
            if (contVarRef.isDerivative()) {
                for (Expression deriv : CifEquationUtils.getDerivativesForContVar((ContVariable)contVarRef.getVariable(), (boolean)false)) {
                    this.walkExpression(deriv, violations);
                }
            } else if (this.disalloweds.contains((Object)NoSpecificInvRef.TIME_DEPENDENT)) {
                violations.add((PositionObject)contVarRef, "A continuous variable is used in %s invariant", this.getInvViolationDescription(this.curInvKind));
            }
        }
    }

    protected void preprocessAlgVariableExpression(AlgVariableExpression algVarRef, CifCheckViolations violations) {
        if (this.curInvKind != null) {
            for (Expression value : CifEquationUtils.getValuesForAlgVar((AlgVariable)algVarRef.getVariable(), (boolean)false)) {
                this.walkExpression(value, violations);
            }
        }
    }

    private String getInvViolationDescription(InvKind invKind) {
        if (this.invKindsToCheck.size() == InvKind.values().length) {
            return "an";
        }
        return switch (invKind) {
            case InvKind.EVENT_DISABLES -> "a state/event exclusion" + (!this.invKindsToCheck.contains(InvKind.EVENT_NEEDS) ? " \"disables\"" : "");
            case InvKind.EVENT_NEEDS -> "a state/event exclusion" + (!this.invKindsToCheck.contains(InvKind.EVENT_DISABLES) ? " \"needs\"" : "");
            case InvKind.STATE -> "a state";
            default -> throw new MatchException(null, null);
        };
    }

    public static enum NoSpecificInvRef {
        INPUT_VARS,
        TIME_DEPENDENT;

    }
}

