/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.relations.ciftodmm;

import org.eclipse.escet.cif.checkers.CifCheck;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.metamodel.cif.InvKind;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class SpecHasRequirementCheck
extends CifCheck {
    private int numReqs;

    protected void preprocessSpecification(Specification spec, CifCheckViolations violations) {
        this.numReqs = 0;
    }

    protected void postprocessSpecification(Specification spec, CifCheckViolations violations) {
        if (this.numReqs < 1) {
            violations.add((PositionObject)spec, "Specification has neither a requirement automaton nor a state/event exclusion requirement invariant", new Object[0]);
        }
    }

    protected void preprocessInvariant(Invariant inv, CifCheckViolations violations) {
        if (inv.getSupKind() != SupKind.REQUIREMENT) {
            return;
        }
        if (inv.getInvKind() == InvKind.EVENT_DISABLES || inv.getInvKind() == InvKind.EVENT_NEEDS) {
            ++this.numReqs;
        }
    }

    protected void preprocessAutomaton(Automaton aut, CifCheckViolations violations) {
        if (aut.getKind() == SupKind.REQUIREMENT) {
            ++this.numReqs;
        }
    }
}

