/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.output.svgviz;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.escet.cif.simulator.options.TestModeOption;
import org.eclipse.escet.cif.simulator.output.svgviz.RuntimeCifSvgDecls;
import org.eclipse.escet.cif.simulator.output.svgviz.ShutdownRuntimeState;
import org.eclipse.escet.cif.simulator.output.svgviz.SvgPaintThread;
import org.eclipse.escet.cif.simulator.runtime.CifSimulatorException;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeState;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.svg.SvgCanvas;
import org.eclipse.escet.common.svg.SvgVisualizer;
import org.eclipse.escet.common.svg.selector.SvgSelector;

public class SvgRenderThread
extends Thread {
    private static final int QUEUE_SIZE = 1;
    private final BlockingQueue<RuntimeState> stateQueue = new LinkedBlockingQueue<RuntimeState>(1);
    public SvgSelector selector;
    private final RuntimeCifSvgDecls cifSvgDecls;
    private final SvgCanvas canvas;
    private final SvgPaintThread paintThread;
    protected final boolean testMode;
    private final Semaphore testModeSemaphore;
    public AtomicReference<Throwable> exception = new AtomicReference();

    public SvgRenderThread(RuntimeCifSvgDecls cifSvgDecls, SvgVisualizer visualizer, SvgPaintThread paintThread) {
        super(SvgRenderThread.class.getName() + "-" + cifSvgDecls.svgNr);
        this.cifSvgDecls = cifSvgDecls;
        this.canvas = visualizer.getSvgCanvas();
        this.paintThread = paintThread;
        this.testMode = TestModeOption.isEnabled();
        this.testModeSemaphore = this.testMode ? new Semaphore(0) : null;
    }

    public void addState(RuntimeState state) {
        try {
            this.stateQueue.put(state);
            if (this.testMode) {
                this.testModeSemaphore.acquire();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void signalSyncLock() {
        if (this.testMode) {
            this.testModeSemaphore.release();
        }
    }

    @Override
    public void run() {
        try {
            this.runInternal(true);
        }
        catch (Throwable ex) {
            this.exception.set(ex);
            this.signalSyncLock();
            this.runInternal(false);
        }
    }

    private void runInternal(boolean normalMode) {
        boolean first = true;
        while (true) {
            int height;
            int width;
            byte[] pixelData;
            RuntimeState state;
            try {
                state = this.stateQueue.take();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (state == ShutdownRuntimeState.INSTANCE) {
                this.signalSyncLock();
                this.paintThread.addData((Pair<Double, byte[]>)Pair.pair((Object)-1.0, null));
                return;
            }
            if (!normalMode) {
                this.signalSyncLock();
                continue;
            }
            if (this.selector != null) {
                this.selector.processQueue(false);
            }
            try {
                this.cifSvgDecls.applyOutput(state);
            }
            catch (CifSimulatorException e) {
                String msg = "Simulation resulted in a runtime error during application of SVG output mappings.";
                throw new CifSimulatorException(msg, e, state);
            }
            if (this.selector != null) {
                this.selector.processQueue(true);
            }
            if (first) {
                try {
                    this.canvas.updateImageSize();
                }
                catch (CifSimulatorException ex) {
                    String msg = Strings.fmt((String)"Failed to update image size for SVG image file \"%s\".", (Object[])new Object[]{this.cifSvgDecls.getSvgRelPath()});
                    throw new CifSimulatorException(msg, ex, state);
                }
                first = false;
            }
            Assert.check(((pixelData = this.canvas.paintInMemory(width = this.canvas.getImageWidth(), height = this.canvas.getImageHeight())).length > 0 ? 1 : 0) != 0);
            this.paintThread.addData((Pair<Double, byte[]>)Pair.pair((Object)state.getTime(), (Object)pixelData));
            this.signalSyncLock();
        }
    }
}

