/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth;

import com.github.javabdd.BDD;
import com.github.javabdd.BDDFactory;
import java.math.BigInteger;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.escet.cif.bdd.conversion.CifToBddConverter;
import org.eclipse.escet.cif.bdd.settings.CifBddSettings;
import org.eclipse.escet.cif.bdd.settings.ExplorationStrategy;
import org.eclipse.escet.cif.bdd.spec.CifBddDiscVariable;
import org.eclipse.escet.cif.bdd.spec.CifBddEdge;
import org.eclipse.escet.cif.bdd.spec.CifBddEdgeApplyDirection;
import org.eclipse.escet.cif.bdd.spec.CifBddEdgeKind;
import org.eclipse.escet.cif.bdd.spec.CifBddSpec;
import org.eclipse.escet.cif.bdd.spec.CifBddVariable;
import org.eclipse.escet.cif.bdd.utils.BddUtils;
import org.eclipse.escet.cif.bdd.utils.CifBddApplyPlantInvariants;
import org.eclipse.escet.cif.bdd.utils.CifBddReachability;
import org.eclipse.escet.cif.bdd.workset.dependencies.BddBasedEdgeDependencySetCreator;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.datasynth.CifDataSynthesisResult;
import org.eclipse.escet.cif.datasynth.CifDataSynthesisTiming;
import org.eclipse.escet.cif.datasynth.EmptySupervisorException;
import org.eclipse.escet.cif.datasynth.conversion.SynthesisToCifConverter;
import org.eclipse.escet.cif.datasynth.settings.BddSimplify;
import org.eclipse.escet.cif.datasynth.settings.CifDataSynthesisFree;
import org.eclipse.escet.cif.datasynth.settings.CifDataSynthesisSettings;
import org.eclipse.escet.cif.datasynth.settings.FixedPointComputation;
import org.eclipse.escet.cif.datasynth.settings.StateReqInvEnforceMode;
import org.eclipse.escet.cif.datasynth.settings.SynthesisStatistics;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.typechecker.postchk.CifAnnotationsPostChecker;
import org.eclipse.escet.cif.typechecker.postchk.CifPostCheckEnv;
import org.eclipse.escet.cif.typechecker.postchk.CifToolPostCheckEnv;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.box.GridBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.BitSets;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Stopwatch;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.Termination;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticException;

public class CifDataSynthesis {
    private CifDataSynthesis() {
    }

    public static Specification doSynthesisOnSpec(Specification spec, String absInputPath, String absInputDirPath, CifDataSynthesisSettings settings, CifDataSynthesisTiming timing) {
        boolean dbgEnabled = settings.getDebugOutput().isEnabled();
        Termination termination = settings.getTermination();
        CifToBddConverter toBddConverter = CifDataSynthesis.checkAndPreprocessSpec(spec, absInputPath, settings, timing);
        if (termination.isRequested()) {
            return null;
        }
        Specification resultSpec = CifDataSynthesis.computeControlledSystem(spec, toBddConverter, settings, timing);
        if (termination.isRequested()) {
            return null;
        }
        CifDataSynthesis.checkResultSpec(resultSpec, absInputDirPath, dbgEnabled);
        return resultSpec;
    }

    private static CifToBddConverter checkAndPreprocessSpec(Specification spec, String absInputPath, CifDataSynthesisSettings settings, CifDataSynthesisTiming timing) {
        boolean dbgEnabled = settings.getDebugOutput().isEnabled();
        boolean doTiming = settings.getSynthesisStatistics().contains((Object)SynthesisStatistics.TIMING);
        if (dbgEnabled) {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Preprocessing CIF specification (includes checking that the specification is supported).");
        }
        if (doTiming) {
            timing.inputPreProcess.start();
        }
        CifToBddConverter toBddConverter = new CifToBddConverter("Data-based supervisory controller synthesis");
        try {
            toBddConverter.preprocess(spec, absInputPath, settings.getWarnOutput(), settings.getDoPlantsRefReqsWarn(), settings.getTermination());
        }
        finally {
            if (doTiming) {
                timing.inputPreProcess.stop();
            }
        }
        return toBddConverter;
    }

    private static Specification computeControlledSystem(Specification spec, CifToBddConverter toBddConverter, CifDataSynthesisSettings settings, CifDataSynthesisTiming timing) {
        Specification resultSpec;
        boolean dbgEnabled = settings.getDebugOutput().isEnabled();
        boolean doTiming = settings.getSynthesisStatistics().contains((Object)SynthesisStatistics.TIMING);
        Termination termination = settings.getTermination();
        List continuousOpMisses = Lists.list();
        List continuousUsedBddNodes = Lists.list();
        BDDFactory factory = CifToBddConverter.createFactory((CifBddSettings)settings, (List)continuousOpMisses, (List)continuousUsedBddNodes);
        try {
            CifBddSpec cifBddSpec;
            if (dbgEnabled) {
                OutputProvider.dbg();
                OutputProvider.dbg((String)"Converting CIF specification to internal format (BDDs):");
            }
            if (doTiming) {
                timing.inputConvert.start();
            }
            try {
                OutputProvider.idbg();
                cifBddSpec = toBddConverter.convert(spec, (CifBddSettings)settings, factory);
                toBddConverter.free();
                OutputProvider.ddbg();
            }
            finally {
                if (doTiming) {
                    timing.inputConvert.stop();
                }
            }
            if (termination.isRequested()) {
                return null;
            }
            if (dbgEnabled) {
                OutputProvider.dbg();
                OutputProvider.dbg((String)"Starting data-based synthesis.");
            }
            CifDataSynthesisResult synthResult = null;
            boolean emptySupervisor = false;
            try {
                synthResult = CifDataSynthesis.synthesize(cifBddSpec, settings, timing);
            }
            catch (EmptySupervisorException ex) {
                emptySupervisor = true;
            }
            if (termination.isRequested()) {
                return null;
            }
            if (emptySupervisor) {
                resultSpec = null;
            } else {
                if (dbgEnabled) {
                    OutputProvider.dbg();
                    OutputProvider.dbg((String)"Constructing output CIF specification.");
                }
                SynthesisToCifConverter toCifConverter = new SynthesisToCifConverter();
                if (doTiming) {
                    timing.outputConvert.start();
                }
                try {
                    resultSpec = toCifConverter.convert(synthResult, spec);
                }
                finally {
                    if (doTiming) {
                        timing.outputConvert.stop();
                    }
                }
                if (termination.isRequested()) {
                    return null;
                }
            }
            BddUtils.printStats((BDDFactory)factory, (CifBddSettings)settings, (List)continuousOpMisses, (List)continuousUsedBddNodes, (String)settings.getContinuousPerformanceStatisticsFilePath(), (String)settings.getContinuousPerformanceStatisticsFileAbsPath());
            if (termination.isRequested()) {
                return null;
            }
            if (emptySupervisor) {
                throw new EmptySupervisorException();
            }
        }
        finally {
            factory.done();
        }
        return resultSpec;
    }

    private static void checkResultSpec(Specification resultSpec, String absInputDirPath, boolean dbgEnabled) {
        if (dbgEnabled) {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Checking output CIF specification.");
        }
        CifToolPostCheckEnv env = new CifToolPostCheckEnv(absInputDirPath, "synthesized");
        try {
            new CifAnnotationsPostChecker((CifPostCheckEnv)env).check(resultSpec);
        }
        catch (SemanticException semanticException) {
            // empty catch block
        }
        env.throwUnsupportedExceptionIfAnyErrors("Supervisory controller synthesis failed.");
    }

    public static CifDataSynthesisResult synthesize(CifBddSpec cifBddSpec, CifDataSynthesisSettings settings, CifDataSynthesisTiming timing) {
        CifDataSynthesisResult synthResult = new CifDataSynthesisResult(cifBddSpec, settings);
        boolean doTiming = synthResult.settings.getSynthesisStatistics().contains((Object)SynthesisStatistics.TIMING);
        boolean doForward = synthResult.settings.getDoForwardReach();
        boolean dbgEnabled = cifBddSpec.settings.getDebugOutput().isEnabled();
        Set<Event> disabledEvents = null;
        if (doTiming) {
            timing.preSynth.start();
        }
        try {
            if (cifBddSpec.settings.getTermination().isRequested()) {
                return null;
            }
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().line();
                cifBddSpec.settings.getDebugOutput().line("Synthesis input:");
                cifBddSpec.settings.getDebugOutput().inc();
                CifDataSynthesis.printDebugInput(cifBddSpec, synthResult);
                cifBddSpec.settings.getDebugOutput().dec();
            }
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().line();
                cifBddSpec.settings.getDebugOutput().line("Checking input for potential problems.");
            }
            CifDataSynthesis.checkInput(cifBddSpec, synthResult);
            if (cifBddSpec.settings.getTermination().isRequested()) {
                return null;
            }
            if (dbgEnabled) {
                CifDataSynthesis.printDebugRuntimeErrorPrevention(cifBddSpec, synthResult);
            }
            if (cifBddSpec.settings.getTermination().isRequested()) {
                return null;
            }
            CifBddApplyPlantInvariants.applyStateEvtExclPlantsInvs((CifBddSpec)cifBddSpec, (String)"uncontrolled system", () -> synthResult.getCtrlBehText(), (boolean)dbgEnabled);
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().line();
                cifBddSpec.settings.getDebugOutput().line("Initializing edges for being applied.");
            }
            for (CifBddEdge edge : cifBddSpec.edges) {
                if (cifBddSpec.settings.getTermination().isRequested()) {
                    return null;
                }
                edge.initApply();
            }
            if (cifBddSpec.settings.getTermination().isRequested()) {
                return null;
            }
            CifBddApplyPlantInvariants.applyStatePlantInvs((CifBddSpec)cifBddSpec, (String)"uncontrolled system", () -> synthResult.getCtrlBehText(), (boolean)dbgEnabled);
            if (cifBddSpec.settings.getTermination().isRequested()) {
                return null;
            }
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().line();
                cifBddSpec.settings.getDebugOutput().line("Initializing controlled behavior:");
                cifBddSpec.settings.getDebugOutput().inc();
            }
            synthResult.ctrlBeh = cifBddSpec.factory.one();
            synthResult.initialCtrl = cifBddSpec.initialPlantInv.id();
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().line("Controlled-behavior predicate: %s.", new Object[]{BddUtils.bddToStr((BDD)synthResult.ctrlBeh, (CifBddSpec)cifBddSpec)});
                cifBddSpec.settings.getDebugOutput().line("Controlled-initialization predicate: %s.", new Object[]{BddUtils.bddToStr((BDD)synthResult.initialCtrl, (CifBddSpec)cifBddSpec)});
                cifBddSpec.settings.getDebugOutput().dec();
            }
            if (cifBddSpec.settings.getTermination().isRequested()) {
                return null;
            }
            CifDataSynthesis.applyStateReqInvs(cifBddSpec, synthResult, dbgEnabled);
            if (cifBddSpec.settings.getTermination().isRequested()) {
                return null;
            }
            CifDataSynthesis.applyVarRanges(cifBddSpec, synthResult, dbgEnabled);
            if (cifBddSpec.settings.getTermination().isRequested()) {
                return null;
            }
            CifDataSynthesis.applyStateEvtExclReqs(cifBddSpec, synthResult, dbgEnabled);
            if (cifBddSpec.settings.getTermination().isRequested()) {
                return null;
            }
            CifDataSynthesis.applyRuntimeErrorReqs(cifBddSpec, synthResult, dbgEnabled);
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().line();
                cifBddSpec.settings.getDebugOutput().line("Re-initializing edges for being applied.");
            }
            for (CifBddEdge edge : cifBddSpec.edges) {
                if (cifBddSpec.settings.getTermination().isRequested()) {
                    return null;
                }
                edge.reinitApply();
            }
            if (cifBddSpec.settings.getTermination().isRequested()) {
                return null;
            }
            if (synthResult.settings.getDoNeverEnabledEventsWarn()) {
                disabledEvents = CifDataSynthesis.checkInputEdges(cifBddSpec, dbgEnabled);
            }
            if (cifBddSpec.settings.getExplorationStrategy() == ExplorationStrategy.CHAINING_WORKSET) {
                if (cifBddSpec.settings.getTermination().isRequested()) {
                    return null;
                }
                CifDataSynthesis.prepareWorksetAlgorithm(cifBddSpec, synthResult.settings.getDoForwardReach(), dbgEnabled);
            }
        }
        finally {
            if (doTiming) {
                timing.preSynth.stop();
            }
        }
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return null;
        }
        if (doTiming) {
            timing.main.start();
        }
        try {
            if (cifBddSpec.settings.getTermination().isRequested()) {
                return null;
            }
            CifDataSynthesis.synthesizeFixedPoints(cifBddSpec, synthResult, doForward, dbgEnabled, doTiming, timing);
            if (settings.doFree(CifDataSynthesisFree.SPEC_MARKED)) {
                cifBddSpec.marked = BddUtils.free((BDD)cifBddSpec.marked);
            }
            cifBddSpec.reachReqPreds = (List)BddUtils.free((Collection)cifBddSpec.reachReqPreds);
        }
        finally {
            if (doTiming) {
                timing.main.stop();
            }
        }
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return null;
        }
        if (doTiming) {
            timing.postSynth.start();
        }
        try {
            boolean emptySup;
            if (cifBddSpec.settings.getTermination().isRequested()) {
                return null;
            }
            CifDataSynthesis.determineCtrlSysGuards(cifBddSpec, synthResult, dbgEnabled);
            if (cifBddSpec.settings.getTermination().isRequested()) {
                return null;
            }
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().line();
                cifBddSpec.settings.getDebugOutput().line("Cleaning up cached predicate of edges that were used when applying edges.");
            }
            for (CifBddEdge edge : cifBddSpec.edges) {
                edge.cleanupApply();
            }
            if (cifBddSpec.settings.getTermination().isRequested()) {
                return null;
            }
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().line();
                cifBddSpec.settings.getDebugOutput().line("Final synthesis result:");
                cifBddSpec.settings.getDebugOutput().inc();
                cifBddSpec.settings.getDebugOutput().line(synthResult.getCtrlBehText());
                cifBddSpec.settings.getDebugOutput().inc();
                for (String line : cifBddSpec.getEdgesText()) {
                    cifBddSpec.settings.getDebugOutput().line(line);
                }
                cifBddSpec.settings.getDebugOutput().dec();
                cifBddSpec.settings.getDebugOutput().dec();
            }
            if (cifBddSpec.settings.getTermination().isRequested()) {
                return null;
            }
            CifDataSynthesis.determineCtrlSysInit(cifBddSpec, synthResult, dbgEnabled);
            boolean bl = emptySup = !CifDataSynthesis.checkInitStatePresent(synthResult);
            if (settings.getSynthesisStatistics().contains((Object)SynthesisStatistics.CTRL_SYS_STATES)) {
                if (cifBddSpec.settings.getTermination().isRequested()) {
                    return null;
                }
                CifDataSynthesis.printNumberStates(cifBddSpec, synthResult, emptySup, doForward, dbgEnabled);
            }
        }
        finally {
            if (doTiming) {
                timing.postSynth.stop();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void printDebugInput(CifBddSpec cifBddSpec, CifDataSynthesisResult synthResult) {
        void var2_19;
        void var2_11;
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return;
        }
        for (BDD bDD : cifBddSpec.plantInvsComps) {
            cifBddSpec.settings.getDebugOutput().line("Invariant (component state plant invariant): %s", new Object[]{BddUtils.bddToStr((BDD)bDD, (CifBddSpec)cifBddSpec)});
        }
        cifBddSpec.settings.getDebugOutput().line("Invariant (components state plant inv):      %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.plantInvComps, (CifBddSpec)cifBddSpec)});
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return;
        }
        for (BDD bDD : cifBddSpec.plantInvsLocs) {
            cifBddSpec.settings.getDebugOutput().line("Invariant (location state plant invariant):  %s", new Object[]{BddUtils.bddToStr((BDD)bDD, (CifBddSpec)cifBddSpec)});
        }
        cifBddSpec.settings.getDebugOutput().line("Invariant (locations state plant invariant): %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.plantInvLocs, (CifBddSpec)cifBddSpec)});
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return;
        }
        cifBddSpec.settings.getDebugOutput().line("Invariant (system state plant invariant):    %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.plantInv, (CifBddSpec)cifBddSpec)});
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return;
        }
        cifBddSpec.settings.getDebugOutput().line();
        for (BDD bDD : cifBddSpec.reqInvsComps) {
            cifBddSpec.settings.getDebugOutput().line("Invariant (component state req invariant):   %s", new Object[]{BddUtils.bddToStr((BDD)bDD, (CifBddSpec)cifBddSpec)});
        }
        cifBddSpec.settings.getDebugOutput().line("Invariant (components state req invariant):  %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.reqInvComps, (CifBddSpec)cifBddSpec)});
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return;
        }
        for (BDD bDD : cifBddSpec.reqInvsLocs) {
            cifBddSpec.settings.getDebugOutput().line("Invariant (location state req invariant):    %s", new Object[]{BddUtils.bddToStr((BDD)bDD, (CifBddSpec)cifBddSpec)});
        }
        cifBddSpec.settings.getDebugOutput().line("Invariant (locations state req invariant):   %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.reqInvLocs, (CifBddSpec)cifBddSpec)});
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return;
        }
        cifBddSpec.settings.getDebugOutput().line("Invariant (system state req invariant):      %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.reqInv, (CifBddSpec)cifBddSpec)});
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return;
        }
        cifBddSpec.settings.getDebugOutput().line();
        boolean bl = false;
        while (var2_11 < cifBddSpec.variables.size()) {
            CifBddVariable var = (CifBddVariable)cifBddSpec.variables.get((int)var2_11);
            if (var instanceof CifBddDiscVariable) {
                CifBddDiscVariable discVar = (CifBddDiscVariable)var;
                String nr = String.valueOf((int)var2_11);
                BDD initPred = (BDD)cifBddSpec.initialsVars.get(discVar);
                if (initPred != null) {
                    cifBddSpec.settings.getDebugOutput().line("Initial   (discrete variable %s):%s%s", new Object[]{nr, Strings.spaces((int)(14 - nr.length())), BddUtils.bddToStr((BDD)initPred, (CifBddSpec)cifBddSpec)});
                }
            }
            ++var2_11;
        }
        cifBddSpec.settings.getDebugOutput().line("Initial   (discrete variables):              %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.initialVars, (CifBddSpec)cifBddSpec)});
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return;
        }
        for (BDD bDD : cifBddSpec.initialsComps) {
            cifBddSpec.settings.getDebugOutput().line("Initial   (component init predicate):        %s", new Object[]{BddUtils.bddToStr((BDD)bDD, (CifBddSpec)cifBddSpec)});
        }
        cifBddSpec.settings.getDebugOutput().line("Initial   (components init predicate):       %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.initialComps, (CifBddSpec)cifBddSpec)});
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return;
        }
        for (BDD bDD : cifBddSpec.initialsLocs) {
            cifBddSpec.settings.getDebugOutput().line("Initial   (aut/locs init predicate):         %s", new Object[]{BddUtils.bddToStr((BDD)bDD, (CifBddSpec)cifBddSpec)});
        }
        cifBddSpec.settings.getDebugOutput().line("Initial   (auts/locs init predicate):        %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.initialLocs, (CifBddSpec)cifBddSpec)});
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return;
        }
        cifBddSpec.settings.getDebugOutput().line("Initial   (uncontrolled system):             %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.initial, (CifBddSpec)cifBddSpec)});
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return;
        }
        cifBddSpec.settings.getDebugOutput().line("Initial   (system, combined init/plant inv): %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.initialPlantInv, (CifBddSpec)cifBddSpec)});
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return;
        }
        cifBddSpec.settings.getDebugOutput().line("Initial   (system, combined init/state inv): %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.initialInv, (CifBddSpec)cifBddSpec)});
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return;
        }
        cifBddSpec.settings.getDebugOutput().line();
        for (BDD bDD : cifBddSpec.markedsComps) {
            cifBddSpec.settings.getDebugOutput().line("Marked    (component marker predicate):      %s", new Object[]{BddUtils.bddToStr((BDD)bDD, (CifBddSpec)cifBddSpec)});
        }
        cifBddSpec.settings.getDebugOutput().line("Marked    (components marker predicate):     %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.markedComps, (CifBddSpec)cifBddSpec)});
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return;
        }
        for (BDD bDD : cifBddSpec.markedsLocs) {
            cifBddSpec.settings.getDebugOutput().line("Marked    (aut/locs marker predicate):       %s", new Object[]{BddUtils.bddToStr((BDD)bDD, (CifBddSpec)cifBddSpec)});
        }
        cifBddSpec.settings.getDebugOutput().line("Marked    (auts/locs marker predicate):      %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.markedLocs, (CifBddSpec)cifBddSpec)});
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return;
        }
        cifBddSpec.settings.getDebugOutput().line("Marked    (uncontrolled system):             %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.marked, (CifBddSpec)cifBddSpec)});
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return;
        }
        cifBddSpec.settings.getDebugOutput().line("Marked    (system, combined mark/plant inv): %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.markedPlantInv, (CifBddSpec)cifBddSpec)});
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return;
        }
        cifBddSpec.settings.getDebugOutput().line("Marked    (system, combined mark/state inv): %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.markedInv, (CifBddSpec)cifBddSpec)});
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return;
        }
        cifBddSpec.settings.getDebugOutput().line();
        cifBddSpec.settings.getDebugOutput().line("State/event exclusion plants:");
        cifBddSpec.settings.getDebugOutput().inc();
        if (cifBddSpec.stateEvtExclPlantLists.values().stream().flatMap(x -> x.stream()).findAny().isEmpty()) {
            cifBddSpec.settings.getDebugOutput().line("None");
        }
        for (Map.Entry entry : cifBddSpec.stateEvtExclPlantLists.entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            cifBddSpec.settings.getDebugOutput().line("Event \"%s\" needs:", new Object[]{CifTextUtils.getAbsName((PositionObject)((PositionObject)entry.getKey()))});
            cifBddSpec.settings.getDebugOutput().inc();
            for (BDD pred : (List)entry.getValue()) {
                cifBddSpec.settings.getDebugOutput().line(BddUtils.bddToStr((BDD)pred, (CifBddSpec)cifBddSpec));
            }
            cifBddSpec.settings.getDebugOutput().dec();
        }
        cifBddSpec.settings.getDebugOutput().dec();
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return;
        }
        cifBddSpec.settings.getDebugOutput().line();
        cifBddSpec.settings.getDebugOutput().line("State/event exclusion requirements:");
        cifBddSpec.settings.getDebugOutput().inc();
        if (cifBddSpec.stateEvtExclReqLists.values().stream().flatMap(x -> x.stream()).findAny().isEmpty()) {
            cifBddSpec.settings.getDebugOutput().line("None");
        }
        for (Map.Entry entry : cifBddSpec.stateEvtExclReqLists.entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            cifBddSpec.settings.getDebugOutput().line("Event \"%s\" needs:", new Object[]{CifTextUtils.getAbsName((PositionObject)((PositionObject)entry.getKey()))});
            cifBddSpec.settings.getDebugOutput().inc();
            for (BDD pred : (List)entry.getValue()) {
                cifBddSpec.settings.getDebugOutput().line(BddUtils.bddToStr((BDD)pred, (CifBddSpec)cifBddSpec));
            }
            cifBddSpec.settings.getDebugOutput().dec();
        }
        cifBddSpec.settings.getDebugOutput().dec();
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return;
        }
        cifBddSpec.settings.getDebugOutput().line();
        cifBddSpec.settings.getDebugOutput().line("Reachability requirements:");
        cifBddSpec.settings.getDebugOutput().inc();
        if (cifBddSpec.reachReqPreds.isEmpty()) {
            cifBddSpec.settings.getDebugOutput().line("None");
        }
        boolean bl2 = false;
        while (var2_19 < cifBddSpec.reachReqPreds.size()) {
            BDD reachReq = (BDD)cifBddSpec.reachReqPreds.get((int)var2_19);
            cifBddSpec.settings.getDebugOutput().line("%,d/%,d: %s", new Object[]{(int)(var2_19 + true), cifBddSpec.reachReqPreds.size(), BddUtils.bddToStr((BDD)reachReq, (CifBddSpec)cifBddSpec)});
            ++var2_19;
        }
        cifBddSpec.settings.getDebugOutput().dec();
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return;
        }
        cifBddSpec.settings.getDebugOutput().line();
        if (cifBddSpec.stateEvtExclPlantLists.values().stream().flatMap(x -> x.stream()).findAny().isEmpty()) {
            cifBddSpec.settings.getDebugOutput().line("Uncontrolled system:");
        } else {
            cifBddSpec.settings.getDebugOutput().line("Uncontrolled system (state/event exclusion plants not applied yet):");
        }
        cifBddSpec.settings.getDebugOutput().inc();
        cifBddSpec.settings.getDebugOutput().line(synthResult.getCtrlBehText());
        cifBddSpec.settings.getDebugOutput().inc();
        for (String string : cifBddSpec.getEdgesText(true)) {
            cifBddSpec.settings.getDebugOutput().line(string);
        }
        cifBddSpec.settings.getDebugOutput().dec();
        cifBddSpec.settings.getDebugOutput().dec();
    }

    private static void checkInput(CifBddSpec cifBddSpec, CifDataSynthesisResult synthResult) {
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return;
        }
        if (cifBddSpec.plantInv.isZero()) {
            cifBddSpec.settings.getWarnOutput().line("The uncontrolled system has no states (taking into account only the state plant invariants).");
        }
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return;
        }
        if (cifBddSpec.reqInv.isZero()) {
            cifBddSpec.settings.getWarnOutput().line("The controlled system has no states (taking into account only the state requirement invariants).");
        }
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return;
        }
        if (cifBddSpec.initial.isZero()) {
            cifBddSpec.settings.getWarnOutput().line("The uncontrolled system has no initial state (taking into account only initialization).");
        }
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return;
        }
        if (!cifBddSpec.initial.isZero() && !cifBddSpec.plantInv.isZero() && cifBddSpec.initialPlantInv.isZero()) {
            cifBddSpec.settings.getWarnOutput().line("The uncontrolled system has no initial state (taking into account only initialization and state plant invariants).");
        }
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return;
        }
        if (!(cifBddSpec.initialPlantInv.isZero() || cifBddSpec.initial.isZero() || cifBddSpec.plantInv.isZero() || cifBddSpec.reqInv.isZero() || !cifBddSpec.initialInv.isZero())) {
            cifBddSpec.settings.getWarnOutput().line("The controlled system has no initial state (taking into account both initialization and state invariants).");
        }
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return;
        }
        if (cifBddSpec.marked.isZero()) {
            cifBddSpec.settings.getWarnOutput().line("The uncontrolled system has no marked state (taking into account only marking).");
        }
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return;
        }
        if (!cifBddSpec.marked.isZero() && !cifBddSpec.plantInv.isZero() && cifBddSpec.markedPlantInv.isZero()) {
            cifBddSpec.settings.getWarnOutput().line("The uncontrolled system has no marked state (taking into account only marking and state plant invariants).");
        }
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return;
        }
        if (!(cifBddSpec.markedPlantInv.isZero() || cifBddSpec.marked.isZero() || cifBddSpec.plantInv.isZero() || cifBddSpec.reqInv.isZero() || !cifBddSpec.markedInv.isZero())) {
            cifBddSpec.settings.getWarnOutput().line("The controlled system has no marked state (taking into account both marking and state invariants).");
        }
        boolean freeReqsInvsCompsAndLocs = synthResult.settings.getStateReqInvEnforceMode() == StateReqInvEnforceMode.ALL_CTRL_BEH;
        cifBddSpec.freeIntermediateBDDs(freeReqsInvsCompsAndLocs);
    }

    private static void printDebugRuntimeErrorPrevention(CifBddSpec cifBddSpec, CifDataSynthesisResult synthResult) {
        List<CifBddEdge> restrictedEdges = cifBddSpec.edges.stream().filter(e -> !e.origGuard.equals((Object)e.guard)).toList();
        cifBddSpec.settings.getDebugOutput().line();
        cifBddSpec.settings.getDebugOutput().line("Restricting edge guards to prevent runtime errors:");
        cifBddSpec.settings.getDebugOutput().inc();
        if (restrictedEdges.isEmpty()) {
            cifBddSpec.settings.getDebugOutput().line("No guards changed.");
        } else {
            for (CifBddEdge restrictedEdge : restrictedEdges) {
                cifBddSpec.settings.getDebugOutput().line(restrictedEdge.toString("Edge: "));
            }
            cifBddSpec.settings.getDebugOutput().line();
            cifBddSpec.settings.getDebugOutput().line("Uncontrolled system:");
            cifBddSpec.settings.getDebugOutput().inc();
            cifBddSpec.settings.getDebugOutput().line(synthResult.getCtrlBehText());
            cifBddSpec.settings.getDebugOutput().inc();
            for (String line : cifBddSpec.getEdgesText()) {
                cifBddSpec.settings.getDebugOutput().line(line);
            }
            cifBddSpec.settings.getDebugOutput().dec();
            cifBddSpec.settings.getDebugOutput().dec();
        }
        cifBddSpec.settings.getDebugOutput().dec();
    }

    private static void applyStateReqInvs(CifBddSpec cifBddSpec, CifDataSynthesisResult synthResult, boolean dbgEnabled) {
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line();
            cifBddSpec.settings.getDebugOutput().line("Restricting behavior using state requirements:");
            cifBddSpec.settings.getDebugOutput().inc();
        }
        switch (synthResult.settings.getStateReqInvEnforceMode()) {
            case ALL_CTRL_BEH: {
                BDD newCtrlBeh = synthResult.ctrlBeh.and(cifBddSpec.reqInv);
                if (cifBddSpec.settings.getTermination().isRequested()) {
                    if (dbgEnabled) {
                        cifBddSpec.settings.getDebugOutput().dec();
                    }
                    return;
                }
                if (synthResult.ctrlBeh.equals((Object)newCtrlBeh)) {
                    newCtrlBeh.free();
                    if (!dbgEnabled) break;
                    cifBddSpec.settings.getDebugOutput().line("Controlled behavior not changed.");
                    break;
                }
                if (dbgEnabled) {
                    cifBddSpec.settings.getDebugOutput().line("Controlled behavior: %s -> %s [state requirements: %s].", new Object[]{BddUtils.bddToStr((BDD)synthResult.ctrlBeh, (CifBddSpec)cifBddSpec), BddUtils.bddToStr((BDD)newCtrlBeh, (CifBddSpec)cifBddSpec), BddUtils.bddToStr((BDD)cifBddSpec.reqInv, (CifBddSpec)cifBddSpec)});
                }
                synthResult.ctrlBeh.free();
                synthResult.ctrlBeh = newCtrlBeh;
                break;
            }
            case PER_EDGE: {
                List reqInvs = Lists.concat((List)cifBddSpec.reqInvsComps, (List)cifBddSpec.reqInvsLocs);
                Function<CifBddEdge, Stream<BDD>> reqsPerEdge = edge -> reqInvs.stream().map(reqInv -> {
                    BDD updPred = reqInv.id();
                    if ((updPred = edge.apply(updPred, CifBddEdgeApplyDirection.BACKWARD, null)).isOne()) {
                        return updPred;
                    }
                    if (cifBddSpec.settings.getTermination().isRequested()) {
                        return updPred;
                    }
                    BDD guardAndReqInv = cifBddEdge.guard.and(reqInv);
                    BDD implication = guardAndReqInv.imp(updPred);
                    boolean skip = implication.isOne();
                    guardAndReqInv.free();
                    implication.free();
                    if (skip) {
                        updPred.free();
                        updPred = cifBddSpec.factory.one();
                    }
                    return updPred;
                });
                CifDataSynthesis.applyReqsPerEdge(cifBddSpec, synthResult, reqsPerEdge, true, dbgEnabled, "state");
                BDD newInitialCtrl = synthResult.initialCtrl.and(cifBddSpec.reqInv);
                if (cifBddSpec.settings.getTermination().isRequested()) {
                    if (dbgEnabled) {
                        cifBddSpec.settings.getDebugOutput().dec();
                    }
                    return;
                }
                if (synthResult.initialCtrl.equals((Object)newInitialCtrl)) {
                    newInitialCtrl.free();
                    if (dbgEnabled) {
                        cifBddSpec.settings.getDebugOutput().line("Controlled-initialization not changed.");
                    }
                } else {
                    if (dbgEnabled) {
                        cifBddSpec.settings.getDebugOutput().line("Controlled initialization: %s -> %s [state requirements: %s].", new Object[]{BddUtils.bddToStr((BDD)synthResult.initialCtrl, (CifBddSpec)cifBddSpec), BddUtils.bddToStr((BDD)newInitialCtrl, (CifBddSpec)cifBddSpec), BddUtils.bddToStr((BDD)cifBddSpec.reqInv, (CifBddSpec)cifBddSpec)});
                    }
                    synthResult.initialCtrl.free();
                    synthResult.initialCtrl = newInitialCtrl;
                }
                for (BDD bdd : cifBddSpec.reqInvsComps) {
                    bdd.free();
                }
                for (BDD bdd : cifBddSpec.reqInvsLocs) {
                    bdd.free();
                }
                cifBddSpec.reqInvsComps = null;
                cifBddSpec.reqInvsLocs = null;
                break;
            }
            default: {
                throw new RuntimeException("Unknown mode: " + String.valueOf((Object)synthResult.settings.getStateReqInvEnforceMode()));
            }
        }
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().dec();
        }
    }

    private static void applyVarRanges(CifBddSpec cifBddSpec, CifDataSynthesisResult synthResult, boolean dbgEnabled) {
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line();
            cifBddSpec.settings.getDebugOutput().line("Extending controlled-behavior predicate using variable ranges:");
            cifBddSpec.settings.getDebugOutput().inc();
        }
        boolean changed = false;
        for (CifBddVariable var : cifBddSpec.variables) {
            if (cifBddSpec.settings.getTermination().isRequested()) {
                if (dbgEnabled) {
                    cifBddSpec.settings.getDebugOutput().dec();
                }
                return;
            }
            BDD range = BddUtils.getCifVarDomainBdd((CifBddVariable)var, (boolean)false, (BDDFactory)cifBddSpec.factory);
            if (cifBddSpec.settings.getTermination().isRequested()) {
                if (dbgEnabled) {
                    cifBddSpec.settings.getDebugOutput().dec();
                }
                return;
            }
            BDD newCtrlBeh = synthResult.ctrlBeh.and(range);
            if (cifBddSpec.settings.getTermination().isRequested()) {
                if (dbgEnabled) {
                    cifBddSpec.settings.getDebugOutput().dec();
                }
                return;
            }
            if (synthResult.ctrlBeh.equals((Object)newCtrlBeh)) {
                newCtrlBeh.free();
                range.free();
                continue;
            }
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().line("Controlled behavior: %s -> %s [range: %s, variable: %s].", new Object[]{BddUtils.bddToStr((BDD)synthResult.ctrlBeh, (CifBddSpec)cifBddSpec), BddUtils.bddToStr((BDD)newCtrlBeh, (CifBddSpec)cifBddSpec), BddUtils.bddToStr((BDD)range, (CifBddSpec)cifBddSpec), var.toString("")});
            }
            range.free();
            synthResult.ctrlBeh.free();
            synthResult.ctrlBeh = newCtrlBeh;
            changed = true;
        }
        if (cifBddSpec.settings.getTermination().isRequested()) {
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().dec();
            }
            return;
        }
        if (dbgEnabled) {
            if (changed) {
                cifBddSpec.settings.getDebugOutput().line();
                cifBddSpec.settings.getDebugOutput().line("Extended controlled-behavior predicate using variable ranges: %s.", new Object[]{BddUtils.bddToStr((BDD)synthResult.ctrlBeh, (CifBddSpec)cifBddSpec)});
            } else {
                cifBddSpec.settings.getDebugOutput().line("Controlled behavior not changed.");
            }
            cifBddSpec.settings.getDebugOutput().dec();
        }
    }

    private static void applyStateEvtExclReqs(CifBddSpec cifBddSpec, CifDataSynthesisResult synthResult, boolean dbgEnabled) {
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line();
            cifBddSpec.settings.getDebugOutput().line("Restricting behavior using state/event exclusion requirements:");
            cifBddSpec.settings.getDebugOutput().inc();
        }
        Function<CifBddEdge, Stream<BDD>> reqsPerEdge = edge -> {
            BDD req = (BDD)cifBddSpec.stateEvtExclReqs.get(edge.event);
            return req == null ? Stream.empty() : Stream.of(req);
        };
        CifDataSynthesis.applyReqsPerEdge(cifBddSpec, synthResult, reqsPerEdge, false, dbgEnabled, "state/event exclusion");
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().dec();
        }
        for (BDD bdd : cifBddSpec.stateEvtExclReqs.values()) {
            bdd.free();
        }
        cifBddSpec.stateEvtExclReqs = null;
    }

    private static void applyRuntimeErrorReqs(CifBddSpec cifBddSpec, CifDataSynthesisResult synthResult, boolean dbgEnabled) {
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line();
            cifBddSpec.settings.getDebugOutput().line("Restricting behavior using implicit runtime error requirements:");
            cifBddSpec.settings.getDebugOutput().inc();
        }
        boolean changed = false;
        for (CifBddEdge edge : cifBddSpec.edges) {
            if (cifBddSpec.settings.getTermination().isRequested()) {
                if (dbgEnabled) {
                    cifBddSpec.settings.getDebugOutput().dec();
                }
                return;
            }
            if (edge.event.getControllable().booleanValue()) continue;
            BDD guardError = edge.origGuard.and(edge.error);
            BDD guardErrorNot = guardError.not();
            guardError.free();
            BDD newCtrlBeh = synthResult.ctrlBeh.and(guardErrorNot);
            if (!newCtrlBeh.equals((Object)synthResult.ctrlBeh)) {
                if (dbgEnabled) {
                    cifBddSpec.settings.getDebugOutput().line("Controlled behavior: %s -> %s [runtime error requirement (event: %s): %s].", new Object[]{BddUtils.bddToStr((BDD)synthResult.ctrlBeh, (CifBddSpec)cifBddSpec), BddUtils.bddToStr((BDD)newCtrlBeh, (CifBddSpec)cifBddSpec), edge.event.getName(), BddUtils.bddToStr((BDD)guardErrorNot, (CifBddSpec)cifBddSpec)});
                }
                changed = true;
            }
            guardErrorNot.free();
            synthResult.ctrlBeh.free();
            synthResult.ctrlBeh = newCtrlBeh;
        }
        if (cifBddSpec.settings.getTermination().isRequested()) {
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().dec();
            }
            return;
        }
        if (dbgEnabled) {
            if (changed) {
                cifBddSpec.settings.getDebugOutput().line();
                cifBddSpec.settings.getDebugOutput().line("Restricted behavior using implicit runtime error requirements: %s.", new Object[]{BddUtils.bddToStr((BDD)synthResult.ctrlBeh, (CifBddSpec)cifBddSpec)});
            } else {
                cifBddSpec.settings.getDebugOutput().line("Controlled behavior not changed.");
            }
            cifBddSpec.settings.getDebugOutput().dec();
        }
    }

    private static void applyReqsPerEdge(CifBddSpec cifBddSpec, CifDataSynthesisResult synthResult, Function<CifBddEdge, Stream<BDD>> reqsPerEdge, boolean freeReqs, boolean dbgEnabled, String dbgDescription) {
        boolean changed = false;
        boolean guardChanged = false;
        for (CifBddEdge edge : cifBddSpec.edges) {
            if (cifBddSpec.settings.getTermination().isRequested()) {
                return;
            }
            Stream<BDD> reqsStream = reqsPerEdge.apply(edge);
            Iterable reqsIterable = () -> reqsStream.iterator();
            for (BDD req : reqsIterable) {
                if (cifBddSpec.settings.getTermination().isRequested()) {
                    return;
                }
                if (req.isOne()) continue;
                if (edge.event.getControllable().booleanValue()) {
                    BDD newGuard = edge.guard.and(req);
                    if (cifBddSpec.settings.getTermination().isRequested()) {
                        return;
                    }
                    if (edge.guard.equals((Object)newGuard)) {
                        newGuard.free();
                    } else {
                        if (dbgEnabled) {
                            cifBddSpec.settings.getDebugOutput().line("Edge %s: guard: %s -> %s [%s requirement: %s].", new Object[]{edge.toString(""), BddUtils.bddToStr((BDD)edge.guard, (CifBddSpec)cifBddSpec), BddUtils.bddToStr((BDD)newGuard, (CifBddSpec)cifBddSpec), dbgDescription, BddUtils.bddToStr((BDD)req, (CifBddSpec)cifBddSpec)});
                        }
                        edge.guard.free();
                        edge.guard = newGuard;
                        changed = true;
                        guardChanged = true;
                    }
                } else {
                    BDD reqGood = edge.guard.imp(req);
                    if (cifBddSpec.settings.getTermination().isRequested()) {
                        return;
                    }
                    BDD newCtrlBeh = synthResult.ctrlBeh.id().andWith(reqGood);
                    if (cifBddSpec.settings.getTermination().isRequested()) {
                        return;
                    }
                    if (synthResult.ctrlBeh.equals((Object)newCtrlBeh)) {
                        newCtrlBeh.free();
                    } else {
                        if (dbgEnabled) {
                            cifBddSpec.settings.getDebugOutput().line("Controlled behavior: %s -> %s [%s requirement: %s, edge: %s].", new Object[]{BddUtils.bddToStr((BDD)synthResult.ctrlBeh, (CifBddSpec)cifBddSpec), BddUtils.bddToStr((BDD)newCtrlBeh, (CifBddSpec)cifBddSpec), dbgDescription, BddUtils.bddToStr((BDD)req, (CifBddSpec)cifBddSpec), edge.toString("")});
                        }
                        synthResult.ctrlBeh.free();
                        synthResult.ctrlBeh = newCtrlBeh;
                        changed = true;
                    }
                }
                if (!freeReqs) continue;
                req.free();
            }
        }
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return;
        }
        if (dbgEnabled) {
            if (changed) {
                cifBddSpec.settings.getDebugOutput().line();
                cifBddSpec.settings.getDebugOutput().line("Restricted behavior using %s requirements:", new Object[]{dbgDescription});
                cifBddSpec.settings.getDebugOutput().inc();
                cifBddSpec.settings.getDebugOutput().line(synthResult.getCtrlBehText());
                if (guardChanged) {
                    cifBddSpec.settings.getDebugOutput().inc();
                    for (String line : cifBddSpec.getEdgesText()) {
                        cifBddSpec.settings.getDebugOutput().line(line);
                    }
                    cifBddSpec.settings.getDebugOutput().dec();
                }
                cifBddSpec.settings.getDebugOutput().dec();
            } else {
                cifBddSpec.settings.getDebugOutput().line("Guards and controlled behavior not changed.");
            }
        }
    }

    private static Set<Event> checkInputEdges(CifBddSpec cifBddSpec, boolean dbgEnabled) {
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line();
            cifBddSpec.settings.getDebugOutput().line("Checking pre-synthesis for events that are never enabled.");
        }
        Set disabledEvents = Sets.setc((int)cifBddSpec.alphabet.size());
        for (Event event : cifBddSpec.alphabet) {
            if (cifBddSpec.settings.getTermination().isRequested()) {
                return disabledEvents;
            }
            if (cifBddSpec.inputVarEvents.contains(event)) continue;
            if (cifBddSpec.eventEdges.get(event) == null) {
                disabledEvents.add(event);
                continue;
            }
            if (((BDD)cifBddSpec.stateEvtExclPlants.get(event)).isZero()) {
                cifBddSpec.settings.getWarnOutput().line("Event \"%s\" is never enabled in the input specification, taking into account only state/event exclusion plants.", new Object[]{CifTextUtils.getAbsName((PositionObject)event)});
                disabledEvents.add(event);
                continue;
            }
            if (event.getControllable().booleanValue() && ((BDD)cifBddSpec.stateEvtExclsReqInvs.get(event)).isZero()) {
                cifBddSpec.settings.getWarnOutput().line("Event \"%s\" is never enabled in the input specification, taking into account only state/event exclusion requirements.", new Object[]{CifTextUtils.getAbsName((PositionObject)event)});
                disabledEvents.add(event);
                continue;
            }
            if (((List)cifBddSpec.eventEdges.get(event)).stream().filter(edge -> !edge.origGuard.isZero()).count() == 0L) {
                cifBddSpec.settings.getWarnOutput().line("Event \"%s\" is never enabled in the input specification, taking into account only automaton guards.", new Object[]{CifTextUtils.getAbsName((PositionObject)event)});
                disabledEvents.add(event);
                continue;
            }
            boolean alwaysDisabled = true;
            for (CifBddEdge edge2 : (List)cifBddSpec.eventEdges.get(event)) {
                if (cifBddSpec.settings.getTermination().isRequested()) {
                    return disabledEvents;
                }
                BDD enabledExpression = edge2.guard.and(cifBddSpec.reqInv);
                if ((enabledExpression = enabledExpression.andWith(cifBddSpec.plantInv.id())).isZero()) continue;
                enabledExpression.free();
                alwaysDisabled = false;
                break;
            }
            if (!alwaysDisabled) continue;
            cifBddSpec.settings.getWarnOutput().line("Event \"%s\" is never enabled in the input specification, taking into account automaton guards, prevention of runtime errors, and invariants.", new Object[]{CifTextUtils.getAbsName((PositionObject)event)});
            disabledEvents.add(event);
        }
        return disabledEvents;
    }

    private static void prepareWorksetAlgorithm(CifBddSpec cifBddSpec, boolean forwardEnabled, boolean dbgEnabled) {
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line();
            cifBddSpec.settings.getDebugOutput().line("Preparing workset algorithm:");
            cifBddSpec.settings.getDebugOutput().inc();
        }
        BddBasedEdgeDependencySetCreator creator = new BddBasedEdgeDependencySetCreator();
        creator.createAndStore(cifBddSpec, forwardEnabled);
        if (dbgEnabled) {
            int edgeCnt = cifBddSpec.worksetDependenciesBackward.size();
            if (edgeCnt == 0) {
                cifBddSpec.settings.getDebugOutput().line("No edges.");
            } else {
                Object bitset;
                GridBox box;
                if (forwardEnabled) {
                    cifBddSpec.settings.getDebugOutput().line("Edge workset algorithm forward dependencies:");
                    box = new GridBox(edgeCnt, 4, 0, 1);
                    int i = 0;
                    while (i < edgeCnt) {
                        bitset = (BitSet)cifBddSpec.worksetDependenciesForward.get(i);
                        box.set(i, 0, "-");
                        box.set(i, 1, Integer.toString(i + 1) + ":");
                        box.set(i, 2, CifTextUtils.getAbsName((PositionObject)((CifBddEdge)cifBddSpec.orderedEdgesForward.get((int)i)).event));
                        box.set(i, 3, BitSets.bitsetToStr((BitSet)bitset, (int)edgeCnt));
                        ++i;
                    }
                    for (String line : box.getLines()) {
                        cifBddSpec.settings.getDebugOutput().line(line);
                    }
                }
                cifBddSpec.settings.getDebugOutput().line();
                cifBddSpec.settings.getDebugOutput().line("Edge workset algorithm backward dependencies:");
                box = new GridBox(edgeCnt, 4, 0, 1);
                int i = 0;
                while (i < edgeCnt) {
                    bitset = (BitSet)cifBddSpec.worksetDependenciesBackward.get(i);
                    box.set(i, 0, "-");
                    box.set(i, 1, Integer.toString(i + 1) + ":");
                    box.set(i, 2, CifTextUtils.getAbsName((PositionObject)((CifBddEdge)cifBddSpec.orderedEdgesBackward.get((int)i)).event));
                    box.set(i, 3, BitSets.bitsetToStr((BitSet)bitset, (int)edgeCnt));
                    ++i;
                }
                for (String line : box.getLines()) {
                    cifBddSpec.settings.getDebugOutput().line(line);
                }
            }
            cifBddSpec.settings.getDebugOutput().dec();
        }
    }

    private static void synthesizeFixedPoints(CifBddSpec cifBddSpec, CifDataSynthesisResult synthResult, boolean doForward, boolean dbgEnabled, boolean doTiming, CifDataSynthesisTiming timing) {
        int reachReqsIdxInOrder;
        List computationsInOrder = synthResult.settings.getFixedPointComputationsOrder().computations;
        if (!doForward) {
            computationsInOrder = computationsInOrder.stream().filter(c -> c != FixedPointComputation.REACH).toList();
        }
        Assert.check(((reachReqsIdxInOrder = computationsInOrder.indexOf((Object)FixedPointComputation.REACH_REQS)) >= 0 ? 1 : 0) != 0);
        computationsInOrder = Lists.concat((List[])new List[]{computationsInOrder.subList(0, reachReqsIdxInOrder), Collections.nCopies(cifBddSpec.reachReqPreds.size(), FixedPointComputation.REACH_REQS), computationsInOrder.subList(reachReqsIdxInOrder + 1, computationsInOrder.size())});
        int numberOfComputations = computationsInOrder.size();
        int round = 0;
        int stableCount = 0;
        block36: while (true) {
            ++round;
            if (cifBddSpec.settings.getTermination().isRequested()) {
                return;
            }
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().line();
                cifBddSpec.settings.getDebugOutput().line("Synthesis round %d:", new Object[]{round});
                cifBddSpec.settings.getDebugOutput().inc();
            }
            boolean firstComputationInRound = true;
            int reachReqIdx = 0;
            int computationIdx = 0;
            while (computationIdx < numberOfComputations) {
                boolean changed;
                BDD newCtrlBeh;
                BDD reachabilityResult;
                EnumSet<CifBddEdgeKind> edgeKinds;
                CifBddEdgeApplyDirection direction;
                BDD restriction;
                String restrictionName;
                String initName;
                String predName;
                FixedPointComputation fixedPointComputation = (FixedPointComputation)((Object)computationsInOrder.get(computationIdx));
                BDD startPred = switch (fixedPointComputation) {
                    case FixedPointComputation.NONBLOCK -> cifBddSpec.marked.id();
                    case FixedPointComputation.REACH_REQS -> ((BDD)cifBddSpec.reachReqPreds.get(reachReqIdx)).id();
                    case FixedPointComputation.CTRL -> synthResult.ctrlBeh.not();
                    case FixedPointComputation.REACH -> synthResult.initialCtrl.id();
                    default -> throw new MatchException(null, null);
                };
                if (cifBddSpec.settings.getTermination().isRequested()) {
                    if (dbgEnabled) {
                        cifBddSpec.settings.getDebugOutput().dec();
                    }
                    return;
                }
                int saturationInstanceNumber = switch (fixedPointComputation) {
                    case FixedPointComputation.NONBLOCK -> {
                        predName = "non-blocking states";
                        initName = "marker";
                        restrictionName = "current/previous controlled-behavior";
                        restriction = synthResult.ctrlBeh;
                        direction = CifBddEdgeApplyDirection.BACKWARD;
                        edgeKinds = EnumSet.allOf(CifBddEdgeKind.class);
                        yield 0;
                    }
                    case FixedPointComputation.REACH_REQS -> {
                        predName = Strings.fmt((String)"states satisfying reachability requirement %,d/%,d", (Object[])new Object[]{reachReqIdx + 1, cifBddSpec.reachReqPreds.size()});
                        initName = Strings.fmt((String)"reachability requirement %,d/%,d", (Object[])new Object[]{reachReqIdx + 1, cifBddSpec.reachReqPreds.size()});
                        restrictionName = "current/previous controlled-behavior";
                        restriction = synthResult.ctrlBeh;
                        direction = CifBddEdgeApplyDirection.BACKWARD;
                        edgeKinds = EnumSet.allOf(CifBddEdgeKind.class);
                        yield 0;
                    }
                    case FixedPointComputation.CTRL -> {
                        predName = "bad + uncontrollable states";
                        initName = "current/previous bad states";
                        restrictionName = null;
                        restriction = null;
                        direction = CifBddEdgeApplyDirection.BACKWARD;
                        edgeKinds = EnumSet.of(CifBddEdgeKind.UNCONTROLLABLE, CifBddEdgeKind.INPUT_VARIABLE);
                        yield 1;
                    }
                    case FixedPointComputation.REACH -> {
                        predName = "reachable states";
                        initName = "initialization";
                        restrictionName = "current/previous controlled-behavior";
                        restriction = synthResult.ctrlBeh;
                        direction = CifBddEdgeApplyDirection.FORWARD;
                        edgeKinds = EnumSet.allOf(CifBddEdgeKind.class);
                        yield 2;
                    }
                    default -> throw new RuntimeException("Unknown fixed-point computation: " + String.valueOf((Object)fixedPointComputation));
                };
                if (doTiming) {
                    Stopwatch stopwatch = switch (fixedPointComputation) {
                        case FixedPointComputation.NONBLOCK -> timing.mainNonBlock;
                        case FixedPointComputation.REACH_REQS -> timing.mainReachReqs;
                        case FixedPointComputation.CTRL -> timing.mainCtrl;
                        case FixedPointComputation.REACH -> timing.mainReach;
                        default -> throw new MatchException(null, null);
                    };
                    stopwatch.start();
                }
                if (dbgEnabled) {
                    if (firstComputationInRound) {
                        firstComputationInRound = false;
                    } else {
                        cifBddSpec.settings.getDebugOutput().line();
                    }
                    cifBddSpec.settings.getDebugOutput().line("Computing %s predicate:", new Object[]{predName});
                    cifBddSpec.settings.getDebugOutput().inc();
                }
                try {
                    CifBddReachability reachability = new CifBddReachability(cifBddSpec, predName, initName, restrictionName, restriction, direction, edgeKinds, dbgEnabled);
                    if (cifBddSpec.settings.getExplorationStrategy() == ExplorationStrategy.SATURATION) {
                        reachability.setSaturationInstance(saturationInstanceNumber);
                    }
                    reachabilityResult = reachability.performReachability(startPred);
                }
                catch (Throwable throwable) {
                    if (doTiming) {
                        Stopwatch stopwatch = switch (fixedPointComputation) {
                            case FixedPointComputation.NONBLOCK -> timing.mainNonBlock;
                            case FixedPointComputation.REACH_REQS -> timing.mainReachReqs;
                            case FixedPointComputation.CTRL -> timing.mainCtrl;
                            case FixedPointComputation.REACH -> timing.mainReach;
                            default -> throw new MatchException(null, null);
                        };
                        stopwatch.stop();
                    }
                    throw throwable;
                }
                if (doTiming) {
                    Stopwatch stopwatch = switch (fixedPointComputation) {
                        case FixedPointComputation.NONBLOCK -> timing.mainNonBlock;
                        case FixedPointComputation.REACH_REQS -> timing.mainReachReqs;
                        case FixedPointComputation.CTRL -> timing.mainCtrl;
                        case FixedPointComputation.REACH -> timing.mainReach;
                        default -> throw new MatchException(null, null);
                    };
                    stopwatch.stop();
                }
                if (cifBddSpec.settings.getTermination().isRequested()) {
                    if (dbgEnabled) {
                        cifBddSpec.settings.getDebugOutput().dec();
                        cifBddSpec.settings.getDebugOutput().dec();
                    }
                    return;
                }
                switch (fixedPointComputation) {
                    case NONBLOCK: 
                    case REACH: 
                    case REACH_REQS: {
                        newCtrlBeh = reachabilityResult;
                        break;
                    }
                    case CTRL: {
                        newCtrlBeh = reachabilityResult.not();
                        reachabilityResult.free();
                        if (!cifBddSpec.settings.getTermination().isRequested()) break;
                        if (dbgEnabled) {
                            cifBddSpec.settings.getDebugOutput().dec();
                            cifBddSpec.settings.getDebugOutput().dec();
                        }
                        return;
                    }
                    default: {
                        throw new RuntimeException("Unknown fixed-point computation: " + String.valueOf((Object)fixedPointComputation));
                    }
                }
                boolean unchanged = synthResult.ctrlBeh.equals((Object)newCtrlBeh);
                boolean bl = changed = !unchanged;
                if (unchanged) {
                    newCtrlBeh.free();
                    ++stableCount;
                    if (dbgEnabled) {
                        cifBddSpec.settings.getDebugOutput().line();
                        cifBddSpec.settings.getDebugOutput().line("Controlled behavior not changed.");
                    }
                } else {
                    if (dbgEnabled) {
                        cifBddSpec.settings.getDebugOutput().line();
                        cifBddSpec.settings.getDebugOutput().line("Controlled behavior: %s -> %s.", new Object[]{BddUtils.bddToStr((BDD)synthResult.ctrlBeh, (CifBddSpec)cifBddSpec), BddUtils.bddToStr((BDD)newCtrlBeh, (CifBddSpec)cifBddSpec)});
                    }
                    synthResult.ctrlBeh.free();
                    synthResult.ctrlBeh = newCtrlBeh;
                    stableCount = 1;
                }
                if (dbgEnabled) {
                    cifBddSpec.settings.getDebugOutput().dec();
                }
                BDD ctrlStates = synthResult.ctrlBeh.and(cifBddSpec.plantInv);
                boolean noCtrlStates = ctrlStates.isZero();
                ctrlStates.free();
                if (noCtrlStates) {
                    if (!dbgEnabled) break block36;
                    cifBddSpec.settings.getDebugOutput().line();
                    cifBddSpec.settings.getDebugOutput().line("Finished: all states are bad.");
                    cifBddSpec.settings.getDebugOutput().dec();
                    break block36;
                }
                if (cifBddSpec.settings.getTermination().isRequested()) {
                    if (dbgEnabled) {
                        cifBddSpec.settings.getDebugOutput().dec();
                    }
                    return;
                }
                if (stableCount == numberOfComputations) {
                    if (!dbgEnabled) break block36;
                    cifBddSpec.settings.getDebugOutput().line();
                    cifBddSpec.settings.getDebugOutput().line("Finished: controlled behavior is stable.");
                    cifBddSpec.settings.getDebugOutput().dec();
                    break block36;
                }
                if (changed && fixedPointComputation != FixedPointComputation.REACH) {
                    BDD init = synthResult.initialCtrl.and(synthResult.ctrlBeh);
                    boolean noInit = init.isZero();
                    init.free();
                    if (noInit) {
                        if (!dbgEnabled) break block36;
                        cifBddSpec.settings.getDebugOutput().line();
                        cifBddSpec.settings.getDebugOutput().line("Finished: no initialization possible.");
                        cifBddSpec.settings.getDebugOutput().dec();
                        break block36;
                    }
                    if (cifBddSpec.settings.getTermination().isRequested()) {
                        if (dbgEnabled) {
                            cifBddSpec.settings.getDebugOutput().dec();
                        }
                        return;
                    }
                }
                if (fixedPointComputation == FixedPointComputation.REACH_REQS) {
                    ++reachReqIdx;
                }
                ++computationIdx;
            }
            if (!dbgEnabled) continue;
            cifBddSpec.settings.getDebugOutput().line();
            cifBddSpec.settings.getDebugOutput().line("Need another round.", new Object[]{round});
            cifBddSpec.settings.getDebugOutput().dec();
        }
    }

    private static void determineCtrlSysGuards(CifBddSpec cifBddSpec, CifDataSynthesisResult synthResult, boolean dbgEnabled) {
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line();
            cifBddSpec.settings.getDebugOutput().line("Computing final controlled system guards:");
            cifBddSpec.settings.getDebugOutput().inc();
        }
        boolean guardUpdated = false;
        for (CifBddEdge edge : cifBddSpec.edges) {
            if (!edge.event.getControllable().booleanValue()) continue;
            if (cifBddSpec.settings.getTermination().isRequested()) {
                if (dbgEnabled) {
                    cifBddSpec.settings.getDebugOutput().dec();
                }
                return;
            }
            BDD updPred = synthResult.ctrlBeh.id();
            updPred = edge.apply(updPred, CifBddEdgeApplyDirection.BACKWARD, null);
            edge.cleanupApply();
            if (cifBddSpec.settings.getTermination().isRequested()) {
                if (dbgEnabled) {
                    cifBddSpec.settings.getDebugOutput().dec();
                }
                return;
            }
            BDD newGuard = edge.guard.id().andWith(updPred);
            if (cifBddSpec.settings.getTermination().isRequested()) {
                if (dbgEnabled) {
                    cifBddSpec.settings.getDebugOutput().dec();
                }
                return;
            }
            if (edge.guard.equals((Object)newGuard)) {
                newGuard.free();
                continue;
            }
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().line("Edge %s: guard: %s -> %s.", new Object[]{edge.toString(""), BddUtils.bddToStr((BDD)edge.guard, (CifBddSpec)cifBddSpec), BddUtils.bddToStr((BDD)newGuard, (CifBddSpec)cifBddSpec)});
            }
            edge.guard.free();
            edge.guard = newGuard;
            guardUpdated = true;
        }
        if (dbgEnabled) {
            if (!guardUpdated) {
                cifBddSpec.settings.getDebugOutput().line("No guards changed.");
            }
            cifBddSpec.settings.getDebugOutput().dec();
        }
    }

    private static void determineCtrlSysInit(CifBddSpec cifBddSpec, CifDataSynthesisResult synthResult, boolean dbgEnabled) {
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line();
            cifBddSpec.settings.getDebugOutput().line("Computing initialization predicate of the controlled system.");
        }
        synthResult.initialCtrl = synthResult.initialCtrl.andWith(synthResult.ctrlBeh.id());
        if (synthResult.settings.doFree(CifDataSynthesisFree.SPEC_INITIAL_PLANT_INV)) {
            cifBddSpec.initialPlantInv = BddUtils.free((BDD)cifBddSpec.initialPlantInv);
        }
    }

    private static boolean checkInitStatePresent(CifDataSynthesisResult synthResult) {
        boolean emptySup = synthResult.initialCtrl.isZero();
        return !emptySup;
    }

    private static void printNumberStates(CifBddSpec cifBddSpec, CifDataSynthesisResult synthResult, boolean emptySup, boolean doForward, boolean dbgEnabled) {
        boolean isExact;
        BigInteger nr;
        if (emptySup) {
            nr = BigInteger.ZERO;
        } else if (cifBddSpec.variables.isEmpty()) {
            Assert.check((synthResult.ctrlBeh.isZero() || synthResult.ctrlBeh.isOne() ? 1 : 0) != 0);
            nr = synthResult.ctrlBeh.isOne() ? BigInteger.ONE : BigInteger.ZERO;
        } else {
            nr = synthResult.ctrlBeh.satCount(cifBddSpec.varSetOld);
        }
        Assert.check((emptySup || nr.compareTo(BigInteger.ZERO) > 0 ? 1 : 0) != 0);
        boolean bl = isExact = emptySup || doForward;
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line();
        }
        synthResult.settings.getNormalOutput().line("Controlled system: %s %,d state%s.", new Object[]{isExact ? "exactly" : "at most", nr, nr.equals(BigInteger.ONE) ? "" : "s"});
    }

    private static void determineOutputInitial(CifBddSpec cifBddSpec, CifDataSynthesisResult synthResult, boolean dbgEnabled) {
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line();
            cifBddSpec.settings.getDebugOutput().line("Determining initialization predicate for output model:");
            cifBddSpec.settings.getDebugOutput().inc();
            cifBddSpec.settings.getDebugOutput().line("Initial (synthesis result):            %s", new Object[]{BddUtils.bddToStr((BDD)synthResult.ctrlBeh, (CifBddSpec)cifBddSpec)});
            cifBddSpec.settings.getDebugOutput().line("Initial (uncontrolled system):         %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.initial, (CifBddSpec)cifBddSpec)});
            cifBddSpec.settings.getDebugOutput().line("Initial (controlled system):           %s", new Object[]{BddUtils.bddToStr((BDD)synthResult.initialCtrl, (CifBddSpec)cifBddSpec)});
        }
        if (cifBddSpec.settings.getTermination().isRequested()) {
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().dec();
            }
            return;
        }
        BDD initialRemoved = cifBddSpec.initial.id().andWith(synthResult.initialCtrl.not());
        if (cifBddSpec.settings.getTermination().isRequested()) {
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().dec();
            }
            return;
        }
        BDD initialAdded = initialRemoved.not();
        if (cifBddSpec.settings.getTermination().isRequested()) {
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().dec();
            }
            return;
        }
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line("Initial (removed by supervisor):       %s", new Object[]{BddUtils.bddToStr((BDD)initialRemoved, (CifBddSpec)cifBddSpec)});
            cifBddSpec.settings.getDebugOutput().line("Initial (added by supervisor):         %s", new Object[]{BddUtils.bddToStr((BDD)initialAdded, (CifBddSpec)cifBddSpec)});
        }
        if (cifBddSpec.settings.getTermination().isRequested()) {
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().dec();
            }
            return;
        }
        Set<BddSimplify> simplifications = synthResult.settings.getBddSimplifications();
        List assumptionTxts = Lists.list();
        if (!initialRemoved.isZero()) {
            BDD extra;
            synthResult.initialOutput = synthResult.initialCtrl.id();
            BDD assumption = cifBddSpec.factory.one();
            if (cifBddSpec.settings.getTermination().isRequested()) {
                if (dbgEnabled) {
                    cifBddSpec.settings.getDebugOutput().dec();
                }
                return;
            }
            if (simplifications.contains((Object)BddSimplify.INITIAL_UNCTRL)) {
                assumptionTxts.add("uncontrolled system initialization predicates");
                extra = cifBddSpec.initial.id();
                assumption = assumption.andWith(extra);
            }
            if (cifBddSpec.settings.getTermination().isRequested()) {
                if (dbgEnabled) {
                    cifBddSpec.settings.getDebugOutput().dec();
                }
                return;
            }
            if (simplifications.contains((Object)BddSimplify.INITIAL_STATE_PLANT_INVS)) {
                assumptionTxts.add("state plant invariants");
                extra = cifBddSpec.plantInv.id();
                assumption = assumption.andWith(extra);
            }
            if (!assumptionTxts.isEmpty()) {
                if (cifBddSpec.settings.getTermination().isRequested()) {
                    if (dbgEnabled) {
                        cifBddSpec.settings.getDebugOutput().dec();
                    }
                    return;
                }
                String assumptionsTxt = CifDataSynthesis.combineAssumptionTexts(assumptionTxts);
                if (dbgEnabled) {
                    cifBddSpec.settings.getDebugOutput().line();
                    cifBddSpec.settings.getDebugOutput().line("Simplifying of controlled system initialization predicate under the assumption of the %s:", new Object[]{assumptionsTxt});
                    cifBddSpec.settings.getDebugOutput().inc();
                }
                BDD newInitial = synthResult.initialOutput.simplify(assumption);
                if (cifBddSpec.settings.getTermination().isRequested()) {
                    if (dbgEnabled) {
                        cifBddSpec.settings.getDebugOutput().dec();
                        cifBddSpec.settings.getDebugOutput().dec();
                    }
                    return;
                }
                if (dbgEnabled) {
                    if (synthResult.initialOutput.equals((Object)newInitial)) {
                        cifBddSpec.settings.getDebugOutput().line("Predicate not changed.");
                    } else {
                        cifBddSpec.settings.getDebugOutput().line("Initial: %s -> %s [assume %s].", new Object[]{BddUtils.bddToStr((BDD)synthResult.initialOutput, (CifBddSpec)cifBddSpec), BddUtils.bddToStr((BDD)newInitial, (CifBddSpec)cifBddSpec), BddUtils.bddToStr((BDD)assumption, (CifBddSpec)cifBddSpec)});
                    }
                    cifBddSpec.settings.getDebugOutput().dec();
                }
                synthResult.initialOutput.free();
                synthResult.initialOutput = newInitial;
            }
            assumption.free();
        }
        if (cifBddSpec.settings.getTermination().isRequested()) {
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().dec();
            }
            return;
        }
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line();
            cifBddSpec.settings.getDebugOutput().line("Initial (output model):                %s", new Object[]{synthResult.initialOutput == null ? "n/a" : BddUtils.bddToStr((BDD)synthResult.initialOutput, (CifBddSpec)cifBddSpec)});
            cifBddSpec.settings.getDebugOutput().dec();
        }
        if (cifBddSpec.settings.getTermination().isRequested()) {
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().dec();
            }
            return;
        }
        if (synthResult.settings.doFree(CifDataSynthesisFree.RESULT_INITIAL_CTRL)) {
            synthResult.initialCtrl = BddUtils.free((BDD)synthResult.initialCtrl);
        }
        cifBddSpec.initial = BddUtils.free((BDD)cifBddSpec.initial);
        initialRemoved.free();
        initialAdded.free();
    }

    private static Map<Event, BDD> determineGuards(CifBddSpec cifBddSpec, CifDataSynthesisSettings settings, Set<Event> events, boolean useOrigGuards) {
        Map guards = Maps.mapc((int)events.size());
        for (Event event : events) {
            guards.put(event, cifBddSpec.factory.zero());
        }
        for (CifBddEdge cifBddEdge : cifBddSpec.edges) {
            BDD edgeGuard;
            if (!events.contains(cifBddEdge.event)) continue;
            if (cifBddSpec.settings.getTermination().isRequested()) {
                return null;
            }
            BDD guard = (BDD)guards.get(cifBddEdge.event);
            if (useOrigGuards) {
                edgeGuard = cifBddEdge.origGuard;
                if (settings.doKeep(CifDataSynthesisFree.EDGE_ORIG_GUARD)) {
                    edgeGuard = edgeGuard.id();
                }
            } else {
                edgeGuard = cifBddEdge.guard;
                if (settings.doKeep(CifDataSynthesisFree.EDGE_GUARD)) {
                    edgeGuard = edgeGuard.id();
                }
            }
            guard = guard.orWith(edgeGuard);
            guards.put(cifBddEdge.event, guard);
        }
        return guards;
    }

    private static void checkOutputEdges(CifBddSpec cifBddSpec, Set<Event> disabledEvents, CifDataSynthesisResult synthResult, Map<Event, BDD> ctrlGuards, boolean dbgEnabled) {
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line();
            cifBddSpec.settings.getDebugOutput().line("Checking post-synthesis for events that are never enabled.");
        }
        Set uncontrollables = Sets.difference((Collection)cifBddSpec.alphabet, (Collection[])new Collection[]{cifBddSpec.controllables, cifBddSpec.inputVarEvents});
        Map<Event, BDD> unctrlGuards = CifDataSynthesis.determineGuards(cifBddSpec, synthResult.settings, uncontrollables, false);
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return;
        }
        CifDataSynthesis.warnEventsDisabled(cifBddSpec, disabledEvents, synthResult, ctrlGuards);
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return;
        }
        CifDataSynthesis.warnEventsDisabled(cifBddSpec, disabledEvents, synthResult, unctrlGuards);
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return;
        }
        for (BDD bdd : unctrlGuards.values()) {
            bdd.free();
        }
    }

    private static void warnEventsDisabled(CifBddSpec cifBddSpec, Set<Event> disabledEvents, CifDataSynthesisResult synthResult, Map<Event, BDD> guards) {
        BDD ctrlBehPlantInv = synthResult.ctrlBeh.and(cifBddSpec.plantInv);
        for (Event event : guards.keySet()) {
            if (cifBddSpec.settings.getTermination().isRequested()) {
                return;
            }
            BDD ctrlBehGuard = guards.get(event).and(ctrlBehPlantInv);
            if (ctrlBehGuard.isZero() && !disabledEvents.contains(event)) {
                cifBddSpec.settings.getWarnOutput().line("Event \"%s\" is disabled in the controlled system.", new Object[]{CifTextUtils.getAbsName((PositionObject)event)});
                disabledEvents.add(event);
                continue;
            }
            ctrlBehGuard.free();
        }
        ctrlBehPlantInv.free();
    }

    private static void determineOutputGuards(CifBddSpec cifBddSpec, CifDataSynthesisResult synthResult, Map<Event, BDD> ctrlGuards, boolean dbgEnabled) {
        BDD extra;
        BDD assumption;
        Set<BddSimplify> simplifications = synthResult.settings.getBddSimplifications();
        List assumptionTxts = Lists.list();
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line();
            cifBddSpec.settings.getDebugOutput().line("Simplifying supervisor guards for output model:");
            cifBddSpec.settings.getDebugOutput().inc();
        }
        Map assumptions = Maps.mapc((int)cifBddSpec.controllables.size());
        for (Event controllable : cifBddSpec.controllables) {
            assumptions.put(controllable, cifBddSpec.factory.one());
        }
        if (cifBddSpec.settings.getTermination().isRequested()) {
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().dec();
            }
            return;
        }
        if (simplifications.contains((Object)BddSimplify.GUARDS_PLANTS)) {
            assumptionTxts.add("plants");
            Map<Event, BDD> unctrlGuards = CifDataSynthesis.determineGuards(cifBddSpec, synthResult.settings, cifBddSpec.controllables, true);
            if (cifBddSpec.settings.getTermination().isRequested()) {
                if (dbgEnabled) {
                    cifBddSpec.settings.getDebugOutput().dec();
                }
                return;
            }
            for (Event controllable : cifBddSpec.controllables) {
                BDD assumption2 = (BDD)assumptions.get(controllable);
                BDD extra2 = unctrlGuards.get(controllable);
                if (cifBddSpec.settings.getTermination().isRequested()) {
                    if (dbgEnabled) {
                        cifBddSpec.settings.getDebugOutput().dec();
                    }
                    return;
                }
                assumption2 = assumption2.andWith(extra2);
                assumptions.put(controllable, assumption2);
            }
        }
        if (cifBddSpec.settings.getTermination().isRequested()) {
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().dec();
            }
            return;
        }
        if (simplifications.contains((Object)BddSimplify.GUARDS_REQ_AUTS)) {
            assumptionTxts.add("requirement automata");
            for (Event controllable : cifBddSpec.controllables) {
                assumption = (BDD)assumptions.get(controllable);
                extra = (BDD)cifBddSpec.stateEvtExclsReqAuts.get(controllable);
                if (cifBddSpec.settings.getTermination().isRequested()) {
                    if (dbgEnabled) {
                        cifBddSpec.settings.getDebugOutput().dec();
                    }
                    return;
                }
                assumption = assumption.andWith(extra);
                assumptions.put(controllable, assumption);
            }
        }
        cifBddSpec.stateEvtExclsReqAuts = null;
        if (cifBddSpec.settings.getTermination().isRequested()) {
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().dec();
            }
            return;
        }
        if (simplifications.contains((Object)BddSimplify.GUARDS_SE_EXCL_PLANT_INVS)) {
            assumptionTxts.add("state/event exclusion plant invariants");
            for (Event controllable : cifBddSpec.controllables) {
                assumption = (BDD)assumptions.get(controllable);
                extra = (BDD)cifBddSpec.stateEvtExclPlants.get(controllable);
                if (cifBddSpec.settings.getTermination().isRequested()) {
                    if (dbgEnabled) {
                        cifBddSpec.settings.getDebugOutput().dec();
                    }
                    return;
                }
                assumption = assumption.andWith(extra);
                assumptions.put(controllable, assumption);
            }
        }
        cifBddSpec.stateEvtExclPlants = null;
        if (cifBddSpec.settings.getTermination().isRequested()) {
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().dec();
            }
            return;
        }
        if (simplifications.contains((Object)BddSimplify.GUARDS_SE_EXCL_REQ_INVS)) {
            assumptionTxts.add("state/event exclusion requirement invariants");
            for (Event controllable : cifBddSpec.controllables) {
                assumption = (BDD)assumptions.get(controllable);
                extra = (BDD)cifBddSpec.stateEvtExclsReqInvs.get(controllable);
                if (cifBddSpec.settings.getTermination().isRequested()) {
                    if (dbgEnabled) {
                        cifBddSpec.settings.getDebugOutput().dec();
                    }
                    return;
                }
                assumption = assumption.andWith(extra);
                assumptions.put(controllable, assumption);
            }
        }
        cifBddSpec.stateEvtExclsReqInvs = null;
        if (cifBddSpec.settings.getTermination().isRequested()) {
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().dec();
            }
            return;
        }
        if (simplifications.contains((Object)BddSimplify.GUARDS_STATE_PLANT_INVS)) {
            assumptionTxts.add("state plant invariants");
            for (Event controllable : cifBddSpec.controllables) {
                assumption = (BDD)assumptions.get(controllable);
                extra = cifBddSpec.plantInv.id();
                if (cifBddSpec.settings.getTermination().isRequested()) {
                    if (dbgEnabled) {
                        cifBddSpec.settings.getDebugOutput().dec();
                    }
                    return;
                }
                assumption = assumption.andWith(extra);
                assumptions.put(controllable, assumption);
            }
        }
        cifBddSpec.plantInv = BddUtils.free((BDD)cifBddSpec.plantInv);
        if (cifBddSpec.settings.getTermination().isRequested()) {
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().dec();
            }
            return;
        }
        if (simplifications.contains((Object)BddSimplify.GUARDS_STATE_REQ_INVS)) {
            assumptionTxts.add("state requirement invariants");
            for (Event controllable : cifBddSpec.controllables) {
                assumption = (BDD)assumptions.get(controllable);
                extra = cifBddSpec.reqInv.id();
                if (cifBddSpec.settings.getTermination().isRequested()) {
                    if (dbgEnabled) {
                        cifBddSpec.settings.getDebugOutput().dec();
                    }
                    return;
                }
                assumption = assumption.andWith(extra);
                assumptions.put(controllable, assumption);
            }
        }
        cifBddSpec.reqInv = BddUtils.free((BDD)cifBddSpec.reqInv);
        if (cifBddSpec.settings.getTermination().isRequested()) {
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().dec();
            }
            return;
        }
        if (simplifications.contains((Object)BddSimplify.GUARDS_CTRL_BEH)) {
            assumptionTxts.add("controlled behavior");
            for (Event controllable : cifBddSpec.controllables) {
                assumption = (BDD)assumptions.get(controllable);
                extra = synthResult.ctrlBeh.id();
                if (cifBddSpec.settings.getTermination().isRequested()) {
                    if (dbgEnabled) {
                        cifBddSpec.settings.getDebugOutput().dec();
                    }
                    return;
                }
                assumption = assumption.andWith(extra);
                assumptions.put(controllable, assumption);
            }
        }
        if (synthResult.settings.doFree(CifDataSynthesisFree.RESULT_CTRL_BEH)) {
            synthResult.ctrlBeh = BddUtils.free((BDD)synthResult.ctrlBeh);
        }
        if (cifBddSpec.settings.getTermination().isRequested()) {
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().dec();
            }
            return;
        }
        synthResult.outputGuards = ctrlGuards;
        if (assumptionTxts.isEmpty()) {
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().line("No simplifications enabled.");
                cifBddSpec.settings.getDebugOutput().dec();
            }
            return;
        }
        if (cifBddSpec.settings.getTermination().isRequested()) {
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().dec();
            }
            return;
        }
        if (dbgEnabled) {
            String assumptionsTxt = CifDataSynthesis.combineAssumptionTexts(assumptionTxts);
            cifBddSpec.settings.getDebugOutput().line("Simplification under the assumption of the %s.", new Object[]{assumptionsTxt});
            cifBddSpec.settings.getDebugOutput().line();
        }
        CifDataSynthesis.simplifyOutputGuards(cifBddSpec, synthResult, dbgEnabled, assumptions);
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().dec();
        }
    }

    private static String combineAssumptionTexts(List<String> texts) {
        if (texts.size() == 0) {
            return "";
        }
        if (texts.size() == 1) {
            return texts.get(0);
        }
        StringBuilder txt = new StringBuilder();
        int i = 0;
        while (i < texts.size()) {
            if (i > 0) {
                if (texts.size() > 2) {
                    txt.append(",");
                }
                txt.append(" ");
            }
            if (i == texts.size() - 1) {
                txt.append("and ");
            }
            txt.append(texts.get(i));
            ++i;
        }
        return txt.toString();
    }

    private static void simplifyOutputGuards(CifBddSpec cifBddSpec, CifDataSynthesisResult synthResult, boolean dbgEnabled, Map<Event, BDD> assumptions) {
        boolean guardChanged = false;
        for (Event controllable : cifBddSpec.controllables) {
            if (cifBddSpec.settings.getTermination().isRequested()) {
                return;
            }
            BDD guard = synthResult.outputGuards.get(controllable);
            BDD assumption = assumptions.get(controllable);
            BDD newGuard = assumption.isZero() && guard.isZero() ? cifBddSpec.factory.one() : guard.simplify(assumption);
            if (cifBddSpec.settings.getTermination().isRequested()) {
                return;
            }
            synthResult.outputGuards.put(controllable, newGuard);
            if (dbgEnabled && !guard.equals((Object)newGuard)) {
                cifBddSpec.settings.getDebugOutput().line("Event %s: guard: %s -> %s [assume %s].", new Object[]{CifTextUtils.getAbsName((PositionObject)controllable), BddUtils.bddToStr((BDD)guard, (CifBddSpec)cifBddSpec), BddUtils.bddToStr((BDD)newGuard, (CifBddSpec)cifBddSpec), BddUtils.bddToStr((BDD)assumption, (CifBddSpec)cifBddSpec)});
                guardChanged = true;
            }
            if (cifBddSpec.settings.getTermination().isRequested()) {
                return;
            }
            assumption.free();
            guard.free();
        }
        if (!guardChanged) {
            cifBddSpec.settings.getDebugOutput().line("Guards not changed.");
        }
    }
}

