/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.analysis;

import org.eclipse.escet.cif.eventbased.apps.SynthesisAnalysisEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AnalysisSearchHandler
implements SelectionListener,
VerifyListener {
    private SynthesisAnalysisEditor app = null;
    private Button initialState;
    private Button backButton;
    private Button searchButton;
    private Button showFullState;
    private Button showControllables;
    private Button showPlantRemoveds;
    private Text numberStates;

    public AnalysisSearchHandler(Composite root) {
        Composite comp = new Composite(root, 0);
        GridLayout compGrid = new GridLayout(4, false);
        comp.setLayout((Layout)compGrid);
        int numberSettings = 4;
        this.initialState = new Button(comp, 8);
        this.initialState.setText("Jump to initial state");
        GridData gridData = new GridData(4, 4, false, false);
        gridData.verticalSpan = 1;
        this.initialState.setLayoutData((Object)gridData);
        this.initialState.addSelectionListener((SelectionListener)this);
        Label lbl = new Label(comp, 0x1000000);
        gridData = new GridData(4, 4, true, false);
        gridData.minimumWidth = 50;
        gridData.verticalSpan = 4;
        lbl.setLayoutData((Object)gridData);
        this.showFullState = new Button(comp, 32);
        this.showFullState.setText("Display full state");
        this.showFullState.setSelection(false);
        gridData = new GridData(4, 4, false, false);
        gridData.horizontalSpan = 2;
        this.showFullState.setLayoutData((Object)gridData);
        this.showFullState.addSelectionListener((SelectionListener)this);
        this.backButton = new Button(comp, 8);
        this.backButton.setText("Previous state");
        gridData = new GridData(4, 4, false, false);
        gridData.verticalSpan = 1;
        this.backButton.setLayoutData((Object)gridData);
        this.backButton.addSelectionListener((SelectionListener)this);
        this.showControllables = new Button(comp, 32);
        this.showControllables.setText("Always display disabled controllable events");
        this.showControllables.setSelection(false);
        gridData = new GridData(4, 4, false, false);
        gridData.horizontalSpan = 2;
        this.showControllables.setLayoutData((Object)gridData);
        this.showControllables.addSelectionListener((SelectionListener)this);
        this.searchButton = new Button(comp, 8);
        this.searchButton.setText("Search state");
        gridData = new GridData(4, 4, false, false);
        gridData.minimumHeight = 100;
        gridData.minimumWidth = 300;
        gridData.verticalSpan = 2;
        this.searchButton.setLayoutData((Object)gridData);
        this.searchButton.addSelectionListener((SelectionListener)this);
        this.showPlantRemoveds = new Button(comp, 32);
        this.showPlantRemoveds.setText("Display disabled plant events");
        this.showPlantRemoveds.setSelection(false);
        gridData = new GridData(4, 4, false, false);
        gridData.horizontalSpan = 2;
        this.showPlantRemoveds.setLayoutData((Object)gridData);
        this.showPlantRemoveds.addSelectionListener((SelectionListener)this);
        this.numberStates = new Text(comp, 18436);
        this.numberStates.setTextLimit(5);
        this.numberStates.setText("5");
        gridData = new GridData(4, 4, false, false);
        gridData.widthHint = 30;
        this.numberStates.setLayoutData((Object)gridData);
        this.numberStates.addVerifyListener((VerifyListener)this);
        this.numberStates.addSelectionListener((SelectionListener)this);
        lbl = new Label(comp, 512);
        lbl.setText("Number of displayed states in a chain");
        gridData = new GridData(4, 4, false, false);
        lbl.setLayoutData((Object)gridData);
        gridData = new GridData(4, 4, true, false);
        comp.setLayoutData((Object)gridData);
    }

    public void verifyText(VerifyEvent e) {
        int i = 0;
        while (i < e.text.length()) {
            if (e.text.charAt(i) < '0' || e.text.charAt(i) > '9') {
                e.doit = false;
                return;
            }
            ++i;
        }
    }

    public void setApplication(SynthesisAnalysisEditor app) {
        this.app = app;
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.app == null) {
            return;
        }
        if (e.widget == this.initialState) {
            this.app.clickedResetState();
        } else if (e.widget == this.backButton) {
            this.app.clickedSearch(true);
        } else {
            this.app.clickedSearch(false);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public boolean getFullStateDisplayed() {
        return this.showFullState.getSelection();
    }

    public boolean getDisabledControllablesDisplayed() {
        return this.showControllables.getSelection();
    }

    public boolean getPlantRemovedDisplayed() {
        return this.showPlantRemoveds.getSelection();
    }

    public int getNumberIntermediateStates() {
        String s = this.numberStates.getText();
        if (s.isEmpty()) {
            return 0;
        }
        return Integer.parseInt(s, 10);
    }

    public void setEnableBack(boolean enable) {
        this.backButton.setEnabled(enable);
    }
}

