/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased;

import java.util.ArrayDeque;
import java.util.Set;
import org.eclipse.escet.cif.eventbased.automata.Automaton;
import org.eclipse.escet.cif.eventbased.automata.AutomatonHelper;
import org.eclipse.escet.cif.eventbased.automata.Edge;
import org.eclipse.escet.cif.eventbased.automata.Event;
import org.eclipse.escet.cif.eventbased.automata.Location;
import org.eclipse.escet.cif.eventbased.partitions.PartitionLocation;
import org.eclipse.escet.cif.eventbased.partitions.PartitionRefinement;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.exceptions.InvalidInputException;

public class ObserverCheck
extends PartitionRefinement {
    private ObserverCheck(Set<Event> observableEvents, Set<Event> nonObservableEvents, Set<Set<Location>> partitions) {
        super(observableEvents, nonObservableEvents, partitions);
    }

    public Set<Event> getBadEvents() {
        Set badEvents = Sets.set();
        for (PartitionLocation pl : this.locationMapping.values()) {
            Location loc = pl.loc;
            for (Edge e : loc.getOutgoing()) {
                if (!this.nonObservableEvents.contains(e.event) || ((PartitionLocation)this.locationMapping.get((Object)e.dstLoc)).partition == pl.partition) continue;
                badEvents.add(e.event);
            }
        }
        return badEvents;
    }

    public static Set<Event> doObserverCheck(Automaton aut, Set<Event> observables) {
        String msg;
        Set nonObservables = Sets.set();
        for (Event evt : aut.alphabet) {
            if (observables.contains(evt)) continue;
            nonObservables.add(evt);
        }
        if (nonObservables.isEmpty()) {
            msg = "Non-observable event set is empty, observer check always holds.";
            OutputProvider.warn((String)msg);
            return Sets.set();
        }
        if (nonObservables.size() == aut.alphabet.size()) {
            msg = "Observable event set is empty.";
            throw new InvalidInputException(msg);
        }
        Set marked = Sets.set();
        ArrayDeque<Location> notDone = new ArrayDeque<Location>(100);
        int size = 0;
        Location loc = aut.locations;
        while (loc != null) {
            if (loc.marked) {
                marked.add(loc);
                notDone.add(loc);
            }
            ++size;
            loc = loc.nextLoc;
        }
        AutomatonHelper.expandStatesBackward(marked, notDone, nonObservables);
        if (marked.isEmpty()) {
            String msg2 = "No marked locations found (cannot create initial partitioning).";
            throw new InvalidInputException(msg2);
        }
        Set unmarked = Sets.setc((int)(size - marked.size()));
        Location loc2 = aut.locations;
        while (loc2 != null) {
            if (!marked.contains(loc2)) {
                unmarked.add(loc2);
            }
            loc2 = loc2.nextLoc;
        }
        if (unmarked.isEmpty()) {
            String msg3 = "No unmarked locations found (all locations can reach a marker state through a path with non-observable events).";
            throw new InvalidInputException(msg3);
        }
        Set partitions = Sets.setc((int)2);
        partitions.add(marked);
        partitions.add(unmarked);
        ObserverCheck oc = new ObserverCheck(observables, nonObservables, partitions);
        oc.refinePartitions();
        return oc.getBadEvents();
    }
}

