/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.tooldef.typechecker;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Numbers;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.typechecker.SemanticException;
import org.eclipse.escet.tooldef.common.ToolDefTextUtils;
import org.eclipse.escet.tooldef.common.ToolDefTypeUtils;
import org.eclipse.escet.tooldef.metamodel.java.ToolDefConstructors;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.BoolExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.CastExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.DoubleExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.EmptySetMapExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.Expression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.ListExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.MapEntry;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.MapExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.NullExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.NumberExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.ProjectionExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.SetExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.SliceExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.StringExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.ToolInvokeExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.ToolParamExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.TupleExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.UnresolvedRefExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.VariableExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.BoolType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.DoubleType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.IntType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.ListType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.LongType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.MapType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.SetType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.StringType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.ToolDefType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.TupleType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.TypeParamRef;
import org.eclipse.escet.tooldef.typechecker.CheckerContext;
import org.eclipse.escet.tooldef.typechecker.Message;
import org.eclipse.escet.tooldef.typechecker.ToolInvokeChecker;
import org.eclipse.escet.tooldef.typechecker.TypeHints;
import org.eclipse.escet.tooldef.typechecker.TypesChecker;

public class ExprsChecker {
    private ExprsChecker() {
    }

    public static void tcheck(Expression expr, CheckerContext ctxt, TypeHints hints) {
        if (expr instanceof BoolExpression) {
            BoolExpression bexpr = (BoolExpression)expr;
            ExprsChecker.tcheck(bexpr);
        } else if (expr instanceof CastExpression) {
            CastExpression cexpr = (CastExpression)expr;
            ExprsChecker.tcheck(cexpr, ctxt);
        } else if (expr instanceof DoubleExpression) {
            DoubleExpression dexpr = (DoubleExpression)expr;
            ExprsChecker.tcheck(dexpr, ctxt);
        } else if (expr instanceof EmptySetMapExpression) {
            EmptySetMapExpression emptyExpr = (EmptySetMapExpression)expr;
            ExprsChecker.tcheck(emptyExpr, ctxt, hints);
        } else if (expr instanceof ListExpression) {
            ListExpression lexpr = (ListExpression)expr;
            ExprsChecker.tcheck(lexpr, ctxt, hints);
        } else if (expr instanceof MapExpression) {
            MapExpression mexpr = (MapExpression)expr;
            ExprsChecker.tcheck(mexpr, ctxt, hints);
        } else if (expr instanceof NullExpression) {
            ExprsChecker.tcheck((NullExpression)expr, hints);
        } else if (expr instanceof NumberExpression) {
            NumberExpression nexpr = (NumberExpression)expr;
            ExprsChecker.tcheck(nexpr, ctxt);
        } else if (expr instanceof ProjectionExpression) {
            ProjectionExpression pexpr = (ProjectionExpression)expr;
            ExprsChecker.tcheck(pexpr, ctxt);
        } else if (expr instanceof SetExpression) {
            SetExpression sexpr = (SetExpression)expr;
            ExprsChecker.tcheck(sexpr, ctxt, hints);
        } else if (expr instanceof SliceExpression) {
            SliceExpression sexpr = (SliceExpression)expr;
            ExprsChecker.tcheck(sexpr, ctxt, hints);
        } else if (expr instanceof StringExpression) {
            StringExpression sexpr = (StringExpression)expr;
            ExprsChecker.tcheck(sexpr);
        } else if (expr instanceof ToolInvokeExpression) {
            ToolInvokeExpression texpr = (ToolInvokeExpression)expr;
            ExprsChecker.tcheck(texpr, ctxt);
        } else {
            if (expr instanceof ToolParamExpression) {
                throw new RuntimeException("Already resolved ref? " + String.valueOf(expr));
            }
            if (expr instanceof TupleExpression) {
                TupleExpression texpr = (TupleExpression)expr;
                ExprsChecker.tcheck(texpr, ctxt, hints);
            } else if (expr instanceof UnresolvedRefExpression) {
                UnresolvedRefExpression uexpr = (UnresolvedRefExpression)expr;
                ExprsChecker.tcheck(uexpr, ctxt);
            } else {
                if (expr instanceof VariableExpression) {
                    throw new RuntimeException("Already resolved ref? " + String.valueOf(expr));
                }
                throw new RuntimeException("Unknown expr: " + String.valueOf(expr));
            }
        }
    }

    private static void tcheck(BoolExpression expr) {
        expr.setType((ToolDefType)ToolDefConstructors.newBoolType((Boolean)false, null));
    }

    private static void tcheck(CastExpression expr, CheckerContext ctxt) {
        TypesChecker.tcheck(expr.getType(), ctxt);
        ToolDefType targetType = expr.getType();
        targetType = ToolDefTypeUtils.normalizeType((ToolDefType)targetType);
        TypeHints childHints = new TypeHints();
        childHints.add(targetType);
        ExprsChecker.tcheck(expr.getChild(), ctxt, childHints);
        ToolDefType childType = expr.getChild().getType();
        childType = ToolDefTypeUtils.normalizeType((ToolDefType)childType);
        if (!(ToolDefTypeUtils.isSuperType((ToolDefType)targetType, (ToolDefType)childType) || ToolDefTypeUtils.isSubType((ToolDefType)targetType, (ToolDefType)childType) || !childType.isNullable() && !targetType.isNullable() && childType instanceof StringType && (targetType instanceof BoolType || targetType instanceof IntType || targetType instanceof LongType || targetType instanceof DoubleType))) {
            ctxt.addProblem(Message.INVALID_CAST, expr.getPosition(), ToolDefTextUtils.typeToStr((ToolDefType)childType), ToolDefTextUtils.typeToStr((ToolDefType)targetType));
            throw new SemanticException();
        }
    }

    private static void tcheck(DoubleExpression expr, CheckerContext ctxt) {
        double value;
        expr.setType((ToolDefType)ToolDefConstructors.newDoubleType((Boolean)false, null));
        try {
            value = Double.parseDouble(expr.getValue());
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e);
        }
        if (Double.isInfinite(value)) {
            ctxt.addProblem(Message.VALUE_OVERFLOW, expr.getPosition(), "Real", expr.getValue());
            throw new SemanticException();
        }
        Assert.check((!Double.isNaN(value) ? 1 : 0) != 0);
        Assert.check((value >= 0.0 ? 1 : 0) != 0);
    }

    private static void tcheck(EmptySetMapExpression expr, CheckerContext ctxt, TypeHints hints) {
        for (ToolDefType hint : hints) {
            if (hint instanceof SetType) {
                SetType stype = (SetType)hint;
                SetType type = (SetType)EMFHelper.deepclone((EObject)stype);
                type.setNullable(false);
                SetExpression rslt = ToolDefConstructors.newSetExpression(null, (Position)expr.getPosition(), (ToolDefType)type);
                EMFHelper.updateParentContainment((EObject)expr, (EObject)rslt);
                return;
            }
            if (!(hint instanceof MapType)) continue;
            MapType mtype = (MapType)hint;
            MapType type = (MapType)EMFHelper.deepclone((EObject)mtype);
            type.setNullable(false);
            MapExpression rslt = ToolDefConstructors.newMapExpression(null, (Position)expr.getPosition(), (ToolDefType)type);
            EMFHelper.updateParentContainment((EObject)expr, (EObject)rslt);
            return;
        }
        ctxt.addProblem(Message.EXPR_UNKNOWN_TYPE, expr.getPosition(), "{}");
        throw new SemanticException();
    }

    private static void tcheck(ListExpression expr, CheckerContext ctxt, TypeHints hints) {
        TypeHints elemHints = new TypeHints();
        for (ToolDefType hint : hints) {
            if (!(hint instanceof ListType)) continue;
            ListType ltype = (ListType)hint;
            elemHints.add(ltype.getElemType());
        }
        int size = expr.getElements().size();
        int i = 0;
        while (i < size) {
            Expression elem = (Expression)expr.getElements().get(i);
            ExprsChecker.tcheck(elem, ctxt, elemHints);
            ++i;
        }
        ToolDefType elemType = null;
        boolean unique = false;
        if (size == 0) {
            Iterator<ToolDefType> iterator = elemHints.iterator();
            if (iterator.hasNext()) {
                ToolDefType elemHint;
                elemType = elemHint = iterator.next();
            }
            if (elemType == null) {
                ctxt.addProblem(Message.EXPR_UNKNOWN_TYPE, expr.getPosition(), "[]");
                throw new SemanticException();
            }
        } else {
            for (Expression elem : expr.getElements()) {
                if (elemType == null) {
                    elemType = elem.getType();
                    continue;
                }
                elemType = ToolDefTypeUtils.mergeTypes((ToolDefType)elemType, (ToolDefType)elem.getType());
                unique = true;
            }
        }
        if (!unique) {
            elemType = (ToolDefType)EMFHelper.deepclone((EObject)elemType);
        }
        expr.setType((ToolDefType)ToolDefConstructors.newListType((ToolDefType)elemType, (Boolean)false, null));
    }

    private static void tcheck(MapExpression expr, CheckerContext ctxt, TypeHints hints) {
        TypeHints keyHints = new TypeHints();
        TypeHints valueHints = new TypeHints();
        for (ToolDefType hint : hints) {
            if (!(hint instanceof MapType)) continue;
            MapType mtype = (MapType)hint;
            keyHints.add(mtype.getKeyType());
            valueHints.add(mtype.getValueType());
        }
        for (MapEntry entry : expr.getEntries()) {
            ExprsChecker.tcheck(entry.getKey(), ctxt, keyHints);
            ExprsChecker.tcheck(entry.getValue(), ctxt, valueHints);
        }
        ToolDefType keyType = null;
        ToolDefType valueType = null;
        boolean unique = false;
        for (MapEntry entry : expr.getEntries()) {
            if (keyType == null) {
                keyType = entry.getKey().getType();
                valueType = entry.getValue().getType();
                continue;
            }
            keyType = ToolDefTypeUtils.mergeTypes((ToolDefType)keyType, (ToolDefType)entry.getKey().getType());
            valueType = ToolDefTypeUtils.mergeTypes((ToolDefType)valueType, (ToolDefType)entry.getValue().getType());
            unique = true;
        }
        if (!unique) {
            keyType = (ToolDefType)EMFHelper.deepclone(keyType);
        }
        if (!unique) {
            valueType = (ToolDefType)EMFHelper.deepclone(valueType);
        }
        expr.setType((ToolDefType)ToolDefConstructors.newMapType((ToolDefType)keyType, (Boolean)false, null, (ToolDefType)valueType));
    }

    private static void tcheck(NullExpression expr, TypeHints hints) {
        for (ToolDefType hint : hints) {
            if (!hint.isNullable()) continue;
            expr.setType((ToolDefType)EMFHelper.deepclone((EObject)hint));
            return;
        }
        for (ToolDefType hint : hints) {
            if (hint instanceof TypeParamRef) continue;
            ToolDefType t = (ToolDefType)EMFHelper.deepclone((EObject)hint);
            t.setNullable(true);
            expr.setType(t);
            return;
        }
        expr.setType((ToolDefType)ToolDefConstructors.newObjectType((Boolean)true, null));
    }

    private static void tcheck(NumberExpression expr, CheckerContext ctxt) {
        try {
            Integer.parseInt(expr.getValue());
            expr.setType((ToolDefType)ToolDefConstructors.newIntType((Boolean)false, null));
            return;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Long.parseLong(expr.getValue());
                expr.setType((ToolDefType)ToolDefConstructors.newLongType((Boolean)false, null));
                return;
            }
            catch (NumberFormatException numberFormatException2) {
                ctxt.addProblem(Message.VALUE_OVERFLOW, expr.getPosition(), "Integer/long", Numbers.formatNumber((String)expr.getValue()));
                throw new SemanticException();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void tcheck(ProjectionExpression expr, CheckerContext ctxt) {
        ToolDefType resultType;
        ExprsChecker.tcheck(expr.getChild(), ctxt, TypeHints.NO_HINTS);
        ToolDefType childType = expr.getChild().getType();
        childType = ToolDefTypeUtils.normalizeType((ToolDefType)childType);
        if (childType.isNullable() || !(childType instanceof ListType) && !(childType instanceof MapType) && !(childType instanceof StringType) && !(childType instanceof TupleType)) {
            ctxt.addProblem(Message.PROJ_CHILD_TYPE, expr.getPosition(), ToolDefTextUtils.typeToStr((ToolDefType)childType));
            throw new SemanticException();
        }
        TypeHints indexHints = new TypeHints();
        if (childType instanceof ListType) {
            indexHints.add((ToolDefType)TypesChecker.NON_NULLABLE_INT_TYPE);
        } else if (childType instanceof MapType) {
            indexHints.add(((MapType)childType).getKeyType());
        } else if (childType instanceof StringType) {
            indexHints.add((ToolDefType)TypesChecker.NON_NULLABLE_INT_TYPE);
        } else if (childType instanceof TupleType) {
            indexHints.add((ToolDefType)TypesChecker.NON_NULLABLE_INT_TYPE);
        } else {
            throw new RuntimeException("Unexpected child type: " + String.valueOf(childType));
        }
        ExprsChecker.tcheck(expr.getIndex(), ctxt, indexHints);
        Expression index = expr.getIndex();
        ToolDefType indexType = index.getType();
        indexType = ToolDefTypeUtils.normalizeType((ToolDefType)indexType);
        if (childType instanceof ListType) {
            ListType ltype = (ListType)childType;
            if (!(indexType instanceof IntType) || indexType.isNullable()) {
                ctxt.addProblem(Message.PROJ_INDEX_TYPE, expr.getPosition(), ToolDefTextUtils.typeToStr((ToolDefType)childType), ToolDefTextUtils.typeToStr((ToolDefType)indexType), "int");
                throw new SemanticException();
            }
            resultType = (ToolDefType)EMFHelper.deepclone((EObject)ltype.getElemType());
        } else if (childType instanceof MapType) {
            MapType mtype = (MapType)childType;
            ToolDefType keyType = mtype.getKeyType();
            if (!ToolDefTypeUtils.isSubType((ToolDefType)indexType, (ToolDefType)keyType)) {
                ctxt.addProblem(Message.PROJ_INDEX_TYPE, expr.getPosition(), ToolDefTextUtils.typeToStr((ToolDefType)childType), ToolDefTextUtils.typeToStr((ToolDefType)indexType), ToolDefTextUtils.typeToStr((ToolDefType)keyType));
                throw new SemanticException();
            }
            resultType = (ToolDefType)EMFHelper.deepclone((EObject)mtype.getValueType());
        } else if (childType instanceof StringType) {
            if (!(indexType instanceof IntType) || indexType.isNullable()) {
                ctxt.addProblem(Message.PROJ_INDEX_TYPE, expr.getPosition(), ToolDefTextUtils.typeToStr((ToolDefType)childType), ToolDefTextUtils.typeToStr((ToolDefType)indexType), "int");
                throw new SemanticException();
            }
            resultType = (ToolDefType)EMFHelper.deepclone((EObject)childType);
        } else if (childType instanceof TupleType) {
            void numIndex;
            TupleType ttype = (TupleType)childType;
            if (!(indexType instanceof IntType) || indexType.isNullable()) {
                ctxt.addProblem(Message.PROJ_INDEX_TYPE, expr.getPosition(), ToolDefTextUtils.typeToStr((ToolDefType)childType), ToolDefTextUtils.typeToStr((ToolDefType)indexType), "int");
                throw new SemanticException();
            }
            if (!(index instanceof NumberExpression)) {
                ctxt.addProblem(Message.PROJ_TUPLE_NON_LIT, expr.getPosition(), new String[0]);
                throw new SemanticException();
            }
            NumberExpression numberExpression = (NumberExpression)index;
            int idx = Integer.parseInt(numIndex.getValue());
            if (idx < 0 || idx >= ttype.getFields().size()) {
                ctxt.addProblem(Message.PROJ_TUPLE_BOUND, expr.getPosition(), ToolDefTextUtils.typeToStr((ToolDefType)childType), Integer.toString(idx));
                throw new SemanticException();
            }
            resultType = (ToolDefType)EMFHelper.deepclone((EObject)((ToolDefType)ttype.getFields().get(idx)));
        } else {
            throw new RuntimeException("Unexpected child type: " + String.valueOf(childType));
        }
        expr.setType(resultType);
    }

    private static void tcheck(SetExpression expr, CheckerContext ctxt, TypeHints hints) {
        Assert.check((!expr.getElements().isEmpty() ? 1 : 0) != 0);
        TypeHints elemHints = new TypeHints();
        for (ToolDefType hint : hints) {
            if (!(hint instanceof SetType)) continue;
            SetType stype = (SetType)hint;
            elemHints.add(stype.getElemType());
        }
        int size = expr.getElements().size();
        int i = 0;
        while (i < size) {
            Expression elem = (Expression)expr.getElements().get(i);
            ExprsChecker.tcheck(elem, ctxt, elemHints);
            ++i;
        }
        ToolDefType elemType = null;
        boolean unique = false;
        for (Expression elem : expr.getElements()) {
            if (elemType == null) {
                elemType = elem.getType();
                continue;
            }
            elemType = ToolDefTypeUtils.mergeTypes((ToolDefType)elemType, (ToolDefType)elem.getType());
            unique = true;
        }
        if (!unique) {
            elemType = (ToolDefType)EMFHelper.deepclone(elemType);
        }
        expr.setType((ToolDefType)ToolDefConstructors.newSetType((ToolDefType)elemType, (Boolean)false, null));
    }

    private static void tcheck(SliceExpression expr, CheckerContext ctxt, TypeHints hints) {
        ExprsChecker.tcheck(expr.getChild(), ctxt, hints);
        ToolDefType childType = expr.getChild().getType();
        childType = ToolDefTypeUtils.normalizeType((ToolDefType)childType);
        if (childType.isNullable() || !(childType instanceof ListType) && !(childType instanceof StringType)) {
            ctxt.addProblem(Message.SLICE_CHILD_TYPE, expr.getPosition(), ToolDefTextUtils.typeToStr((ToolDefType)childType));
            throw new SemanticException();
        }
        if (expr.getBegin() != null) {
            ExprsChecker.tcheck(expr.getBegin(), ctxt, TypesChecker.NON_NULLABLE_INT_HINT);
            ToolDefType beginType = expr.getBegin().getType();
            beginType = ToolDefTypeUtils.normalizeType((ToolDefType)beginType);
            if (!(beginType instanceof IntType) || beginType.isNullable()) {
                ctxt.addProblem(Message.SLICE_IDX_NON_INT, expr.getBegin().getPosition(), "begin", ToolDefTextUtils.typeToStr((ToolDefType)beginType));
                throw new SemanticException();
            }
        }
        if (expr.getEnd() != null) {
            ExprsChecker.tcheck(expr.getEnd(), ctxt, TypesChecker.NON_NULLABLE_INT_HINT);
            ToolDefType endType = expr.getEnd().getType();
            endType = ToolDefTypeUtils.normalizeType((ToolDefType)endType);
            if (!(endType instanceof IntType) || endType.isNullable()) {
                ctxt.addProblem(Message.SLICE_IDX_NON_INT, expr.getEnd().getPosition(), "end", ToolDefTextUtils.typeToStr((ToolDefType)endType));
                throw new SemanticException();
            }
        }
        expr.setType((ToolDefType)EMFHelper.deepclone((EObject)childType));
    }

    private static void tcheck(StringExpression expr) {
        expr.setType((ToolDefType)ToolDefConstructors.newStringType((Boolean)false, null));
    }

    private static void tcheck(ToolInvokeExpression expr, CheckerContext ctxt) {
        ToolInvokeChecker.tcheck(expr, ctxt, true);
    }

    private static void tcheck(TupleExpression expr, CheckerContext ctxt, TypeHints hints) {
        int size = expr.getElements().size();
        TypeHints[] elemHints = new TypeHints[size];
        int i = 0;
        while (i < size) {
            elemHints[i] = new TypeHints();
            ++i;
        }
        for (ToolDefType hint : hints) {
            if (!(hint instanceof TupleType)) continue;
            TupleType ttype = (TupleType)hint;
            EList fields = ttype.getFields();
            int cnt = Math.min(elemHints.length, fields.size());
            int i2 = 0;
            while (i2 < cnt) {
                elemHints[i2].add((ToolDefType)fields.get(i2));
                ++i2;
            }
        }
        i = 0;
        while (i < size) {
            Expression elem = (Expression)expr.getElements().get(i);
            ExprsChecker.tcheck(elem, ctxt, elemHints[i]);
            ++i;
        }
        List elemTypes = Lists.listc((int)size);
        for (Expression elem : expr.getElements()) {
            elemTypes.add((ToolDefType)EMFHelper.deepclone((EObject)elem.getType()));
        }
        expr.setType((ToolDefType)ToolDefConstructors.newTupleType((List)elemTypes, (Boolean)false, null));
    }

    private static void tcheck(UnresolvedRefExpression expr, CheckerContext ctxt) {
        Expression resolved = ctxt.resolveValue(expr.getName(), expr.getPosition());
        EMFHelper.updateParentContainment((EObject)expr, (EObject)resolved);
    }
}

