/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.declwrap;

import java.util.List;
import java.util.Map;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.Equation;
import org.eclipse.escet.cif.metamodel.cif.annotations.Annotation;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.parser.ast.ACifObject;
import org.eclipse.escet.cif.parser.ast.AEquation;
import org.eclipse.escet.cif.parser.ast.AEquationDecl;
import org.eclipse.escet.cif.parser.ast.automata.ALocation;
import org.eclipse.escet.cif.parser.ast.declarations.AContVariable;
import org.eclipse.escet.cif.parser.ast.declarations.AContVariableDecl;
import org.eclipse.escet.cif.parser.ast.expressions.AExpression;
import org.eclipse.escet.cif.typechecker.CheckStatus;
import org.eclipse.escet.cif.typechecker.CifAnnotationsTypeChecker;
import org.eclipse.escet.cif.typechecker.CifExprsTypeChecker;
import org.eclipse.escet.cif.typechecker.CifTypeChecker;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.declwrap.DeclWrap;
import org.eclipse.escet.cif.typechecker.scopes.ParentScope;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class ContVariableDeclWrap
extends DeclWrap<ContVariable> {
    private final AContVariableDecl astDecls;
    private final AContVariable astDecl;

    public ContVariableDeclWrap(CifTypeChecker tchecker, ParentScope<?> scope, AContVariableDecl astDecls, AContVariable astDecl, ContVariable mmDecl) {
        super(tchecker, scope, mmDecl);
        this.astDecls = astDecls;
        this.astDecl = astDecl;
    }

    @Override
    public String getName() {
        return ((ContVariable)this.mmDecl).getName();
    }

    @Override
    public String getAbsName() {
        return CifTextUtils.getAbsName((PositionObject)this.mmDecl);
    }

    @Override
    public void tcheckForUseImpl() {
        this.checkName();
        this.status = CheckStatus.USE;
    }

    @Override
    public void tcheckFull() {
        this.tcheckForUse();
        if (this.isCheckedFull()) {
            return;
        }
        List<Annotation> annos = CifAnnotationsTypeChecker.transAnnotations(this.astDecls.annotations, this.scope, this.tchecker);
        ((ContVariable)this.mmDecl).getAnnotations().addAll(annos);
        AExpression avalue = this.astDecl.value;
        if (avalue != null) {
            Expression value = CifExprsTypeChecker.transExpression(this.astDecl.value, (CifType)CifExprsTypeChecker.REAL_TYPE_HINT, this.scope, null, this.tchecker);
            ((ContVariable)this.mmDecl).setValue(value);
            CifType vtype = value.getType();
            CifType nvtype = CifTypeUtils.normalizeType((CifType)vtype);
            if (!(nvtype instanceof RealType)) {
                this.tchecker.addProblem(ErrMsg.CONT_VAR_TYPE_VALUE_MISMATCH, this.astDecl.value.position, CifTextUtils.typeToStr((CifType)vtype), this.getAbsName());
            }
        }
        this.checkDerivatives();
        this.status = CheckStatus.FULL;
    }

    private void checkDerivatives() {
        boolean inDecl;
        boolean bl = inDecl = this.astDecl.derivative != null;
        if (inDecl) {
            Expression der = CifExprsTypeChecker.transExpression(this.astDecl.derivative, (CifType)CifExprsTypeChecker.REAL_TYPE_HINT, this.scope, null, this.tchecker);
            ((ContVariable)this.mmDecl).setDerivative(der);
            CifType dtype = der.getType();
            CifType ndtype = CifTypeUtils.normalizeType((CifType)dtype);
            if (!(ndtype instanceof RealType)) {
                this.tchecker.addProblem(ErrMsg.CONT_VAR_DER_TYPE, this.astDecl.position, CifTextUtils.typeToStr((CifType)dtype), this.getAbsName());
            }
        }
        List<AEquation> eqns = this.scope.astEquations.get(this.getName());
        List inComp = Lists.list();
        Map inLocs = Maps.map();
        if (eqns != null) {
            for (AEquation aEquation : eqns) {
                ACifObject parent = aEquation.parent;
                Assert.notNull((Object)parent);
                if (parent instanceof AEquationDecl) {
                    inComp.add(aEquation);
                } else {
                    Assert.check((boolean)(parent instanceof ALocation));
                    List prev = (List)inLocs.get(parent);
                    if (prev == null) {
                        prev = Lists.listc((int)1);
                        inLocs.put((ALocation)parent, prev);
                    }
                    prev.add(aEquation);
                }
                Equation eqn = CifConstructors.newEquation();
                eqn.setPosition(aEquation.createPosition());
                eqn.setDerivative(aEquation.derivative);
                eqn.setVariable((Declaration)this.mmDecl);
                this.scope.mmEquations.put(aEquation, eqn);
                if (!aEquation.derivative) {
                    this.tchecker.addProblem(ErrMsg.EQN_CONT_NON_DER, aEquation.position, this.getAbsName());
                }
                Expression value = CifExprsTypeChecker.transExpression(aEquation.value, (CifType)CifExprsTypeChecker.REAL_TYPE_HINT, this.scope, null, this.tchecker);
                eqn.setValue(value);
                CifType dtype = value.getType();
                CifType ndtype = CifTypeUtils.normalizeType((CifType)dtype);
                if (ndtype instanceof RealType) continue;
                this.tchecker.addProblem(ErrMsg.CONT_VAR_DER_TYPE, aEquation.position, CifTextUtils.typeToStr((CifType)dtype), this.getAbsName());
            }
        }
        if (inDecl && !inComp.isEmpty() || inComp.size() > 1) {
            if (inDecl) {
                this.tchecker.addProblem(ErrMsg.DUPL_DER_FOR_CONT_VAR, this.astDecl.position, this.getAbsName());
            }
            for (AEquation aEquation : inComp) {
                this.tchecker.addProblem(ErrMsg.DUPL_DER_FOR_CONT_VAR, aEquation.position, this.getAbsName());
            }
        }
        for (Map.Entry entry : inLocs.entrySet()) {
            if (!inDecl && inComp.isEmpty() && ((List)entry.getValue()).size() <= 1) continue;
            if (inDecl) {
                this.tchecker.addProblem(ErrMsg.DUPL_DER_FOR_CONT_VAR, this.astDecl.position, this.getAbsName());
            }
            for (AEquation eqn : inComp) {
                this.tchecker.addProblem(ErrMsg.DUPL_DER_FOR_CONT_VAR, eqn.position, this.getAbsName());
            }
            for (AEquation eqn : (List)entry.getValue()) {
                this.tchecker.addProblem(ErrMsg.DUPL_DER_FOR_CONT_VAR, eqn.position, this.getAbsName());
            }
        }
        if (!inDecl && inComp.isEmpty() && inLocs.isEmpty()) {
            this.tchecker.addProblem(ErrMsg.CONT_VAR_NO_DER, this.astDecl.position, this.getAbsName());
        }
        if (!inLocs.isEmpty() && this.scope.getAstLocs().size() != inLocs.size()) {
            for (ALocation aLocation : this.scope.getAstLocs()) {
                if (inLocs.containsKey(aLocation)) continue;
                this.tchecker.addProblem(ErrMsg.CONT_VAR_NO_DER, aLocation.position, this.getAbsName());
            }
        }
    }
}

