/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.update;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.update.DebugEventHandler;
import org.eclipse.debug.internal.ui.viewers.update.EventHandlerModelProxy;
import org.eclipse.jface.viewers.Viewer;

public class ProcessProxy
extends EventHandlerModelProxy {
    private IProcess fProcess;
    private final DebugEventHandler fProcessEventHandler = new DebugEventHandler(this){

        @Override
        protected boolean handlesEvent(DebugEvent event) {
            return event.getSource().equals(ProcessProxy.this.fProcess);
        }

        @Override
        protected void handleChange(DebugEvent event) {
            ProcessProxy.this.fireProcessDelta(2048);
        }

        @Override
        protected void handleCreate(DebugEvent event) {
        }

        @Override
        protected void handleTerminate(DebugEvent event) {
            ProcessProxy.this.fireProcessDelta(0x800800);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireProcessDelta(int flags) {
        ModelDelta delta = null;
        ProcessProxy processProxy = this;
        synchronized (processProxy) {
            if (!this.isDisposed()) {
                ModelDelta node = delta = new ModelDelta(DebugPlugin.getDefault().getLaunchManager(), 0);
                node = node.addNode(this.fProcess.getLaunch(), 0);
                node.addNode(this.fProcess, flags);
            }
        }
        if (delta != null && !this.isDisposed()) {
            this.fireModelChanged(delta);
        }
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        this.fProcess = null;
    }

    public ProcessProxy(IProcess process) {
        this.fProcess = process;
    }

    @Override
    protected synchronized boolean containsEvent(DebugEvent event) {
        return event.getSource().equals(this.fProcess);
    }

    @Override
    protected DebugEventHandler[] createEventHandlers() {
        return new DebugEventHandler[]{this.fProcessEventHandler};
    }

    @Override
    public void installed(Viewer viewer) {
        super.installed(viewer);
        IProcess process = this.fProcess;
        if (process != null) {
            if (process.isTerminated()) {
                this.fireProcessDelta(0x800000);
            } else {
                ILaunch launch = process.getLaunch();
                if (launch != null && "run".equals(launch.getLaunchMode())) {
                    ModelDelta delta = new ModelDelta(DebugPlugin.getDefault().getLaunchManager(), 0);
                    ModelDelta node = delta.addNode(process.getLaunch(), 0);
                    node = node.addNode(process, 0x200000);
                    this.fireModelChanged(delta);
                }
            }
        }
    }
}

