/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.runtime.ode;

import org.eclipse.escet.cif.simulator.options.FrameRateOption;
import org.eclipse.escet.common.app.framework.options.DoubleOption;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.java.exceptions.InvalidOptionException;

public class OdeSolverOutStepOption
extends DoubleOption {
    public OdeSolverOutStepOption() {
        super("ODE solver fixed output step size", "Specifies that ODE solver output should only contain output for multiples of the given step size, besides the start and end points of the time transitions. The step size must be an integer or real number larger than zero. Specify \"auto\" (default) to disable the fixed step size output and let the integrator determine the output points (dynamic output step size) if real-time simulation is disabled, and to use the model time delta used for real-time simulation as fixed output step size if real-time simulation is enabled.", null, "solver-outstep", "OUTSTP", null, Double.valueOf(0.0), null, true, "If a fixed output step size is used, trajectory data points are only outputted for multiples of the given step size, besides the start and end points of the time transitions. If set to automatic, the integrator determines the output points (dynamic output step size) if real-time simulation is disabled, and the model time delta used for real-time simulation is used as fixed output step size if real-time simulation is enabled.", "Step size:", true, Double.valueOf(0.1), "auto", "Automatic output step size", "Custom fixed output step size");
    }

    public static Double getSolverOutStep() {
        Double stepSize = (Double)Options.get(OdeSolverOutStepOption.class);
        Double delta = FrameRateOption.getModelTimeDelta();
        if (delta == null) {
            return stepSize;
        }
        if (stepSize != null) {
            String msg = "Setting a custom ODE solver fixed output step size while real-time simulation is enabled, is not supported.";
            throw new InvalidOptionException(msg);
        }
        return delta;
    }

    public void verifyValue(Double value) {
        if (value == null) {
            return;
        }
        OdeSolverOutStepOption.checkValue((value > 0.0 ? 1 : 0) != 0, (String)(String.valueOf(value) + " <= 0"));
    }
}

